/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;

public class PrintWriter
extends Writer {
    protected Writer out;
    private boolean ioError;
    private boolean autoFlush;

    public PrintWriter(OutputStream out) {
        this(new OutputStreamWriter(out), false);
    }

    public PrintWriter(OutputStream out, boolean autoFlush) {
        this(new OutputStreamWriter(out), autoFlush);
    }

    public PrintWriter(Writer wr) {
        this(wr, false);
    }

    public PrintWriter(Writer wr, boolean autoFlush) {
        super(wr);
        this.autoFlush = autoFlush;
        this.out = wr;
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(file))), false);
    }

    public PrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), csn), false);
    }

    public PrintWriter(String fileName) throws FileNotFoundException {
        this(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(fileName))), false);
    }

    public PrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fileName)), csn), false);
    }

    @Override
    public boolean checkError() {
        Writer delegate = this.out;
        if (delegate == null) {
            return this.ioError;
        }
        this.flush();
        return this.ioError || delegate.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearError() {
        Object object = this.lock;
        synchronized (object) {
            this.ioError = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    this.setError();
                }
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.flush();
                }
                catch (IOException e) {
                    this.setError();
                }
            } else {
                this.setError();
            }
        }
    }

    public PrintWriter format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public PrintWriter format(Locale l, String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format == null");
        }
        new Formatter(this, l).format(format, args);
        if (this.autoFlush) {
            this.flush();
        }
        return this;
    }

    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    public void print(char[] charArray) {
        this.print(new String(charArray, 0, charArray.length));
    }

    public void print(char ch) {
        this.print(String.valueOf(ch));
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum));
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum));
    }

    public void print(int inum) {
        this.print(String.valueOf(inum));
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum));
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void print(String str) {
        this.write(str != null ? str : String.valueOf(null));
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.print(System.lineSeparator());
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    public void println(char[] chars) {
        this.println(new String(chars, 0, chars.length));
    }

    public void println(char c) {
        this.println(String.valueOf(c));
    }

    public void println(double d) {
        this.println(String.valueOf(d));
    }

    public void println(float f) {
        this.println(String.valueOf(f));
    }

    public void println(int i) {
        this.println(String.valueOf(i));
    }

    public void println(long l) {
        this.println(String.valueOf(l));
    }

    public void println(Object obj) {
        this.println(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.print(str);
            this.println();
        }
    }

    public void println(boolean b) {
        this.println(String.valueOf(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError() {
        Object object = this.lock;
        synchronized (object) {
            this.ioError = true;
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        this.doWrite(buf, offset, count);
    }

    @Override
    public void write(int oneChar) {
        this.doWrite(new char[]{(char)oneChar}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doWrite(char[] buf, int offset, int count) {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                try {
                    this.out.write(buf, offset, count);
                }
                catch (IOException e) {
                    this.setError();
                }
            } else {
                this.setError();
            }
        }
    }

    @Override
    public void write(String str) {
        this.write(str.toCharArray());
    }

    @Override
    public void write(String str, int offset, int count) {
        this.write(str.substring(offset, offset + count).toCharArray());
    }

    @Override
    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            csq = "null";
        }
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        String output = csq.subSequence(start, end).toString();
        this.write(output, 0, output.length());
        return this;
    }
}

