/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.bugvm.rt.VM;
import java.util.Arrays;

public final class VMStack {
    public static ClassLoader getCallingClassLoader() {
        return VM.getStackClasses(1, 1)[0].getClassLoader();
    }

    public static Class<?> getStackClass2() {
        Class<?>[] classes = VM.getStackClasses(2, 1);
        return classes != null && classes.length > 0 ? classes[0] : null;
    }

    public static Class<?>[] getClasses(int maxDepth) {
        return VM.getStackClasses(1, maxDepth);
    }

    public static ClassLoader getClosestUserClassLoader(ClassLoader bootstrap, ClassLoader system) {
        Class<?>[] stackClasses;
        for (Class<?> stackClass : stackClasses = VMStack.getClasses(-1)) {
            ClassLoader loader = stackClass.getClassLoader();
            if (loader == null || loader == bootstrap || loader == system) continue;
            return loader;
        }
        return null;
    }

    public static StackTraceElement[] getThreadStackTrace(Thread t) {
        return t.getStackTrace();
    }

    public static int fillStackTraceElements(Thread t, StackTraceElement[] stackTraceElements) {
        Arrays.fill(stackTraceElements, null);
        StackTraceElement[] st = t.getStackTrace();
        int n = Math.min(st.length, stackTraceElements.length);
        System.arraycopy((Object)st, 0, (Object)stackTraceElements, 0, n);
        return n;
    }
}

