/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.bugvm.rt.VM;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;

public final class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();

    private VMRuntime() {
    }

    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public String[] properties() {
        return EmptyArray.STRING;
    }

    public String bootClassPath() {
        return VM.bootClassPath();
    }

    public String classPath() {
        return VM.classPath();
    }

    public native float getTargetHeapUtilization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    public void setTargetSdkVersion(int targetSdkVersion) {
    }

    @Deprecated
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    public void gcSoftReferences() {
    }

    @Deprecated
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private void nativeSetTargetHeapUtilization(float newTarget) {
    }

    @Deprecated
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    public void trackExternalFree(long size) {
    }

    @Deprecated
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public void startJitCompilation() {
    }

    public void disableJitCompilation() {
    }

    public Object newNonMovableArray(Class<?> componentType, int length) {
        return Array.newInstance(componentType, length);
    }

    public long addressOf(Object array) {
        return VM.getArrayValuesAddress(array);
    }

    public native void clearGrowthLimit();

    public boolean isDebuggerActive() {
        return false;
    }

    public void registerNativeAllocation(int bytes) {
    }

    public void registerNativeFree(int bytes) {
    }

    public void preloadDexCaches() {
    }
}

