/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro.ptr;

import com.bugvm.rt.VM;
import com.bugvm.rt.bro.MarshalerLookup;
import com.bugvm.rt.bro.NativeObject;
import com.bugvm.rt.bro.Struct;
import com.bugvm.rt.bro.annotation.Pointer;
import com.bugvm.rt.bro.annotation.StructMember;
import java.lang.reflect.ParameterizedType;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Ptr<S extends NativeObject, T extends Ptr<S, T>>
extends Struct<T> {
    private static final ConcurrentHashMap<Class<?>, Class<?>> TYPE_CACHE = new ConcurrentHashMap();

    public Ptr() {
    }

    public Ptr(T o) {
    }

    @StructMember(value=0)
    @Pointer
    native long getValue();

    @StructMember(value=0)
    native void setValue(@Pointer long var1);

    public S get() {
        long v = this.getValue();
        if (v == 0L) {
            return null;
        }
        return this.toObject(v);
    }

    public T set(S o) {
        if (o == null) {
            this.setValue(0L);
        } else {
            this.setValue(((NativeObject)o).getHandle());
        }
        return (T)this;
    }

    public T set(long handle) {
        this.setValue(handle);
        return (T)this;
    }

    public void set(S[] src) {
        this.set((NativeObject[])src, 0, src.length);
    }

    public void set(S[] src, int offset, int count) {
        int ptrSize = this._sizeOf();
        long ptr = this.getHandle() + (long)(ptrSize * offset);
        for (int i = 0; i < count; ++i) {
            S o = src[i];
            VM.setPointer(ptr, o == null ? 0L : ((NativeObject)o).getHandle());
            ptr += (long)ptrSize;
        }
    }

    private S toObject(long handle) {
        Class type = TYPE_CACHE.get(this.getClass());
        if (type == null) {
            type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            TYPE_CACHE.put(this.getClass(), type);
        }
        return (S)MarshalerLookup.toObject(type, handle);
    }
}

