/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.VM;
import com.bugvm.rt.bro.annotation.MarshalsArray;
import com.bugvm.rt.bro.annotation.MarshalsPointer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class StringMarshalers {

    public static class AsWindow1252ZMarshaler {
        private static final EightBitZeroTerminatedStringMarshaler MARSHALER = new EightBitZeroTerminatedStringMarshaler("windows-1252");

        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            return MARSHALER.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(String s, long flags) {
            return MARSHALER.toNative(s, flags);
        }

        @MarshalsArray(baseType=byte.class)
        public static String toObject(Class<?> cls, long handle, long flags, int d1) {
            return MARSHALER.toObject(cls, handle, flags, d1);
        }

        @MarshalsArray(baseType=byte.class)
        public static void toNative(String s, long handle, long flags, int d1) {
            MARSHALER.toNative(s, handle, flags, d1);
        }
    }

    public static class AsLatin1ZMarshaler {
        private static final EightBitZeroTerminatedStringMarshaler MARSHALER = new EightBitZeroTerminatedStringMarshaler("8859-1");

        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            return MARSHALER.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(String s, long flags) {
            return MARSHALER.toNative(s, flags);
        }

        @MarshalsArray(baseType=byte.class)
        public static String toObject(Class<?> cls, long handle, long flags, int d1) {
            return MARSHALER.toObject(cls, handle, flags, d1);
        }

        @MarshalsArray(baseType=byte.class)
        public static void toNative(String s, long handle, long flags, int d1) {
            MARSHALER.toNative(s, handle, flags, d1);
        }
    }

    public static class AsUtf8ZMarshaler {
        private static final EightBitZeroTerminatedStringMarshaler MARSHALER = new EightBitZeroTerminatedStringMarshaler("utf-8");

        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            return MARSHALER.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(String s, long flags) {
            return MARSHALER.toNative(s, flags);
        }

        @MarshalsArray(baseType=byte.class)
        public static String toObject(Class<?> cls, long handle, long flags, int d1) {
            return MARSHALER.toObject(cls, handle, flags, d1);
        }

        @MarshalsArray(baseType=byte.class)
        public static void toNative(String s, long handle, long flags, int d1) {
            MARSHALER.toNative(s, handle, flags, d1);
        }
    }

    public static class AsAsciiZMarshaler {
        private static final EightBitZeroTerminatedStringMarshaler MARSHALER = new EightBitZeroTerminatedStringMarshaler("ascii");

        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            return MARSHALER.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(String s, long flags) {
            return MARSHALER.toNative(s, flags);
        }

        @MarshalsArray(baseType=byte.class)
        public static String toObject(Class<?> cls, long handle, long flags, int d1) {
            return MARSHALER.toObject(cls, handle, flags, d1);
        }

        @MarshalsArray(baseType=byte.class)
        public static void toNative(String s, long handle, long flags, int d1) {
            MARSHALER.toNative(s, handle, flags, d1);
        }
    }

    public static class AsDefaultCharsetZMarshaler {
        private static final EightBitZeroTerminatedStringMarshaler MARSHALER = new EightBitZeroTerminatedStringMarshaler(Charset.defaultCharset().name());

        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            return MARSHALER.toObject(cls, handle, flags);
        }

        @MarshalsPointer
        public static long toNative(String s, long flags) {
            return MARSHALER.toNative(s, flags);
        }

        @MarshalsArray(baseType=byte.class)
        public static String toObject(Class<?> cls, long handle, long flags, int d1) {
            return MARSHALER.toObject(cls, handle, flags, d1);
        }

        @MarshalsArray(baseType=byte.class)
        public static void toNative(String s, long handle, long flags, int d1) {
            MARSHALER.toNative(s, handle, flags, d1);
        }
    }

    public static class EightBitZeroTerminatedStringMarshaler {
        private static final String EMPTY_STRING = "";
        private final Charset charset;

        public EightBitZeroTerminatedStringMarshaler(String charsetName) {
            this.charset = Charset.forName(charsetName);
        }

        public final String toObject(Class<?> cls, long handle, long flags) {
            if (handle == 0L) {
                return null;
            }
            int length = 0;
            while (VM.getByte(handle + (long)length) != 0) {
                ++length;
            }
            if (length == 0) {
                return EMPTY_STRING;
            }
            return this.charset.decode(VM.newDirectByteBuffer(handle, length)).toString();
        }

        public final long toNative(String s, long flags) {
            long callType = flags & 7L;
            if (callType != 0L) {
                if (callType == 1L) {
                    throw new UnsupportedOperationException("Marshaling String to pointer for callback return values is not supported");
                }
                if (callType == 2L) {
                    throw new UnsupportedOperationException("Marshaling String to pointer for struct member setter values is not supported");
                }
                throw new UnsupportedOperationException();
            }
            if (s == null) {
                return 0L;
            }
            byte[] bytes = s.getBytes(this.charset);
            long handle = VM.allocateMemoryAtomic(bytes.length + 1);
            VM.memcpy(handle, VM.getArrayValuesAddress(bytes), bytes.length);
            return handle;
        }

        public final String toObject(Class<?> cls, long handle, long flags, int d1) {
            int length;
            for (length = 0; length < d1 && VM.getByte(handle + (long)length) != 0; ++length) {
            }
            if (length == 0) {
                return EMPTY_STRING;
            }
            return this.charset.decode(VM.newDirectByteBuffer(handle, length)).toString();
        }

        public final void toNative(String s, long handle, long flags, int d1) {
            byte[] bytes = s.getBytes(this.charset);
            int length = Math.min(d1, bytes.length);
            ByteBuffer bb = VM.newDirectByteBuffer(handle, d1);
            bb.put(bytes, 0, length);
            if (bb.hasRemaining()) {
                bb.put((byte)0);
            }
        }
    }
}

