/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.bro;

import com.bugvm.rt.bro.BuiltinMarshalers;
import com.bugvm.rt.bro.NativeObject;
import com.bugvm.rt.bro.annotation.Marshaler;
import com.bugvm.rt.bro.annotation.Marshalers;
import com.bugvm.rt.bro.annotation.MarshalsPointer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class MarshalerLookup {
    private static final ConcurrentHashMap<Class<?>, Method> TO_OBJECT_CACHE = new ConcurrentHashMap();

    public static <S extends NativeObject> S toObject(Class<S> type, long handle) {
        try {
            Method toObject = MarshalerLookup.findMarshaler(type);
            return (S)((NativeObject)toObject.invoke(null, type, handle, 4L));
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    public static Method findMarshaler(Class<? extends NativeObject> type) {
        Method toObject = TO_OBJECT_CACHE.get(type);
        if (toObject == null) {
            toObject = MarshalerLookup.findMarshaler(type, type);
            TO_OBJECT_CACHE.put(type, toObject);
        }
        return toObject;
    }

    private static Method find(Class<?> findClass, Class<?> inClass, Marshaler anno) {
        Class<?> marshalerClass = anno.value();
        for (Method method : marshalerClass.getMethods()) {
            if (!method.isAnnotationPresent(MarshalsPointer.class)) continue;
            Class<?> returnType = method.getReturnType();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (returnType.isPrimitive() || paramTypes.length != 3 || paramTypes[0] != Class.class || paramTypes[1] != Long.TYPE || paramTypes[2] != Long.TYPE || !returnType.isAssignableFrom(findClass)) continue;
            return method;
        }
        return null;
    }

    private static Method findMarshaler0(Class<?> findClass, Class<?> inClass) {
        Method method;
        Marshaler anno1 = inClass.getAnnotation(Marshaler.class);
        Marshalers anno2 = inClass.getAnnotation(Marshalers.class);
        if (anno1 != null && (method = MarshalerLookup.find(findClass, inClass, anno1)) != null) {
            return method;
        }
        if (anno2 != null) {
            for (Marshaler m : anno2.value()) {
                Method method2 = MarshalerLookup.find(findClass, inClass, m);
                if (method2 == null) continue;
                return method2;
            }
        }
        return null;
    }

    private static Method findMarshaler(Class<?> findClass, Class<?> inClass) {
        for (Class<?> c = inClass; c != null; c = c.getSuperclass()) {
            Method method = MarshalerLookup.findMarshaler0(findClass, c);
            if (method == null) continue;
            return method;
        }
        for (Class<?> intf : inClass.getInterfaces()) {
            Method marshaler2 = MarshalerLookup.findMarshaler(findClass, intf);
            if (marshaler2 == null) continue;
            return marshaler2;
        }
        Method method = MarshalerLookup.findMarshaler0(findClass, BuiltinMarshalers.class);
        if (method != null) {
            return method;
        }
        throw new Error("No marshaler found for class " + findClass.getName());
    }
}

