/*
 * Decompiled with CFR 0.152.
 */
package com.bugvm.rt.annotation;

import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.Arrays;
import java.util.HashMap;

public abstract class Annotation
implements java.lang.annotation.Annotation {
    protected static final Object NO_VALUE = NoValue.NO_VALUE;
    private static HashMap<Class<? extends java.lang.annotation.Annotation>, HashMap<String, Object>> defaultValueCache = new HashMap();
    private final Class<? extends java.lang.annotation.Annotation> annotationType;

    protected Annotation(Class<? extends java.lang.annotation.Annotation> klass) {
        this.annotationType = klass;
    }

    @Override
    public Class<? extends java.lang.annotation.Annotation> annotationType() {
        return this.annotationType;
    }

    protected final Object validate(Object value, String memberName) {
        if (value instanceof Exception) {
            if (value instanceof TypeNotPresentException) {
                TypeNotPresentException e = (TypeNotPresentException)value;
                throw new TypeNotPresentException(e.typeName(), e.getCause());
            }
            if (value instanceof EnumConstantNotPresentException) {
                EnumConstantNotPresentException e = (EnumConstantNotPresentException)value;
                throw new EnumConstantNotPresentException(e.enumType(), e.constantName());
            }
            if (value instanceof AnnotationTypeMismatchException) {
                AnnotationTypeMismatchException e = (AnnotationTypeMismatchException)value;
                throw new AnnotationTypeMismatchException(e.element(), e.foundType());
            }
            if (value instanceof ArrayStoreException) {
                ArrayStoreException e = (ArrayStoreException)value;
                throw new ArrayStoreException(e.getMessage());
            }
            throw new RuntimeException((Exception)value);
        }
        if (value == NO_VALUE) {
            throw new IncompleteAnnotationException(this.annotationType, memberName);
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return ((int[])value).clone();
            }
            if (type == byte[].class) {
                return ((byte[])value).clone();
            }
            if (type == short[].class) {
                return ((short[])value).clone();
            }
            if (type == long[].class) {
                return ((long[])value).clone();
            }
            if (type == char[].class) {
                return ((char[])value).clone();
            }
            if (type == boolean[].class) {
                return ((boolean[])value).clone();
            }
            if (type == float[].class) {
                return ((float[])value).clone();
            }
            if (type == double[].class) {
                return ((double[])value).clone();
            }
            return ((Object[])value).clone();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getDefaultValue(String memberName) {
        HashMap<Class<? extends java.lang.annotation.Annotation>, HashMap<String, Object>> hashMap = defaultValueCache;
        synchronized (hashMap) {
            Object value;
            HashMap<String, Object> cache = defaultValueCache.get(this.annotationType);
            if (cache != null && (value = cache.get(memberName)) != null) {
                return value;
            }
            value = null;
            try {
                value = this.annotationType.getMethod(memberName, new Class[0]).getDefaultValue();
            }
            catch (Throwable t) {
                value = t;
            }
            if (value == null) {
                value = NO_VALUE;
            }
            if (cache == null) {
                cache = new HashMap();
                defaultValueCache.put(this.annotationType, cache);
            }
            cache.put(memberName, value);
            return value;
        }
    }

    protected final int hash(Object value, String memberName) {
        int hash = memberName.hashCode() * 127;
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return hash ^ Arrays.hashCode((int[])value);
            }
            if (type == byte[].class) {
                return hash ^ Arrays.hashCode((byte[])value);
            }
            if (type == short[].class) {
                return hash ^ Arrays.hashCode((short[])value);
            }
            if (type == long[].class) {
                return hash ^ Arrays.hashCode((long[])value);
            }
            if (type == char[].class) {
                return hash ^ Arrays.hashCode((char[])value);
            }
            if (type == boolean[].class) {
                return hash ^ Arrays.hashCode((boolean[])value);
            }
            if (type == float[].class) {
                return hash ^ Arrays.hashCode((float[])value);
            }
            if (type == double[].class) {
                return hash ^ Arrays.hashCode((double[])value);
            }
            return hash ^ Arrays.hashCode((Object[])value);
        }
        return hash ^ value.hashCode();
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() == o.getClass()) {
            return this.fastEquals(o);
        }
        if (this.annotationType.isInstance(o)) {
            try {
                return this.slowEquals(o);
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    protected abstract boolean fastEquals(Object var1);

    protected abstract boolean slowEquals(Object var1);

    protected final boolean memberEquals(Object ours, Object theirs) {
        if (ours == theirs) {
            return true;
        }
        if (ours instanceof Exception) {
            return false;
        }
        Class<?> type = ours.getClass();
        if (type != theirs.getClass()) {
            return false;
        }
        if (type.isArray()) {
            if (ours instanceof Object[]) {
                return Arrays.equals((Object[])ours, (Object[])theirs);
            }
            if (type == int[].class) {
                return Arrays.equals((int[])ours, (int[])theirs);
            }
            if (type == byte[].class) {
                return Arrays.equals((byte[])ours, (byte[])theirs);
            }
            if (type == short[].class) {
                return Arrays.equals((short[])ours, (short[])theirs);
            }
            if (type == long[].class) {
                return Arrays.equals((long[])ours, (long[])theirs);
            }
            if (type == char[].class) {
                return Arrays.equals((char[])ours, (char[])theirs);
            }
            if (type == boolean[].class) {
                return Arrays.equals((boolean[])ours, (boolean[])theirs);
            }
            if (type == float[].class) {
                return Arrays.equals((float[])ours, (float[])theirs);
            }
            if (type == double[].class) {
                return Arrays.equals((double[])ours, (double[])theirs);
            }
            return false;
        }
        return ours.equals(theirs);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append('@');
        sb.append(this.annotationType.getName());
        sb.append('(');
        this.membersToString(sb);
        sb.append(')');
        return sb.toString();
    }

    protected abstract void membersToString(StringBuilder var1);

    protected final void memberToString(StringBuilder sb, Object value, String memberName, boolean first) {
        if (!first) {
            sb.append(", ");
        }
        sb.append(memberName);
        sb.append('=');
        sb.append(this.memberValueToString(value));
    }

    private final String memberValueToString(Object value) {
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return Arrays.toString((int[])value);
            }
            if (type == byte[].class) {
                return Arrays.toString((byte[])value);
            }
            if (type == short[].class) {
                return Arrays.toString((short[])value);
            }
            if (type == long[].class) {
                return Arrays.toString((long[])value);
            }
            if (type == char[].class) {
                return Arrays.toString((char[])value);
            }
            if (type == boolean[].class) {
                return Arrays.toString((boolean[])value);
            }
            if (type == float[].class) {
                return Arrays.toString((float[])value);
            }
            if (type == double[].class) {
                return Arrays.toString((double[])value);
            }
            return Arrays.toString((Object[])value);
        }
        return value.toString();
    }

    protected static Boolean box(boolean v) {
        return v;
    }

    protected static Byte box(byte v) {
        return v;
    }

    protected static Short box(short v) {
        return v;
    }

    protected static Character box(char v) {
        return Character.valueOf(v);
    }

    protected static Integer box(int v) {
        return v;
    }

    protected static Long box(long v) {
        return v;
    }

    protected static Float box(float v) {
        return Float.valueOf(v);
    }

    protected static Double box(double v) {
        return v;
    }

    protected static boolean unbox(Boolean v) {
        return v;
    }

    protected static byte unbox(Byte v) {
        return v;
    }

    protected static short unbox(Short v) {
        return v;
    }

    protected static char unbox(Character v) {
        return v.charValue();
    }

    protected static int unbox(Integer v) {
        return v;
    }

    protected static long unbox(Long v) {
        return v;
    }

    protected static float unbox(Float v) {
        return v.floatValue();
    }

    protected static double unbox(Double v) {
        return v;
    }

    private static enum NoValue {
        NO_VALUE;

    }
}

