/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.HandshakeIODataStream;
import com.android.org.conscrypt.Message;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import libcore.io.Streams;

public class ClientHello
extends Message {
    final byte[] client_version;
    final byte[] random = new byte[32];
    final byte[] session_id;
    final CipherSuite[] cipher_suites;
    final byte[] compression_methods;

    public ClientHello(SecureRandom sr, byte[] version, byte[] ses_id, CipherSuite[] cipher_suite) {
        this.client_version = version;
        long gmt_unix_time = System.currentTimeMillis() / 1000L;
        sr.nextBytes(this.random);
        this.random[0] = (byte)(gmt_unix_time & 0xFFL);
        this.random[1] = (byte)(gmt_unix_time & 0xFFL);
        this.random[2] = (byte)(gmt_unix_time & 0xFFL);
        this.random[3] = (byte)(gmt_unix_time & 0xFFL);
        this.session_id = ses_id;
        this.cipher_suites = cipher_suite;
        this.compression_methods = new byte[]{0};
        this.length = 38 + this.session_id.length + (this.cipher_suites.length << 1) + this.compression_methods.length;
    }

    public ClientHello(HandshakeIODataStream in, int length) throws IOException {
        this.client_version = new byte[2];
        this.client_version[0] = (byte)in.readUint8();
        this.client_version[1] = (byte)in.readUint8();
        Streams.readFully(in, this.random);
        int size = in.read();
        this.session_id = new byte[size];
        in.read(this.session_id, 0, size);
        int l = in.readUint16();
        if ((l & 1) == 1) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect ClientHello");
        }
        size = l >> 1;
        this.cipher_suites = new CipherSuite[size];
        for (int i = 0; i < size; ++i) {
            byte b0 = (byte)in.read();
            byte b1 = (byte)in.read();
            this.cipher_suites[i] = CipherSuite.getByCode(b0, b1);
        }
        size = in.read();
        this.compression_methods = new byte[size];
        in.read(this.compression_methods, 0, size);
        this.length = 38 + this.session_id.length + (this.cipher_suites.length << 1) + this.compression_methods.length;
        if (this.length > length) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect ClientHello");
        }
        if (this.length < length) {
            in.skip(length - this.length);
            this.length = length;
        }
    }

    public ClientHello(HandshakeIODataStream in) throws IOException {
        int challenge_length;
        if (in.readUint8() != 1) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect V2ClientHello");
        }
        this.client_version = new byte[2];
        this.client_version[0] = (byte)in.readUint8();
        this.client_version[1] = (byte)in.readUint8();
        int cipher_spec_length = in.readUint16();
        if (in.readUint16() != 0) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect V2ClientHello, cannot be used for resuming");
        }
        if ((challenge_length = in.readUint16()) < 16) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect V2ClientHello, short challenge data");
        }
        this.session_id = EmptyArray.BYTE;
        this.cipher_suites = new CipherSuite[cipher_spec_length / 3];
        for (int i = 0; i < this.cipher_suites.length; ++i) {
            byte b0 = (byte)in.read();
            byte b1 = (byte)in.read();
            byte b2 = (byte)in.read();
            this.cipher_suites[i] = CipherSuite.getByCode(b0, b1, b2);
        }
        this.compression_methods = new byte[]{0};
        if (challenge_length < 32) {
            Arrays.fill(this.random, 0, 32 - challenge_length, (byte)0);
            System.arraycopy((Object)in.read(challenge_length), 0, (Object)this.random, 32 - challenge_length, challenge_length);
        } else if (challenge_length == 32) {
            System.arraycopy((Object)in.read(32), 0, (Object)this.random, 0, 32);
        } else {
            System.arraycopy((Object)in.read(challenge_length), challenge_length - 32, (Object)this.random, 0, 32);
        }
        if (in.available() > 0) {
            this.fatalAlert((byte)50, "DECODE ERROR: incorrect V2ClientHello, extra data");
        }
        this.length = 38 + this.session_id.length + (this.cipher_suites.length << 1) + this.compression_methods.length;
    }

    @Override
    public void send(HandshakeIODataStream out) {
        int i;
        out.write(this.client_version);
        out.write(this.random);
        out.writeUint8(this.session_id.length);
        out.write(this.session_id);
        int size = this.cipher_suites.length << 1;
        out.writeUint16(size);
        for (i = 0; i < this.cipher_suites.length; ++i) {
            out.write(this.cipher_suites[i].toBytes());
        }
        out.writeUint8(this.compression_methods.length);
        for (i = 0; i < this.compression_methods.length; ++i) {
            out.write(this.compression_methods[i]);
        }
    }

    public byte[] getRandom() {
        return this.random;
    }

    @Override
    public int getType() {
        return 1;
    }
}

