/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.math.ec;

import com.android.org.bouncycastle.math.ec.ECCurve;
import com.android.org.bouncycastle.math.ec.ECMultiplier;
import com.android.org.bouncycastle.math.ec.ECPoint;
import com.android.org.bouncycastle.math.ec.PreCompInfo;
import com.android.org.bouncycastle.math.ec.Tnaf;
import com.android.org.bouncycastle.math.ec.WTauNafPreCompInfo;
import com.android.org.bouncycastle.math.ec.ZTauElement;
import java.math.BigInteger;

class WTauNafMultiplier
implements ECMultiplier {
    WTauNafMultiplier() {
    }

    @Override
    public ECPoint multiply(ECPoint point, BigInteger k, PreCompInfo preCompInfo) {
        if (!(point instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m p = (ECPoint.F2m)point;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        int m = curve.getM();
        byte a = curve.getA().toBigInteger().byteValue();
        byte mu = curve.getMu();
        BigInteger[] s = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k, m, a, s, mu, (byte)10);
        return this.multiplyWTnaf(p, rho, preCompInfo, a, mu);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m p, ZTauElement lambda2, PreCompInfo preCompInfo, byte a, byte mu) {
        ZTauElement[] alpha = a == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger tw = Tnaf.getTw(mu, 4);
        byte[] u = Tnaf.tauAdicWNaf(mu, lambda2, (byte)4, BigInteger.valueOf(16L), tw, alpha);
        return WTauNafMultiplier.multiplyFromWTnaf(p, u, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m p, byte[] u, PreCompInfo preCompInfo) {
        ECPoint.F2m[] pu;
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        byte a = curve.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            pu = Tnaf.getPreComp(p, a);
            p.setPreCompInfo(new WTauNafPreCompInfo(pu));
        } else {
            pu = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        ECPoint.F2m q = (ECPoint.F2m)p.getCurve().getInfinity();
        for (int i = u.length - 1; i >= 0; --i) {
            q = Tnaf.tau(q);
            if (u[i] == 0) continue;
            q = u[i] > 0 ? q.addSimple(pu[u[i]]) : q.subtractSimple(pu[-u[i]]);
        }
        return q;
    }
}

