/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.internal.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class RawHeaders {
    private static final Comparator<String> FIELD_NAME_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a, b);
        }
    };
    private final List<String> namesAndValues = new ArrayList<String>(20);
    private String requestLine;
    private String statusLine;
    private int httpMinorVersion = 1;
    private int responseCode = -1;
    private String responseMessage;

    public RawHeaders() {
    }

    public RawHeaders(RawHeaders copyFrom) {
        this.namesAndValues.addAll(copyFrom.namesAndValues);
        this.requestLine = copyFrom.requestLine;
        this.statusLine = copyFrom.statusLine;
        this.httpMinorVersion = copyFrom.httpMinorVersion;
        this.responseCode = copyFrom.responseCode;
        this.responseMessage = copyFrom.responseMessage;
    }

    public void setRequestLine(String requestLine) {
        this.requestLine = requestLine = requestLine.trim();
    }

    public void setStatusLine(String statusLine) throws IOException {
        int responseCode;
        boolean hasMessage;
        if (this.responseMessage != null) {
            throw new IllegalStateException("statusLine is already set");
        }
        boolean bl = hasMessage = statusLine.length() > 13;
        if (!statusLine.startsWith("HTTP/1.") || statusLine.length() < 12 || statusLine.charAt(8) != ' ' || hasMessage && statusLine.charAt(12) != ' ') {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        int httpMinorVersion = statusLine.charAt(7) - 48;
        if (httpMinorVersion < 0 || httpMinorVersion > 9) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        try {
            responseCode = Integer.parseInt(statusLine.substring(9, 12));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        this.responseMessage = hasMessage ? statusLine.substring(13) : "";
        this.responseCode = responseCode;
        this.statusLine = statusLine;
        this.httpMinorVersion = httpMinorVersion;
    }

    public void addSpdyRequestHeaders(String method, String path, String version, String host, String scheme) {
        this.add(":method", method);
        this.add(":scheme", scheme);
        this.add(":path", path);
        this.add(":version", version);
        this.add(":host", host);
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public int getHttpMinorVersion() {
        return this.httpMinorVersion != -1 ? this.httpMinorVersion : 1;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void addLine(String line) {
        int index = line.indexOf(":");
        if (index == -1) {
            this.addLenient("", line);
        } else {
            this.addLenient(line.substring(0, index), line.substring(index + 1));
        }
    }

    public void add(String fieldName, String value) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldname == null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        if (fieldName.length() == 0 || fieldName.indexOf(0) != -1 || value.indexOf(0) != -1) {
            throw new IllegalArgumentException("Unexpected header: " + fieldName + ": " + value);
        }
        this.addLenient(fieldName, value);
    }

    private void addLenient(String fieldName, String value) {
        this.namesAndValues.add(fieldName);
        this.namesAndValues.add(value.trim());
    }

    public void removeAll(String fieldName) {
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            if (!fieldName.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
            this.namesAndValues.remove(i);
            this.namesAndValues.remove(i);
        }
    }

    public void addAll(String fieldName, List<String> headerFields) {
        for (String value : headerFields) {
            this.add(fieldName, value);
        }
    }

    public void set(String fieldName, String value) {
        this.removeAll(fieldName);
        this.add(fieldName, value);
    }

    public int length() {
        return this.namesAndValues.size() / 2;
    }

    public String getFieldName(int index) {
        int fieldNameIndex = index * 2;
        if (fieldNameIndex < 0 || fieldNameIndex >= this.namesAndValues.size()) {
            return null;
        }
        return this.namesAndValues.get(fieldNameIndex);
    }

    public Set<String> names() {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < this.length(); ++i) {
            result.add(this.getFieldName(i));
        }
        return Collections.unmodifiableSet(result);
    }

    public String getValue(int index) {
        int valueIndex = index * 2 + 1;
        if (valueIndex < 0 || valueIndex >= this.namesAndValues.size()) {
            return null;
        }
        return this.namesAndValues.get(valueIndex);
    }

    public String get(String fieldName) {
        for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
            if (!fieldName.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
            return this.namesAndValues.get(i + 1);
        }
        return null;
    }

    public List<String> values(String name) {
        ArrayList<String> result = null;
        for (int i = 0; i < this.length(); ++i) {
            if (!name.equalsIgnoreCase(this.getFieldName(i))) continue;
            if (result == null) {
                result = new ArrayList<String>(2);
            }
            result.add(this.getValue(i));
        }
        return result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
    }

    public RawHeaders getAll(Set<String> fieldNames) {
        RawHeaders result = new RawHeaders();
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            String fieldName = this.namesAndValues.get(i);
            if (!fieldNames.contains(fieldName)) continue;
            result.add(fieldName, this.namesAndValues.get(i + 1));
        }
        return result;
    }

    public byte[] toBytes() throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder(256);
        result.append(this.requestLine).append("\r\n");
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            result.append(this.namesAndValues.get(i)).append(": ").append(this.namesAndValues.get(i + 1)).append("\r\n");
        }
        result.append("\r\n");
        return result.toString().getBytes("ISO-8859-1");
    }

    public static RawHeaders fromBytes(InputStream in) throws IOException {
        RawHeaders headers;
        do {
            headers = new RawHeaders();
            headers.setStatusLine(Util.readAsciiLine(in));
            RawHeaders.readHeaders(in, headers);
        } while (headers.getResponseCode() == 100);
        return headers;
    }

    public static void readHeaders(InputStream in, RawHeaders out) throws IOException {
        String line;
        while ((line = Util.readAsciiLine(in)).length() != 0) {
            out.addLine(line);
        }
    }

    public Map<String, List<String>> toMultimap(boolean response) {
        TreeMap result = new TreeMap(FIELD_NAME_COMPARATOR);
        for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            String fieldName = this.namesAndValues.get(i);
            String value = this.namesAndValues.get(i + 1);
            ArrayList<String> allValues = new ArrayList<String>();
            List otherValues = (List)result.get(fieldName);
            if (otherValues != null) {
                allValues.addAll(otherValues);
            }
            allValues.add(value);
            result.put(fieldName, Collections.unmodifiableList(allValues));
        }
        if (response && this.statusLine != null) {
            result.put(null, Collections.unmodifiableList(Collections.singletonList(this.statusLine)));
        } else if (this.requestLine != null) {
            result.put(null, Collections.unmodifiableList(Collections.singletonList(this.requestLine)));
        }
        return Collections.unmodifiableMap(result);
    }

    public static RawHeaders fromMultimap(Map<String, List<String>> map, boolean response) throws IOException {
        if (!response) {
            throw new UnsupportedOperationException();
        }
        RawHeaders result = new RawHeaders();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String fieldName = entry.getKey();
            List<String> values2 = entry.getValue();
            if (fieldName != null) {
                for (String value : values2) {
                    result.addLenient(fieldName, value);
                }
                continue;
            }
            if (values2.isEmpty()) continue;
            result.setStatusLine(values2.get(values2.size() - 1));
        }
        return result;
    }

    public List<String> toNameValueBlock() {
        HashSet<String> names = new HashSet<String>();
        ArrayList<String> result = new ArrayList<String>();
        block0: for (int i = 0; i < this.namesAndValues.size(); i += 2) {
            String name = this.namesAndValues.get(i).toLowerCase(Locale.US);
            String value = this.namesAndValues.get(i + 1);
            if (name.equals("connection") || name.equals("host") || name.equals("keep-alive") || name.equals("proxy-connection") || name.equals("transfer-encoding")) continue;
            if (names.add(name)) {
                result.add(name);
                result.add(value);
                continue;
            }
            for (int j = 0; j < result.size(); j += 2) {
                if (!name.equals(result.get(j))) continue;
                result.set(j + 1, (String)result.get(j + 1) + "\u0000" + value);
                continue block0;
            }
        }
        return result;
    }

    public static RawHeaders fromNameValueBlock(List<String> nameValueBlock) throws IOException {
        if (nameValueBlock.size() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected name value block: " + nameValueBlock);
        }
        String status = null;
        String version = null;
        RawHeaders result = new RawHeaders();
        for (int i = 0; i < nameValueBlock.size(); i += 2) {
            String name = nameValueBlock.get(i);
            String values2 = nameValueBlock.get(i + 1);
            int start = 0;
            while (start < values2.length()) {
                int end = values2.indexOf(0, start);
                if (end == -1) {
                    end = values2.length();
                }
                String value = values2.substring(start, end);
                if (":status".equals(name)) {
                    status = value;
                } else if (":version".equals(name)) {
                    version = value;
                } else {
                    result.namesAndValues.add(name);
                    result.namesAndValues.add(value);
                }
                start = end + 1;
            }
        }
        if (status == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        if (version == null) {
            throw new ProtocolException("Expected ':version' header not present");
        }
        result.setStatusLine(version + " " + status);
        return result;
    }
}

