/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.os.Build;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.StateObserver;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.ndk.OpaqueValue;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0086 J\u001b\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0086 J\t\u0010\u001a\u001a\u00020\u0011H\u0086 J!\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\bH\u0086 J!\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020 H\u0086 J!\u0010!\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0086 J!\u0010\"\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0086 J\t\u0010#\u001a\u00020\u0011H\u0086 J\u0011\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086 J\t\u0010%\u001a\u00020\u0011H\u0086 J\u0011\u0010&\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0013H\u0086 J\b\u0010'\u001a\u00020\u0011H\u0002J\u0011\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0013H\u0086 J\u0017\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020,\u0018\u00010+H\u0086 J\u0017\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b\u0018\u00010+H\u0086 J\t\u0010.\u001a\u00020/H\u0086 J\u0010\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00112\u0006\u00101\u001a\u000204H\u0002J\u001d\u00105\u001a\u00020\u00112\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020,0+H\u0086 JI\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020,2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010>\u001a\u00020,H\u0086 J\u0012\u0010?\u001a\u00020\b2\b\u0010@\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\u0013H\u0002J,\u0010C\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00170+2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00170+H\u0002J\u0011\u0010D\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u0013H\u0086 J\u0011\u0010F\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u0013H\u0086 J\u0010\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020IH\u0016J\t\u0010J\u001a\u00020\u0011H\u0086 J\t\u0010K\u001a\u00020\u0011H\u0086 J\u0019\u0010L\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0086 J\u0011\u0010M\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\bH\u0086 J\u0011\u0010O\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0013H\u0086 J)\u0010Q\u001a\u00020\u00112\u0006\u0010R\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010S\u001a\u00020,2\u0006\u0010T\u001a\u00020,H\u0086 J\u0011\u0010U\u001a\u00020\u00112\u0006\u0010V\u001a\u00020\u0013H\u0086 J\u0019\u0010W\u001a\u00020\u00112\u0006\u0010X\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\u0013H\u0086 J\u0011\u0010Z\u001a\u00020\u00112\u0006\u0010[\u001a\u00020\bH\u0086 J\u0011\u0010\\\u001a\u00020\u00112\u0006\u0010;\u001a\u00020,H\u0086 J\u0019\u0010]\u001a\u00020\u00112\u0006\u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020\u0013H\u0086 J\u0011\u0010`\u001a\u00020\u00112\u0006\u0010a\u001a\u00020\u0013H\u0086 J\u0011\u0010b\u001a\u00020\u00112\u0006\u0010^\u001a\u00020\u0013H\u0086 J\u0011\u0010c\u001a\u00020\u00112\u0006\u0010^\u001a\u00020\u0013H\u0086 J\u0011\u0010d\u001a\u00020\u00112\u0006\u0010^\u001a\u00020\u0013H\u0086 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/bugsnag/android/ndk/NativeBridge;", "Lcom/bugsnag/android/internal/StateObserver;", "bgTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "(Lcom/bugsnag/android/internal/BackgroundTaskService;)V", "installed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "is32bit", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lcom/bugsnag/android/Logger;", "reportDirectory", "Ljava/io/File;", "addBreadcrumb", "", "name", "", "type", "timestamp", "metadata", "", "addFeatureFlag", "variant", "addHandledEvent", "addMetadataBoolean", "tab", "key", "value", "addMetadataDouble", "", "addMetadataOpaque", "addMetadataString", "addUnhandledEvent", "clearFeatureFlag", "clearFeatureFlags", "clearMetadataTab", "deliverPendingReports", "deliverReportAtPath", "filePath", "getCurrentCallbackSetCounts", "", "", "getCurrentNativeApiCallUsage", "getSignalUnwindStackFunction", "", "handleAddMetadata", "arg", "Lcom/bugsnag/android/StateEvent$AddMetadata;", "handleInstallMessage", "Lcom/bugsnag/android/StateEvent$Install;", "initCallbackCounts", "counts", "install", "apiKey", "reportingDirectory", "lastRunInfoPath", "consecutiveLaunchCrashes", "autoDetectNdkCrashes", "apiLevel", "threadSendPolicy", "isInvalidMessage", "msg", "makeSafe", "text", "makeSafeMetadata", "notifyAddCallback", "callback", "notifyRemoveCallback", "onStateChange", "event", "Lcom/bugsnag/android/StateEvent;", "pausedSession", "refreshSymbolTable", "removeMetadata", "setInternalMetricsEnabled", "enabled", "setStaticJsonData", "data", "startedSession", "sessionID", "handledCount", "unhandledCount", "updateContext", "context", "updateInForeground", "inForeground", "activityName", "updateIsLaunching", "isLaunching", "updateLastRunInfo", "updateLowMemory", "newValue", "memoryTrimLevelDescription", "updateOrientation", "orientation", "updateUserEmail", "updateUserId", "updateUserName", "bugsnag-plugin-android-ndk_release"})
public final class NativeBridge
implements StateObserver {
    @NotNull
    private final BackgroundTaskService bgTaskService;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final AtomicBoolean installed;
    @NotNull
    private final File reportDirectory;
    @NotNull
    private final Logger logger;

    public NativeBridge(@NotNull BackgroundTaskService bgTaskService) {
        this.bgTaskService = bgTaskService;
        this.lock = new ReentrantLock();
        this.installed = new AtomicBoolean(false);
        this.reportDirectory = NativeInterface.getNativeReportPath();
        this.logger = NativeInterface.getLogger();
    }

    private final boolean is32bit() {
        boolean bl;
        block1: {
            String[] abis;
            String[] $this$any$iv = abis = NativeInterface.getCpuAbi();
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"64", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return !bl;
    }

    public final native void install(@NotNull String var1, @NotNull String var2, @NotNull String var3, int var4, boolean var5, int var6, boolean var7, int var8);

    public final native void startedSession(@NotNull String var1, @NotNull String var2, int var3, int var4);

    public final native void deliverReportAtPath(@NotNull String var1);

    public final native void addBreadcrumb(@NotNull String var1, @NotNull String var2, @NotNull String var3, @NotNull Object var4);

    public final native void addMetadataString(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addMetadataDouble(@NotNull String var1, @NotNull String var2, double var3);

    public final native void addMetadataBoolean(@NotNull String var1, @NotNull String var2, boolean var3);

    public final native void addMetadataOpaque(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public final native void addHandledEvent();

    public final native void addUnhandledEvent();

    public final native void clearMetadataTab(@NotNull String var1);

    public final native void removeMetadata(@NotNull String var1, @NotNull String var2);

    public final native void pausedSession();

    public final native void updateContext(@NotNull String var1);

    public final native void updateInForeground(boolean var1, @NotNull String var2);

    public final native void updateIsLaunching(boolean var1);

    public final native void updateLastRunInfo(int var1);

    public final native void updateOrientation(@NotNull String var1);

    public final native void updateUserId(@NotNull String var1);

    public final native void updateUserEmail(@NotNull String var1);

    public final native void updateUserName(@NotNull String var1);

    public final native long getSignalUnwindStackFunction();

    public final native void updateLowMemory(boolean var1, @NotNull String var2);

    public final native void addFeatureFlag(@NotNull String var1, @Nullable String var2);

    public final native void clearFeatureFlag(@NotNull String var1);

    public final native void clearFeatureFlags();

    public final native void refreshSymbolTable();

    public final native void initCallbackCounts(@NotNull Map<String, Integer> var1);

    public final native void notifyAddCallback(@NotNull String var1);

    public final native void notifyRemoveCallback(@NotNull String var1);

    @Nullable
    public final native Map<String, Integer> getCurrentCallbackSetCounts();

    @Nullable
    public final native Map<String, Boolean> getCurrentNativeApiCallUsage();

    public final native void setStaticJsonData(@NotNull String var1);

    public final native void setInternalMetricsEnabled(boolean var1);

    /*
     * WARNING - void declaration
     */
    public void onStateChange(@NotNull StateEvent event) {
        if (this.isInvalidMessage(event)) {
            return;
        }
        StateEvent stateEvent = event;
        if (stateEvent instanceof StateEvent.Install) {
            this.handleInstallMessage((StateEvent.Install)event);
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.DeliverPending.INSTANCE)) {
            this.deliverPendingReports();
        } else if (stateEvent instanceof StateEvent.AddMetadata) {
            this.handleAddMetadata((StateEvent.AddMetadata)event);
        } else if (stateEvent instanceof StateEvent.ClearMetadataSection) {
            this.clearMetadataTab(this.makeSafe(((StateEvent.ClearMetadataSection)event).section));
        } else if (stateEvent instanceof StateEvent.ClearMetadataValue) {
            String string;
            this.removeMetadata(this.makeSafe(((StateEvent.ClearMetadataValue)event).section), this.makeSafe((string = ((StateEvent.ClearMetadataValue)event).key) == null ? "" : string));
        } else if (stateEvent instanceof StateEvent.AddBreadcrumb) {
            this.addBreadcrumb(this.makeSafe(((StateEvent.AddBreadcrumb)event).message), this.makeSafe(((StateEvent.AddBreadcrumb)event).type.toString()), this.makeSafe(((StateEvent.AddBreadcrumb)event).timestamp), this.makeSafeMetadata(((StateEvent.AddBreadcrumb)event).metadata));
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyHandled.INSTANCE)) {
            this.addHandledEvent();
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.NotifyUnhandled.INSTANCE)) {
            this.addUnhandledEvent();
        } else if (Intrinsics.areEqual((Object)stateEvent, (Object)StateEvent.PauseSession.INSTANCE)) {
            this.pausedSession();
        } else if (stateEvent instanceof StateEvent.StartSession) {
            this.startedSession(this.makeSafe(((StateEvent.StartSession)event).id), this.makeSafe(((StateEvent.StartSession)event).startedAt), ((StateEvent.StartSession)event).handledCount, ((StateEvent.StartSession)event).getUnhandledCount());
        } else if (stateEvent instanceof StateEvent.UpdateContext) {
            String string = ((StateEvent.UpdateContext)event).context;
            this.updateContext(this.makeSafe(string == null ? "" : string));
        } else if (stateEvent instanceof StateEvent.UpdateInForeground) {
            String string = ((StateEvent.UpdateInForeground)event).getContextActivity();
            this.updateInForeground(((StateEvent.UpdateInForeground)event).inForeground, this.makeSafe(string == null ? "" : string));
        } else if (stateEvent instanceof StateEvent.UpdateLastRunInfo) {
            this.updateLastRunInfo(((StateEvent.UpdateLastRunInfo)event).consecutiveLaunchCrashes);
        } else if (stateEvent instanceof StateEvent.UpdateIsLaunching) {
            this.updateIsLaunching(((StateEvent.UpdateIsLaunching)event).isLaunching);
            if (!((StateEvent.UpdateIsLaunching)event).isLaunching) {
                this.bgTaskService.submitTask(TaskType.DEFAULT, this::refreshSymbolTable);
            }
        } else if (stateEvent instanceof StateEvent.UpdateOrientation) {
            String string = ((StateEvent.UpdateOrientation)event).orientation;
            this.updateOrientation(string == null ? "" : string);
        } else if (stateEvent instanceof StateEvent.UpdateUser) {
            String string = ((StateEvent.UpdateUser)event).user.getId();
            this.updateUserId(this.makeSafe(string == null ? "" : string));
            string = ((StateEvent.UpdateUser)event).user.getName();
            this.updateUserName(this.makeSafe(string == null ? "" : string));
            string = ((StateEvent.UpdateUser)event).user.getEmail();
            this.updateUserEmail(this.makeSafe(string == null ? "" : string));
        } else if (stateEvent instanceof StateEvent.UpdateMemoryTrimEvent) {
            this.updateLowMemory(((StateEvent.UpdateMemoryTrimEvent)event).isLowMemory, ((StateEvent.UpdateMemoryTrimEvent)event).memoryTrimLevelDescription);
        } else if (stateEvent instanceof StateEvent.AddFeatureFlag) {
            String string;
            NativeBridge nativeBridge = this;
            String string2 = this.makeSafe(((StateEvent.AddFeatureFlag)event).name);
            String string3 = ((StateEvent.AddFeatureFlag)event).variant;
            if (string3 == null) {
                string = null;
            } else {
                void it;
                String string4 = string3;
                boolean bl = false;
                boolean bl2 = false;
                String string5 = string4;
                String string6 = string2;
                NativeBridge nativeBridge2 = nativeBridge;
                boolean bl3 = false;
                String string7 = this.makeSafe((String)it);
                nativeBridge = nativeBridge2;
                string2 = string6;
                string = string7;
            }
            nativeBridge.addFeatureFlag(string2, string);
        } else if (stateEvent instanceof StateEvent.ClearFeatureFlag) {
            this.clearFeatureFlag(this.makeSafe(((StateEvent.ClearFeatureFlag)event).name));
        } else if (stateEvent instanceof StateEvent.ClearFeatureFlags) {
            this.clearFeatureFlags();
        }
    }

    private final Map<String, Object> makeSafeMetadata(Map<String, ? extends Object> metadata) {
        if (metadata.isEmpty()) {
            return metadata;
        }
        return new Map<String, Object>(metadata){
            private final /* synthetic */ Map<String, Object> $$delegate_0;
            final /* synthetic */ Map<String, Object> $metadata;
            {
                this.$metadata = $metadata;
                this.$$delegate_0 = this.$metadata;
            }

            public boolean containsKey(@NotNull String key) {
                return this.$$delegate_0.containsKey(key);
            }

            public boolean containsValue(@Nullable Object value) {
                return this.$$delegate_0.containsValue(value);
            }

            public boolean isEmpty() {
                return this.$$delegate_0.isEmpty();
            }

            @NotNull
            public Set<Map.Entry<String, Object>> getEntries() {
                return this.$$delegate_0.entrySet();
            }

            @NotNull
            public Set<String> getKeys() {
                return this.$$delegate_0.keySet();
            }

            public int getSize() {
                return this.$$delegate_0.size();
            }

            @NotNull
            public Collection<Object> getValues() {
                return this.$$delegate_0.values();
            }

            @Nullable
            public Object get(@NotNull String key) {
                return OpaqueValue.Companion.makeSafe(this.$metadata.get(key));
            }

            public Object remove(Object key) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object compute(String p0, BiFunction<? super String, ? super Object, ? extends Object> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object computeIfAbsent(String p0, Function<? super String, ? extends Object> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object put(String key, Object value) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void putAll(Map<? extends String, ? extends Object> from) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public boolean replace(String p0, Object p1, Object p2) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void clear() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object putIfAbsent(String p0, Object p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public boolean remove(Object key, Object value) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> p0) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object computeIfPresent(String p0, BiFunction<? super String, ? super Object, ? extends Object> p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object merge(String p0, Object p1, BiFunction<? super Object, ? super Object, ? extends Object> p2) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public Object replace(String p0, Object p1) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private final boolean isInvalidMessage(Object msg) {
        if (msg == null || !(msg instanceof StateEvent)) {
            return true;
        }
        if (!this.installed.get() && !(msg instanceof StateEvent.Install)) {
            this.logger.w(Intrinsics.stringPlus((String)"Received message before INSTALL: ", (Object)msg));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deliverPendingReports() {
        String string = ".*\\.crash$";
        boolean bl = false;
        Regex filenameRegex = new Regex(string);
        this.lock.lock();
        try {
            File outDir = this.reportDirectory;
            if (outDir.exists()) {
                File[] fileList = outDir.listFiles(arg_0 -> NativeBridge.deliverPendingReports$lambda-2(filenameRegex, arg_0));
                if (fileList != null) {
                    for (File file : fileList) {
                        this.deliverReportAtPath(file.getAbsolutePath());
                    }
                }
            } else {
                this.logger.w("Payload directory does not exist, cannot read pending reports");
            }
        }
        catch (Exception ex) {
            this.logger.w(Intrinsics.stringPlus((String)"Failed to parse/write pending reports: ", (Object)ex));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInstallMessage(StateEvent.Install arg) {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.installed.get()) {
                this.logger.w(Intrinsics.stringPlus((String)"Received duplicate setup message with arg: ", (Object)arg));
            } else {
                String reportPath = new File(this.reportDirectory, UUID.randomUUID() + ".crash").getAbsolutePath();
                this.install(this.makeSafe(arg.apiKey), reportPath, this.makeSafe(arg.lastRunInfoPath), arg.consecutiveLaunchCrashes, arg.autoDetectNdkCrashes, Build.VERSION.SDK_INT, this.is32bit(), arg.sendThreads.ordinal());
                this.installed.set(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void handleAddMetadata(StateEvent.AddMetadata arg) {
        block0: {
            Object newValue;
            block3: {
                block2: {
                    block1: {
                        if (arg.key == null) break block0;
                        newValue = OpaqueValue.Companion.makeSafe(arg.value);
                        if (!(newValue instanceof String)) break block1;
                        String string = arg.section;
                        String string2 = arg.key;
                        Intrinsics.checkNotNull((Object)string2);
                        this.addMetadataString(string, string2, this.makeSafe((String)newValue));
                        break block0;
                    }
                    if (!(newValue instanceof Boolean)) break block2;
                    String string = arg.section;
                    String string3 = arg.key;
                    Intrinsics.checkNotNull((Object)string3);
                    this.addMetadataBoolean(string, string3, (Boolean)newValue);
                    break block0;
                }
                if (!(newValue instanceof Number)) break block3;
                String string = arg.section;
                String string4 = arg.key;
                Intrinsics.checkNotNull((Object)string4);
                this.addMetadataDouble(string, string4, ((Number)newValue).doubleValue());
                break block0;
            }
            if (!(newValue instanceof OpaqueValue)) break block0;
            String string = arg.section;
            String string5 = arg.key;
            Intrinsics.checkNotNull((Object)string5);
            this.addMetadataOpaque(string, string5, ((OpaqueValue)newValue).getJson());
        }
    }

    private final String makeSafe(String text) {
        Object object = text;
        Charset charset = Charset.defaultCharset();
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        boolean bl2 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    private static final boolean deliverPendingReports$lambda-2(Regex $filenameRegex, File it) {
        return $filenameRegex.containsMatchIn((CharSequence)it.getName());
    }
}

