/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.ndk;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.NativeInterface;
import java.io.File;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NativeBridge
implements Observer {
    private static final int METADATA_SECTION = 0;
    private static final int METADATA_KEY = 1;
    private static final int METADATA_VALUE = 2;
    private static final String LOG_TAG = "BugsnagNDK:NativeBridge";
    private static final Lock lock = new ReentrantLock();
    private static final AtomicBoolean installed = new AtomicBoolean(false);
    private boolean loggingEnabled = NativeInterface.getLoggingEnabled();
    private final String reportDirectory = NativeInterface.getNativeReportPath();

    public static native void install(@NonNull String var0, boolean var1, int var2, boolean var3);

    public static native void deliverReportAtPath(@NonNull String var0);

    public static native void addBreadcrumb(@NonNull String var0, @NonNull String var1, @NonNull String var2, @NonNull Object var3);

    public static native void addMetadataString(@NonNull String var0, @NonNull String var1, @NonNull String var2);

    public static native void addMetadataDouble(@NonNull String var0, @NonNull String var1, double var2);

    public static native void addMetadataBoolean(@NonNull String var0, @NonNull String var1, boolean var2);

    public static native void addHandledEvent();

    public static native void addUnhandledEvent();

    public static native void clearBreadcrumbs();

    public static native void clearMetadataTab(@NonNull String var0);

    public static native void removeMetadata(@NonNull String var0, @NonNull String var1);

    public static native void startedSession(@NonNull String var0, @NonNull String var1, int var2, int var3);

    public static native void stoppedSession();

    public static native void updateAppVersion(@NonNull String var0);

    public static native void updateBuildUUID(@NonNull String var0);

    public static native void updateContext(@NonNull String var0);

    public static native void updateInForeground(boolean var0, @NonNull String var1);

    public static native void updateLowMemory(boolean var0);

    public static native void updateOrientation(int var0);

    public static native void updateMetadata(@NonNull Object var0);

    public static native void updateReleaseStage(@NonNull String var0);

    public static native void updateUserId(@NonNull String var0);

    public static native void updateUserEmail(@NonNull String var0);

    public static native void updateUserName(@NonNull String var0);

    public NativeBridge() {
        File outFile = new File(this.reportDirectory);
        if (!outFile.exists() && !outFile.mkdirs()) {
            this.warn("The native reporting directory cannot be created.");
        }
    }

    @Override
    public void update(@NonNull Observable observable, @Nullable Object rawMessage) {
        NativeInterface.Message message = this.parseMessage(rawMessage);
        if (message == null) {
            return;
        }
        Object arg = message.value;
        switch (message.type) {
            case INSTALL: {
                this.handleInstallMessage(arg);
                break;
            }
            case DELIVER_PENDING: {
                this.deliverPendingReports();
                break;
            }
            case ADD_BREADCRUMB: {
                this.handleAddBreadcrumb(arg);
                break;
            }
            case ADD_METADATA: {
                this.handleAddMetadata(arg);
                break;
            }
            case CLEAR_BREADCRUMBS: {
                NativeBridge.clearBreadcrumbs();
                break;
            }
            case CLEAR_METADATA_TAB: {
                this.handleClearMetadataTab(arg);
                break;
            }
            case NOTIFY_HANDLED: {
                NativeBridge.addHandledEvent();
                break;
            }
            case NOTIFY_UNHANDLED: {
                NativeBridge.addUnhandledEvent();
                break;
            }
            case REMOVE_METADATA: {
                this.handleRemoveMetadata(arg);
                break;
            }
            case START_SESSION: {
                this.handleStartSession(arg);
                break;
            }
            case STOP_SESSION: {
                NativeBridge.stoppedSession();
                break;
            }
            case UPDATE_APP_VERSION: {
                this.handleAppVersionChange(arg);
                break;
            }
            case UPDATE_BUILD_UUID: {
                this.handleBuildUUIDChange(arg);
                break;
            }
            case UPDATE_CONTEXT: {
                this.handleContextChange(arg);
                break;
            }
            case UPDATE_IN_FOREGROUND: {
                this.handleForegroundActivityChange(arg);
                break;
            }
            case UPDATE_LOW_MEMORY: {
                this.handleLowMemoryChange(arg);
                break;
            }
            case UPDATE_METADATA: {
                this.handleUpdateMetadata(arg);
                break;
            }
            case UPDATE_ORIENTATION: {
                this.handleOrientationChange(arg);
                break;
            }
            case UPDATE_RELEASE_STAGE: {
                this.handleReleaseStageChange(arg);
                break;
            }
            case UPDATE_USER_ID: {
                this.handleUserIdChange(arg);
                break;
            }
            case UPDATE_USER_NAME: {
                this.handleUserNameChange(arg);
                break;
            }
            case UPDATE_USER_EMAIL: {
                this.handleUserEmailChange(arg);
                break;
            }
        }
    }

    @Nullable
    private NativeInterface.Message parseMessage(@Nullable Object rawMessage) {
        if (rawMessage instanceof NativeInterface.Message) {
            NativeInterface.Message message = (NativeInterface.Message)rawMessage;
            if (message.type != NativeInterface.MessageType.INSTALL && !installed.get()) {
                this.warn("Received message before INSTALL: " + message.type);
                return null;
            }
            return message;
        }
        if (rawMessage == null) {
            this.warn("Received observable update with null Message");
        } else {
            this.warn("Received observable update object which is not instance of Message: " + rawMessage.getClass());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverPendingReports() {
        lock.lock();
        try {
            File outDir = new File(this.reportDirectory);
            if (outDir.exists()) {
                File[] fileList = outDir.listFiles();
                if (fileList != null) {
                    for (File file : fileList) {
                        NativeBridge.deliverReportAtPath(file.getAbsolutePath());
                    }
                }
            } else {
                this.warn("Report directory does not exist, cannot read pending reports");
            }
        }
        catch (Exception ex) {
            this.warn("Failed to parse/write pending reports: " + ex);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInstallMessage(@NonNull Object arg) {
        lock.lock();
        try {
            if (installed.get()) {
                this.warn("Received duplicate setup message with arg: " + arg);
            } else if (arg instanceof List) {
                List values = (List)arg;
                if (values.size() > 0 && values.get(0) instanceof Configuration) {
                    Configuration config = (Configuration)values.get(0);
                    String reportPath = this.reportDirectory + UUID.randomUUID().toString() + ".crash";
                    NativeBridge.install(reportPath, config.getDetectNdkCrashes(), Build.VERSION.SDK_INT, this.is32bit());
                    installed.set(true);
                }
            } else {
                this.warn("Received install message with incorrect arg: " + arg);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private boolean is32bit() {
        String[] abis = NativeInterface.getCpuAbi();
        boolean is32bit = true;
        for (String abi : abis) {
            if (!abi.contains("64")) continue;
            is32bit = false;
            break;
        }
        return is32bit;
    }

    private void handleAddBreadcrumb(Object arg) {
        if (arg instanceof Breadcrumb) {
            Breadcrumb crumb = (Breadcrumb)arg;
            NativeBridge.addBreadcrumb(crumb.getName(), crumb.getType().toString(), crumb.getTimestamp(), crumb.getMetadata());
        } else {
            this.warn("Attempted to add non-breadcrumb: " + arg);
        }
    }

    private void handleAddMetadata(Object arg) {
        if (arg instanceof List) {
            List values = (List)arg;
            if (values.size() == 3 && values.get(0) instanceof String && values.get(1) instanceof String) {
                if (values.get(2) instanceof String) {
                    NativeBridge.addMetadataString((String)values.get(0), (String)values.get(1), (String)values.get(2));
                    return;
                }
                if (values.get(2) instanceof Boolean) {
                    NativeBridge.addMetadataBoolean((String)values.get(0), (String)values.get(1), (Boolean)values.get(2));
                    return;
                }
                if (values.get(2) instanceof Number) {
                    NativeBridge.addMetadataDouble((String)values.get(0), (String)values.get(1), ((Number)values.get(2)).doubleValue());
                    return;
                }
            } else if (values.size() == 2) {
                NativeBridge.removeMetadata((String)values.get(0), (String)values.get(1));
                return;
            }
        }
        this.warn("ADD_METADATA object is invalid: " + arg);
    }

    private void handleClearMetadataTab(Object arg) {
        if (arg instanceof String) {
            NativeBridge.clearMetadataTab((String)arg);
        } else {
            this.warn("CLEAR_METADATA_TAB object is invalid: " + arg);
        }
    }

    private void handleAppVersionChange(Object arg) {
        if (arg instanceof String) {
            NativeBridge.updateAppVersion((String)arg);
        } else {
            this.warn("UPDATE_APP_VERSION object is invalid: " + arg);
        }
    }

    private void handleRemoveMetadata(Object arg) {
        List metadata;
        if (arg instanceof List && (metadata = (List)arg).size() == 2) {
            NativeBridge.removeMetadata((String)metadata.get(0), (String)metadata.get(1));
            return;
        }
        this.warn("REMOVE_METADATA object is invalid: " + arg);
    }

    private void handleStartSession(Object arg) {
        List metadata;
        if (arg instanceof List && (metadata = (List)arg).size() == 4) {
            Object id = metadata.get(0);
            Object startTime = metadata.get(1);
            Object handledCount = metadata.get(2);
            Object unhandledCount = metadata.get(3);
            if (id instanceof String && startTime instanceof String && handledCount instanceof Integer && unhandledCount instanceof Integer) {
                NativeBridge.startedSession((String)id, (String)startTime, (Integer)handledCount, (Integer)unhandledCount);
                return;
            }
        }
        this.warn("START_SESSION object is invalid: " + arg);
    }

    private void handleStopSession() {
        NativeBridge.stoppedSession();
    }

    private void handleReleaseStageChange(Object arg) {
        if (arg instanceof String) {
            NativeBridge.updateReleaseStage((String)arg);
        } else {
            this.warn("UPDATE_RELEASE_STAGE object is invalid: " + arg);
        }
    }

    private void handleOrientationChange(Object arg) {
        if (arg instanceof Integer) {
            NativeBridge.updateOrientation((Integer)arg);
        } else if (arg == null) {
            this.warn("UPDATE_ORIENTATION object is null");
        } else {
            this.warn("UPDATE_ORIENTATION object is invalid: " + arg);
        }
    }

    private void handleForegroundActivityChange(Object arg) {
        List metadata;
        if (arg instanceof List && (metadata = (List)arg).size() == 2) {
            NativeBridge.updateInForeground((Boolean)metadata.get(0), (String)metadata.get(1));
            return;
        }
        this.warn("UPDATE_IN_FOREGROUND object is invalid: " + arg);
    }

    private void handleUserIdChange(Object arg) {
        if (arg == null) {
            NativeBridge.updateUserId("");
        } else if (arg instanceof String) {
            NativeBridge.updateUserId((String)arg);
        } else {
            this.warn("UPDATE_USER_ID object is invalid: " + arg);
        }
    }

    private void handleUserNameChange(Object arg) {
        if (arg == null) {
            NativeBridge.updateUserName("");
        } else if (arg instanceof String) {
            NativeBridge.updateUserName((String)arg);
        } else {
            this.warn("UPDATE_USER_NAME object is invalid: " + arg);
        }
    }

    private void handleUserEmailChange(Object arg) {
        if (arg == null) {
            NativeBridge.updateUserEmail("");
        } else if (arg instanceof String) {
            NativeBridge.updateUserEmail((String)arg);
        } else {
            this.warn("UPDATE_USER_EMAIL object is invalid: " + arg);
        }
    }

    private void handleBuildUUIDChange(Object arg) {
        if (arg == null) {
            NativeBridge.updateBuildUUID("");
        } else if (arg instanceof String) {
            NativeBridge.updateBuildUUID((String)arg);
        } else {
            this.warn("UPDATE_BUILD_UUID object is invalid: " + arg);
        }
    }

    private void handleContextChange(Object arg) {
        if (arg == null) {
            NativeBridge.updateContext("");
        } else if (arg instanceof String) {
            NativeBridge.updateContext((String)arg);
        } else {
            this.warn("UPDATE_CONTEXT object is invalid: " + arg);
        }
    }

    private void handleLowMemoryChange(Object arg) {
        if (arg instanceof Boolean) {
            NativeBridge.updateLowMemory((Boolean)arg);
        } else {
            this.warn("UPDATE_LOW_MEMORY object is invalid: " + arg);
        }
    }

    private void handleUpdateMetadata(Object arg) {
        if (arg instanceof MetaData) {
            NativeBridge.updateMetadata(arg);
        } else {
            this.warn("UPDATE_METADATA object is invalid: " + arg);
        }
    }

    private void warn(String message) {
        if (this.loggingEnabled) {
            Log.w((String)LOG_TAG, (String)message);
        }
    }
}

