/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Process;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeliveryStyle;
import com.bugsnag.android.Error;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/bugsnag/android/AnrDetailsCollector;", "", "()V", "handlerThread", "Landroid/os/HandlerThread;", "addErrorStateInfo", "", "error", "Lcom/bugsnag/android/Error;", "anrState", "Landroid/app/ActivityManager$ProcessErrorStateInfo;", "addErrorStateInfo$bugsnag_plugin_android_anr_release", "captureProcessErrorState", "am", "Landroid/app/ActivityManager;", "pid", "", "captureProcessErrorState$bugsnag_plugin_android_anr_release", "collectAnrDetails", "ctx", "Landroid/content/Context;", "collectAnrDetails$bugsnag_plugin_android_anr_release", "collectAnrErrorDetails", "client", "Lcom/bugsnag/android/Client;", "collectAnrErrorDetails$bugsnag_plugin_android_anr_release", "Companion", "bugsnag-plugin-android-anr_release"})
public final class AnrDetailsCollector {
    private final HandlerThread handlerThread = new HandlerThread("bugsnag-anr-collector");
    private static final long INFO_POLL_THRESHOLD_MS = 100L;
    private static final int MAX_ATTEMPTS = 300;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ActivityManager.ProcessErrorStateInfo collectAnrDetails$bugsnag_plugin_android_anr_release(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Object object = ctx.getSystemService("activity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager am = (ActivityManager)object;
        return this.captureProcessErrorState$bugsnag_plugin_android_anr_release(am, Process.myPid());
    }

    @VisibleForTesting
    @Nullable
    public final ActivityManager.ProcessErrorStateInfo captureProcessErrorState$bugsnag_plugin_android_anr_release(@NotNull ActivityManager am, int pid) {
        ActivityManager.ProcessErrorStateInfo processErrorStateInfo;
        Intrinsics.checkParameterIsNotNull((Object)am, (String)"am");
        try {
            Object v1;
            block4: {
                List list = am.getProcessesInErrorState();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List processes = list;
                Iterable $this$firstOrNull$iv = processes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ActivityManager.ProcessErrorStateInfo it = (ActivityManager.ProcessErrorStateInfo)element$iv;
                    boolean bl = false;
                    if (!(it.pid == pid)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            processErrorStateInfo = v1;
        }
        catch (RuntimeException exc) {
            processErrorStateInfo = null;
        }
        return processErrorStateInfo;
    }

    public final void addErrorStateInfo$bugsnag_plugin_android_anr_release(@NotNull Error error, @NotNull ActivityManager.ProcessErrorStateInfo anrState) {
        String msg;
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Intrinsics.checkParameterIsNotNull((Object)anrState, (String)"anrState");
        String string = msg = anrState.shortMsg;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"msg");
        error.setExceptionMessage(StringsKt.startsWith$default((String)string, (String)"ANR", (boolean)false, (int)2, null) ? StringsKt.replaceFirst$default((String)msg, (String)"ANR", (String)"", (boolean)false, (int)4, null) : msg);
    }

    public final void collectAnrErrorDetails$bugsnag_plugin_android_anr_release(@NotNull Client client, @NotNull Error error) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Handler handler = new Handler(this.handlerThread.getLooper());
        AtomicInteger attempts = new AtomicInteger();
        handler.post(new Runnable(this, client, attempts, handler, error){
            final /* synthetic */ AnrDetailsCollector this$0;
            final /* synthetic */ Client $client;
            final /* synthetic */ AtomicInteger $attempts;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Error $error;

            public void run() {
                Context context = this.$client.appContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"client.appContext");
                ActivityManager.ProcessErrorStateInfo anrDetails = this.this$0.collectAnrDetails$bugsnag_plugin_android_anr_release(context);
                if (anrDetails == null) {
                    if (this.$attempts.getAndIncrement() < 300) {
                        this.$handler.postDelayed((Runnable)this, 100L);
                    }
                } else {
                    this.this$0.addErrorStateInfo$bugsnag_plugin_android_anr_release(this.$error, anrDetails);
                    this.$client.notify(this.$error, DeliveryStyle.ASYNC_WITH_CACHE, null);
                }
            }
            {
                this.this$0 = $outer;
                this.$client = $captured_local_variable$1;
                this.$attempts = $captured_local_variable$2;
                this.$handler = $captured_local_variable$3;
                this.$error = $captured_local_variable$4;
            }
        });
    }

    public AnrDetailsCollector() {
        this.handlerThread.start();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/bugsnag/android/AnrDetailsCollector$Companion;", "", "()V", "INFO_POLL_THRESHOLD_MS", "", "MAX_ATTEMPTS", "", "bugsnag-plugin-android-anr_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

