/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.bugsnag.android.AppData;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.Error;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Report;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;

public class NativeInterface {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Client client;

    @NonNull
    private static Client getClient() {
        if (client != null) {
            return client;
        }
        return Bugsnag.getClient();
    }

    public static void setClient(@NonNull Client client) {
        if (NativeInterface.client == client) {
            return;
        }
        NativeInterface.client = client;
        NativeInterface.configureClientObservers(client);
    }

    public static void configureClientObservers(@NonNull Client client) {
        try {
            String className = "com.bugsnag.android.ndk.NativeBridge";
            Class<?> clz = Class.forName(className);
            Observer observer = (Observer)clz.newInstance();
            client.addObserver(observer);
        }
        catch (ClassNotFoundException exception) {
            Logger.info("Bugsnag NDK integration not available");
        }
        catch (InstantiationException exception) {
            Logger.warn("Failed to instantiate NDK observer", exception);
        }
        catch (IllegalAccessException exception) {
            Logger.warn("Could not access NDK observer", exception);
        }
        client.sendNativeSetupNotification();
    }

    public static String getContext() {
        return NativeInterface.getClient().getContext();
    }

    public static boolean getLoggingEnabled() {
        return Logger.getEnabled();
    }

    public static String getNativeReportPath() {
        return NativeInterface.getClient().appContext.getCacheDir().getAbsolutePath() + "/bugsnag-native/";
    }

    @NonNull
    public static Map<String, String> getUserData() {
        HashMap<String, String> userData = new HashMap<String, String>();
        User user = NativeInterface.getClient().getUser();
        userData.put("id", user.getId());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        return userData;
    }

    @NonNull
    public static Map<String, Object> getAppData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AppData source = NativeInterface.getClient().getAppData();
        data.putAll(source.getAppData());
        data.putAll(source.getAppDataMetaData());
        return data;
    }

    @NonNull
    public static Map<String, Object> getDeviceData() {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        DeviceData source = NativeInterface.getClient().getDeviceData();
        deviceData.putAll(source.getDeviceMetaData());
        deviceData.putAll(source.getDeviceData());
        return deviceData;
    }

    @NonNull
    public static Map<String, Object> getMetaData() {
        return NativeInterface.getClient().getMetaData().store;
    }

    public static void setUser(String id, String email, String name) {
        Client client = NativeInterface.getClient();
        client.setUserId(id);
        client.setUserEmail(email);
        client.setUserName(name);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type) {
        NativeInterface.getClient().leaveBreadcrumb(name, type, new HashMap<String, String>());
    }

    public static void addToTab(String tab, String key, Object value) {
        NativeInterface.getClient().addToTab(tab, key, value);
    }

    public static void deliverReport(String releaseStage, String payload) {
        Client client = NativeInterface.getClient();
        if (releaseStage == null || releaseStage.length() == 0 || client.getConfig().shouldNotifyForReleaseStage(releaseStage)) {
            client.getErrorStore().enqueueContentForDelivery(payload);
            client.getErrorStore().flushAsync();
        }
    }

    public static void notify(@NonNull String name, @NonNull String message, final Severity severity, @NonNull StackTraceElement[] stacktrace) {
        NativeInterface.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                Error error = report.getError();
                if (error != null) {
                    if (severity != null) {
                        error.setSeverity(severity);
                    }
                    error.getExceptions().setExceptionType("c");
                }
            }
        });
    }

    public static class Message {
        public final MessageType type;
        public final Object value;

        public Message(MessageType type, Object value) {
            this.type = type;
            this.value = value;
        }
    }

    public static enum MessageType {
        ADD_BREADCRUMB,
        ADD_METADATA,
        CLEAR_BREADCRUMBS,
        CLEAR_METADATA_TAB,
        DELIVER_PENDING,
        INSTALL,
        NOTIFY_HANDLED,
        REMOVE_METADATA,
        START_SESSION,
        UPDATE_APP_VERSION,
        UPDATE_BUILD_UUID,
        UPDATE_CONTEXT,
        UPDATE_IN_FOREGROUND,
        UPDATE_LOW_MEMORY,
        UPDATE_METADATA,
        UPDATE_ORIENTATION,
        UPDATE_RELEASE_STAGE,
        UPDATE_USER_EMAIL,
        UPDATE_USER_NAME,
        UPDATE_USER_ID;

    }
}

