/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.NotifyType;
import com.bugsnag.android.ObjectJsonStreamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public class MetaData
extends Observable
implements JsonStream.Streamable {
    @NonNull
    final Map<String, Object> store;
    final ObjectJsonStreamer jsonStreamer;

    public MetaData() {
        this(new ConcurrentHashMap<String, Object>());
    }

    public MetaData(@NonNull Map<String, Object> map) {
        this.store = new ConcurrentHashMap<String, Object>(map);
        this.jsonStreamer = new ObjectJsonStreamer();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        this.jsonStreamer.objectToStream(this.store, writer);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.addToTab(tabName, key, value, true);
    }

    void addToTab(String tabName, String key, @Nullable Object value, boolean notify) {
        Map<String, Object> tab = this.getTab(tabName);
        if (value != null) {
            tab.put(key, value);
        } else {
            tab.remove(key);
        }
        this.notifyBugsnagObservers(NotifyType.META);
    }

    public void clearTab(String tabName) {
        this.store.remove(tabName);
        this.notifyBugsnagObservers(NotifyType.META);
    }

    @NonNull
    Map<String, Object> getTab(String tabName) {
        ConcurrentHashMap tab = (ConcurrentHashMap)this.store.get(tabName);
        if (tab == null) {
            tab = new ConcurrentHashMap();
            this.store.put(tabName, tab);
        }
        return tab;
    }

    void setFilters(String ... filters) {
        this.jsonStreamer.filters = filters;
        this.notifyBugsnagObservers(NotifyType.FILTERS);
    }

    String[] getFilters() {
        return this.jsonStreamer.filters;
    }

    @NonNull
    static MetaData merge(MetaData ... metaDataList) {
        ArrayList<Map<String, Object>> stores = new ArrayList<Map<String, Object>>();
        ArrayList<String> filters = new ArrayList<String>();
        for (MetaData metaData : metaDataList) {
            if (metaData == null) continue;
            stores.add(metaData.store);
            if (metaData.jsonStreamer.filters == null) continue;
            filters.addAll(Arrays.asList(metaData.jsonStreamer.filters));
        }
        MetaData newMeta = new MetaData(MetaData.mergeMaps(stores.toArray(new Map[0])));
        newMeta.setFilters(filters.toArray(new String[filters.size()]));
        return newMeta;
    }

    @SafeVarargs
    @NonNull
    private static Map<String, Object> mergeMaps(Map<String, Object> ... maps) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            if (map == null) continue;
            HashSet allKeys = new HashSet(result.keySet());
            allKeys.addAll(map.keySet());
            for (String key : allKeys) {
                Object baseValue = result.get(key);
                Object overridesValue = map.get(key);
                if (overridesValue != null) {
                    if (baseValue != null && baseValue instanceof Map && overridesValue instanceof Map) {
                        Map first = (Map)baseValue;
                        Map second = (Map)overridesValue;
                        result.put(key, MetaData.mergeMaps(first, second));
                        continue;
                    }
                    result.put(key, overridesValue);
                    continue;
                }
                result.put(key, baseValue);
            }
        }
        return result;
    }

    private void notifyBugsnagObservers(@NonNull NotifyType type) {
        this.setChanged();
        super.notifyObservers(type.getValue());
    }
}

