/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;

class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int EOF = -1;

    IOUtils() {
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(@Nullable URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static int copy(@NonNull Reader input, @NonNull Writer output) throws IOException {
        int read;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (read = input.read(buffer))) {
            output.write(buffer, 0, read);
            count += (long)read;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }
}

