/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.AppDataSummary;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SessionTracker;
import java.io.IOException;

class AppData
extends AppDataSummary {
    private static final long startTimeMs = SystemClock.elapsedRealtime();
    @Nullable
    final String appName;
    @NonNull
    private final Context appContext;
    private final SessionTracker sessionTracker;
    @NonNull
    protected final String packageName;

    AppData(@NonNull Context appContext, @NonNull Configuration config, SessionTracker sessionTracker) {
        super(appContext, config);
        this.appContext = appContext;
        this.sessionTracker = sessionTracker;
        this.appName = AppData.getAppName(appContext);
        this.packageName = AppData.getPackageName(appContext);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        this.serialiseMinimalAppData(writer);
        writer.name("id").value(this.packageName);
        writer.name("buildUUID").value(this.config.getBuildUUID());
        writer.name("duration").value(AppData.getDurationMs());
        long foregroundMs = this.sessionTracker.getDurationInForegroundMs(System.currentTimeMillis());
        writer.name("durationInForeground").value(foregroundMs);
        writer.name("inForeground").value(this.sessionTracker.isInForeground());
        writer.name("name").value(this.appName);
        writer.name("packageName").value(this.packageName);
        writer.name("versionName").value(this.versionName);
        writer.name("activeScreen").value(this.getActiveScreenClass());
        writer.name("memoryUsage").value(AppData.getMemoryUsage());
        writer.name("lowMemory").value(AppData.isLowMemory(this.appContext));
        writer.endObject();
    }

    @Nullable
    private static String getAppName(@NonNull Context appContext) {
        try {
            PackageManager packageManager = appContext.getPackageManager();
            String packageName = appContext.getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 0);
            return (String)packageManager.getApplicationLabel(appInfo);
        }
        catch (PackageManager.NameNotFoundException exception) {
            Logger.warn("Could not get app name");
            return null;
        }
    }

    @Nullable
    String getActiveScreenClass() {
        return this.sessionTracker.getContextActivity();
    }

    @NonNull
    private static Long getMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Nullable
    private static Boolean isLowMemory(@NonNull Context appContext) {
        try {
            ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
            if (activityManager != null) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                activityManager.getMemoryInfo(memInfo);
                return memInfo.lowMemory;
            }
        }
        catch (Exception exception) {
            Logger.warn("Could not check lowMemory status");
        }
        return null;
    }

    static long getDurationMs() {
        return SystemClock.elapsedRealtime() - startTimeMs;
    }

    @NonNull
    private static String getPackageName(@NonNull Context appContext) {
        return appContext.getPackageName();
    }
}

