/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.DeviceDataSummary;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

class DeviceData
extends DeviceDataSummary {
    private static final String INSTALL_ID_KEY = "install.iud";
    @Nullable
    final Float screenDensity;
    @Nullable
    final Integer dpi;
    @Nullable
    final String screenResolution;
    private Context appContext;
    @NonNull
    final String locale;
    @Nullable
    protected String id;
    @NonNull
    final String[] cpuAbi;

    DeviceData(@NonNull Context appContext, @NonNull SharedPreferences sharedPref) {
        this.screenDensity = DeviceData.getScreenDensity(appContext);
        this.dpi = DeviceData.getScreenDensityDpi(appContext);
        this.screenResolution = DeviceData.getScreenResolution(appContext);
        this.appContext = appContext;
        this.locale = DeviceData.getLocale();
        this.id = this.retrieveUniqueInstallId(sharedPref);
        this.cpuAbi = DeviceData.getCpuAbi();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        this.serialiseMinimalDeviceData(writer);
        writer.name("id").value(this.id).name("freeMemory").value(DeviceData.getFreeMemory()).name("totalMemory").value(DeviceData.getTotalMemory()).name("freeDisk").value(DeviceData.getFreeDisk()).name("orientation").value(DeviceData.getOrientation(this.appContext));
        writer.name("batteryLevel").value(DeviceData.getBatteryLevel(this.appContext)).name("charging").value(DeviceData.isCharging(this.appContext)).name("locationStatus").value(DeviceData.getLocationStatus(this.appContext)).name("networkAccess").value(DeviceData.getNetworkAccess(this.appContext)).name("time").value(this.getTime()).name("brand").value(Build.BRAND).name("apiLevel").value(Build.VERSION.SDK_INT).name("osBuild").value(Build.DISPLAY).name("locale").value(this.locale).name("screenDensity").value(this.screenDensity).name("dpi").value(this.dpi).name("emulator").value(this.isEmulator()).name("screenResolution").value(this.screenResolution);
        writer.name("cpuAbi").beginArray();
        for (String s : this.cpuAbi) {
            writer.value(s);
        }
        writer.endArray();
        writer.endObject();
    }

    @NonNull
    String getUserId() {
        return this.id;
    }

    void setId(@Nullable String id) {
        this.id = id;
    }

    private boolean isEmulator() {
        String fingerprint = Build.FINGERPRINT;
        return fingerprint.startsWith("unknown") || fingerprint.contains("generic") || fingerprint.contains("vbox");
    }

    @Nullable
    private static Float getScreenDensity(@NonNull Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        return Float.valueOf(resources.getDisplayMetrics().density);
    }

    @Nullable
    private static Integer getScreenDensityDpi(@NonNull Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        return resources.getDisplayMetrics().densityDpi;
    }

    @Nullable
    private static String getScreenResolution(@NonNull Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        DisplayMetrics metrics = resources.getDisplayMetrics();
        int max = Math.max(metrics.widthPixels, metrics.heightPixels);
        int min = Math.min(metrics.widthPixels, metrics.heightPixels);
        return String.format(Locale.US, "%dx%d", max, min);
    }

    @NonNull
    static Long getTotalMemory() {
        if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
            return Runtime.getRuntime().maxMemory();
        }
        return Runtime.getRuntime().totalMemory();
    }

    @NonNull
    private static String getLocale() {
        return Locale.getDefault().toString();
    }

    @Nullable
    private String retrieveUniqueInstallId(@NonNull SharedPreferences sharedPref) {
        String installId = sharedPref.getString(INSTALL_ID_KEY, null);
        if (installId == null) {
            installId = UUID.randomUUID().toString();
            sharedPref.edit().putString(INSTALL_ID_KEY, installId).apply();
        }
        return installId;
    }

    @NonNull
    private static String[] getCpuAbi() {
        if (Build.VERSION.SDK_INT >= 21) {
            return SupportedAbiWrapper.getSupportedAbis();
        }
        return Abi2Wrapper.getAbi1andAbi2();
    }

    @Nullable
    private static Long getFreeDisk() {
        try {
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long internalBytesAvailable = (long)internalStat.getBlockSize() * (long)internalStat.getBlockCount();
            return Math.min(internalBytesAvailable, externalBytesAvailable);
        }
        catch (Exception exception) {
            Logger.warn("Could not get freeDisk");
            return null;
        }
    }

    @NonNull
    private static Long getFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        if (runtime.maxMemory() != Long.MAX_VALUE) {
            return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        }
        return runtime.freeMemory();
    }

    @Nullable
    private static String getOrientation(@NonNull Context appContext) {
        String orientation;
        switch (appContext.getResources().getConfiguration().orientation) {
            case 2: {
                orientation = "landscape";
                break;
            }
            case 1: {
                orientation = "portrait";
                break;
            }
            default: {
                orientation = null;
            }
        }
        return orientation;
    }

    @Nullable
    private static Float getBatteryLevel(@NonNull Context appContext) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = appContext.registerReceiver(null, ifilter);
            return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)batteryStatus.getIntExtra("scale", -1));
        }
        catch (Exception exception) {
            Logger.warn("Could not get batteryLevel");
            return null;
        }
    }

    @Nullable
    private static Boolean isCharging(@NonNull Context appContext) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = appContext.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            return status == 2 || status == 5;
        }
        catch (Exception exception) {
            Logger.warn("Could not get charging status");
            return null;
        }
    }

    @Nullable
    private static String getLocationStatus(@NonNull Context appContext) {
        try {
            ContentResolver cr = appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed != null && providersAllowed.length() > 0) {
                return "allowed";
            }
            return "disallowed";
        }
        catch (Exception exception) {
            Logger.warn("Could not get locationStatus");
            return null;
        }
    }

    @Nullable
    private static String getNetworkAccess(@NonNull Context appContext) {
        try {
            ConnectivityManager cm = (ConnectivityManager)appContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnectedOrConnecting()) {
                if (activeNetwork.getType() == 1) {
                    return "wifi";
                }
                if (activeNetwork.getType() == 9) {
                    return "ethernet";
                }
                return "cellular";
            }
            return "none";
        }
        catch (Exception exception) {
            Logger.warn("Could not get network access information, we recommend granting the 'android.permission.ACCESS_NETWORK_STATE' permission");
            return null;
        }
    }

    @NonNull
    private String getTime() {
        return DateUtils.toIso8601(new Date());
    }

    private static class Abi2Wrapper {
        private Abi2Wrapper() {
        }

        @NonNull
        public static String[] getAbi1andAbi2() {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
    }

    private static class SupportedAbiWrapper {
        private SupportedAbiWrapper() {
        }

        @RequiresApi(value=21)
        public static String[] getSupportedAbis() {
            return Build.SUPPORTED_ABIS;
        }
    }
}

