/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.Async;
import com.bugsnag.android.BadResponseException;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.SessionTrackingPayload;
import com.bugsnag.android.User;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class SessionTracker
implements Application.ActivityLifecycleCallbacks {
    private static final String KEY_LIFECYCLE_CALLBACK = "ActivityLifecycle";
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private final ConcurrentHashMap<String, Boolean> foregroundActivities = new ConcurrentHashMap();
    private final Configuration configuration;
    private final long timeoutMs;
    private final Client client;
    private final SessionStore sessionStore;
    private final SessionTrackingApiClient apiClient;
    private AtomicLong activityLastStoppedAtMs = new AtomicLong(0L);
    private AtomicLong activityFirstStartedAtMs = new AtomicLong(0L);
    private AtomicReference<Session> currentSession = new AtomicReference();
    private Semaphore flushingRequest = new Semaphore(1);

    SessionTracker(Configuration configuration, Client client, SessionStore sessionStore, SessionTrackingApiClient apiClient) {
        this(configuration, client, 30000L, sessionStore, apiClient);
    }

    SessionTracker(Configuration configuration, Client client, long timeoutMs, SessionStore sessionStore, SessionTrackingApiClient apiClient) {
        this.configuration = configuration;
        this.client = client;
        this.timeoutMs = timeoutMs;
        this.sessionStore = sessionStore;
        this.apiClient = apiClient;
    }

    void startNewSession(@NonNull Date date, @Nullable User user, boolean autoCaptured) {
        Session session = new Session(UUID.randomUUID().toString(), date, user, autoCaptured);
        this.currentSession.set(session);
        this.trackSessionIfNeeded(session);
    }

    private void trackSessionIfNeeded(final Session session) {
        boolean notifyForRelease = this.configuration.shouldNotifyForReleaseStage(this.getReleaseStage());
        if (notifyForRelease && (this.configuration.shouldAutoCaptureSessions() || !session.isAutoCaptured()) && session.isTracked().compareAndSet(false, true)) {
            try {
                final String endpoint = this.configuration.getSessionEndpoint();
                Async.run(new Runnable(){

                    @Override
                    public void run() {
                        SessionTracker.this.flushStoredSessions();
                        SessionTrackingPayload payload = new SessionTrackingPayload(session, ((SessionTracker)SessionTracker.this).client.appData);
                        try {
                            SessionTracker.this.apiClient.postSessionTrackingPayload(endpoint, payload, SessionTracker.this.configuration.getSessionApiHeaders());
                        }
                        catch (NetworkException e) {
                            Logger.info("Failed to post session payload");
                            SessionTracker.this.sessionStore.write(session);
                        }
                        catch (BadResponseException e) {
                            Logger.warn("Invalid session tracking payload", e);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.sessionStore.write(session);
            }
        }
    }

    void onAutoCaptureEnabled() {
        Session session = this.currentSession.get();
        if (session != null && !this.foregroundActivities.isEmpty()) {
            this.trackSessionIfNeeded(session);
        }
    }

    private String getReleaseStage() {
        return this.client.appData.getReleaseStage();
    }

    @Nullable
    Session getCurrentSession() {
        return this.currentSession.get();
    }

    void incrementUnhandledError() {
        Session session = this.currentSession.get();
        if (session != null) {
            session.incrementUnhandledErrCount();
        }
    }

    void incrementHandledError() {
        Session session = this.currentSession.get();
        if (session != null) {
            session.incrementHandledErrCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushStoredSessions() {
        if (this.flushingRequest.tryAcquire(1)) {
            try {
                List<File> storedFiles = this.sessionStore.findStoredFiles();
                if (!storedFiles.isEmpty()) {
                    SessionTrackingPayload payload = new SessionTrackingPayload(storedFiles, this.client.appData);
                    try {
                        String endpoint = this.configuration.getSessionEndpoint();
                        this.apiClient.postSessionTrackingPayload(endpoint, payload, this.configuration.getSessionApiHeaders());
                        this.deleteStoredFiles(storedFiles);
                    }
                    catch (NetworkException e) {
                        Logger.info("Failed to post stored session payload");
                    }
                    catch (BadResponseException e) {
                        Logger.warn("Invalid session tracking payload", e);
                        this.deleteStoredFiles(storedFiles);
                    }
                }
            }
            finally {
                this.flushingRequest.release(1);
            }
        }
    }

    private void deleteStoredFiles(Collection<File> storedFiles) {
        for (File storedFile : storedFiles) {
            storedFile.delete();
        }
    }

    public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onCreate()");
    }

    public void onActivityStarted(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStart()");
        this.updateForegroundTracker(activityName, true, System.currentTimeMillis());
    }

    public void onActivityResumed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onResume()");
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onPause()");
    }

    public void onActivityStopped(@NonNull Activity activity) {
        String activityName = this.getActivityName(activity);
        this.leaveLifecycleBreadcrumb(activityName, "onStop()");
        this.updateForegroundTracker(activityName, false, System.currentTimeMillis());
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onSaveInstanceState()");
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.leaveLifecycleBreadcrumb(this.getActivityName(activity), "onDestroy()");
    }

    private String getActivityName(@NonNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    void leaveLifecycleBreadcrumb(String activityName, String lifecycleCallback) {
        this.leaveBreadcrumb(activityName, lifecycleCallback);
    }

    private void leaveBreadcrumb(String activityName, String lifecycleCallback) {
        if (this.configuration.isAutomaticallyCollectingBreadcrumbs()) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(KEY_LIFECYCLE_CALLBACK, lifecycleCallback);
            this.client.leaveBreadcrumb(activityName, BreadcrumbType.NAVIGATION, metadata);
        }
    }

    void startFirstSession(Activity activity) {
        Session session = this.currentSession.get();
        if (session == null) {
            long nowMs = System.currentTimeMillis();
            this.activityFirstStartedAtMs.set(nowMs);
            this.startNewSession(new Date(nowMs), this.client.user, true);
            this.foregroundActivities.put(this.getActivityName(activity), true);
        }
    }

    void updateForegroundTracker(String activityName, boolean activityStarting, long nowMs) {
        if (activityStarting) {
            long noActivityRunningForMs = nowMs - this.activityLastStoppedAtMs.get();
            if (this.foregroundActivities.isEmpty() && noActivityRunningForMs >= this.timeoutMs && this.configuration.shouldAutoCaptureSessions()) {
                this.activityFirstStartedAtMs.set(nowMs);
                this.startNewSession(new Date(nowMs), this.client.user, true);
            }
            this.foregroundActivities.put(activityName, true);
        } else {
            this.foregroundActivities.remove(activityName);
            this.activityLastStoppedAtMs.set(nowMs);
        }
    }

    boolean isInForeground() {
        return !this.foregroundActivities.isEmpty();
    }

    long getDurationInForegroundMs(long nowMs) {
        long durationMs = 0L;
        long sessionStartTimeMs = this.activityFirstStartedAtMs.get();
        if (this.isInForeground() && sessionStartTimeMs != 0L) {
            durationMs = nowMs - sessionStartTimeMs;
        }
        return durationMs > 0L ? durationMs : 0L;
    }
}

