/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.NotifyType;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public class MetaData
extends Observable
implements JsonStream.Streamable {
    private static final String FILTERED_PLACEHOLDER = "[FILTERED]";
    private static final String OBJECT_PLACEHOLDER = "[OBJECT]";
    private String[] filters;
    @NonNull
    final Map<String, Object> store;

    public MetaData() {
        this.store = new ConcurrentHashMap<String, Object>();
    }

    public MetaData(@NonNull Map<String, Object> m) {
        this.store = new ConcurrentHashMap<String, Object>(m);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        this.objectToStream(this.store, writer);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.addToTab(tabName, key, value, true);
    }

    void addToTab(String tabName, String key, @Nullable Object value, boolean notify) {
        Map<String, Object> tab = this.getTab(tabName);
        if (value != null) {
            tab.put(key, value);
        } else {
            tab.remove(key);
        }
        this.notifyBugsnagObservers(NotifyType.META);
    }

    public void clearTab(String tabName) {
        this.store.remove(tabName);
        this.notifyBugsnagObservers(NotifyType.META);
    }

    @NonNull
    Map<String, Object> getTab(String tabName) {
        ConcurrentHashMap tab = (ConcurrentHashMap)this.store.get(tabName);
        if (tab == null) {
            tab = new ConcurrentHashMap();
            this.store.put(tabName, tab);
        }
        return tab;
    }

    void setFilters(String ... filters) {
        this.filters = filters;
        this.notifyBugsnagObservers(NotifyType.FILTERS);
    }

    @NonNull
    static MetaData merge(MetaData ... metaDataList) {
        ArrayList<Map<String, Object>> stores = new ArrayList<Map<String, Object>>();
        ArrayList<String> filters = new ArrayList<String>();
        for (MetaData metaData : metaDataList) {
            if (metaData == null) continue;
            stores.add(metaData.store);
            if (metaData.filters == null) continue;
            filters.addAll(Arrays.asList(metaData.filters));
        }
        MetaData newMeta = new MetaData(MetaData.mergeMaps(stores.toArray(new Map[0])));
        newMeta.filters = filters.toArray(new String[filters.size()]);
        return newMeta;
    }

    @NonNull
    private static Map<String, Object> mergeMaps(Map<String, Object> ... maps) {
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>();
        for (Map<String, Object> map : maps) {
            if (map == null) continue;
            HashSet allKeys = new HashSet(result.keySet());
            allKeys.addAll(map.keySet());
            for (String key : allKeys) {
                Object baseValue = result.get(key);
                Object overridesValue = map.get(key);
                if (overridesValue != null) {
                    if (baseValue != null && baseValue instanceof Map && overridesValue instanceof Map) {
                        result.put(key, MetaData.mergeMaps((Map)baseValue, (Map)overridesValue));
                        continue;
                    }
                    result.put(key, overridesValue);
                    continue;
                }
                result.put(key, baseValue);
            }
        }
        return result;
    }

    private void objectToStream(@Nullable Object obj, @NonNull JsonStream writer) throws IOException {
        if (obj == null) {
            writer.nullValue();
        } else if (obj instanceof String) {
            writer.value((String)obj);
        } else if (obj instanceof Number) {
            writer.value((Number)obj);
        } else if (obj instanceof Boolean) {
            writer.value((Boolean)obj);
        } else if (obj instanceof Map) {
            writer.beginObject();
            for (Map.Entry o : ((Map)obj).entrySet()) {
                Map.Entry entry = o;
                Object keyObj = entry.getKey();
                if (!(keyObj instanceof String)) continue;
                String key = (String)keyObj;
                writer.name(key);
                if (this.shouldFilter(key)) {
                    writer.value(FILTERED_PLACEHOLDER);
                    continue;
                }
                this.objectToStream(entry.getValue(), writer);
            }
            writer.endObject();
        } else if (obj instanceof Collection) {
            writer.beginArray();
            for (Object entry : (Collection)obj) {
                this.objectToStream(entry, writer);
            }
            writer.endArray();
        } else if (obj.getClass().isArray()) {
            writer.beginArray();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.objectToStream(Array.get(obj, i), writer);
            }
            writer.endArray();
        } else {
            writer.value(OBJECT_PLACEHOLDER);
        }
    }

    private boolean shouldFilter(@Nullable String key) {
        if (this.filters == null || key == null) {
            return false;
        }
        for (String filter : this.filters) {
            if (!key.contains(filter)) continue;
            return true;
        }
        return false;
    }

    private void notifyBugsnagObservers(@NonNull NotifyType type) {
        this.setChanged();
        super.notifyObservers(type.getValue());
    }
}

