/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.bugsnag.android.BadResponseException;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.SessionTrackingPayload;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

class DefaultHttpClient
implements ErrorReportApiClient,
SessionTrackingApiClient {
    private final ConnectivityManager connectivityManager;

    DefaultHttpClient(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
    }

    @Override
    public void postReport(String urlString, Report report, Map<String, String> headers) throws NetworkException, BadResponseException {
        int status = this.makeRequest(urlString, report, headers);
        if (status / 100 != 2) {
            throw new BadResponseException(urlString, status);
        }
        Logger.info("Completed error API request");
    }

    @Override
    public void postSessionTrackingPayload(String urlString, SessionTrackingPayload payload, Map<String, String> headers) throws NetworkException, BadResponseException {
        int status = this.makeRequest(urlString, payload, headers);
        if (status != 202) {
            throw new BadResponseException(urlString, status);
        }
        Logger.info("Completed session tracking request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeRequest(String urlString, JsonStream.Streamable streamable, Map<String, String> headers) throws NetworkException {
        int n;
        this.checkHasNetworkConnection(urlString);
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setChunkedStreamingMode(0);
            conn.addRequestProperty("Content-Type", "application/json");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.addRequestProperty(entry.getKey(), entry.getValue());
            }
            OutputStream out = null;
            try {
                out = conn.getOutputStream();
                JsonStream stream = new JsonStream(new OutputStreamWriter(out));
                streamable.toStream(stream);
                stream.close();
            }
            finally {
                IOUtils.closeQuietly(out);
            }
            n = conn.getResponseCode();
        }
        catch (IOException e) {
            try {
                throw new NetworkException(urlString, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(conn);
                throw throwable;
            }
        }
        IOUtils.close(conn);
        return n;
    }

    private void checkHasNetworkConnection(String urlString) throws NetworkException {
        NetworkInfo activeNetworkInfo = this.connectivityManager.getActiveNetworkInfo();
        if (activeNetworkInfo == null || !activeNetworkInfo.isConnectedOrConnecting()) {
            throw new NetworkException(urlString, new RuntimeException("No network connection available"));
        }
    }
}

