/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

class ThreadState
implements JsonStream.Streamable {
    private static final String THREAD_TYPE = "android";
    final Configuration config;

    ThreadState(Configuration config) {
        this.config = config;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        long currentId = Thread.currentThread().getId();
        Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
        Set<Thread> threadSet = liveThreads.keySet();
        Thread[] keys = threadSet.toArray(new Thread[threadSet.size()]);
        Arrays.sort(keys, new Comparator<Thread>(){

            @Override
            public int compare(@NonNull Thread a, @NonNull Thread b) {
                return Long.valueOf(a.getId()).compareTo(b.getId());
            }
        });
        writer.beginArray();
        for (Thread thread : keys) {
            if (thread.getId() == currentId) continue;
            StackTraceElement[] stacktrace = liveThreads.get(thread);
            writer.beginObject();
            writer.name("id").value(thread.getId());
            writer.name("name").value(thread.getName());
            writer.name("type").value(THREAD_TYPE);
            writer.name("stacktrace").value(new Stacktrace(this.config, stacktrace));
            writer.endObject();
        }
        writer.endArray();
    }
}

