/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceDataSummary;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NotifyType;
import com.bugsnag.android.Report;
import com.bugsnag.android.Severity;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;

public class NativeInterface {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Client client;

    @NonNull
    private static Client getClient() {
        if (client != null) {
            return client;
        }
        return Bugsnag.getClient();
    }

    public static void setClient(@NonNull Client client) {
        NativeInterface.client = client;
        NativeInterface.configureClientObservers(client);
    }

    public static void configureClientObservers(@NonNull Client client) {
        try {
            String className = "com.bugsnag.android.ndk.BugsnagObserver";
            Class<?> c = Class.forName(className);
            Observer o = (Observer)c.newInstance();
            client.addObserver(o);
        }
        catch (ClassNotFoundException e) {
            Logger.info("Bugsnag NDK integration not available");
        }
        catch (InstantiationException e) {
            Logger.warn("Failed to instantiate NDK observer", e);
        }
        catch (IllegalAccessException e) {
            Logger.warn("Could not access NDK observer", e);
        }
        client.notifyBugsnagObservers(NotifyType.ALL);
    }

    public static String getContext() {
        return NativeInterface.getClient().getContext();
    }

    @Nullable
    public static String getErrorStorePath() {
        return NativeInterface.getClient().errorStore.storeDirectory;
    }

    public static String getUserId() {
        return NativeInterface.getClient().user.getId();
    }

    public static String getUserEmail() {
        return NativeInterface.getClient().user.getEmail();
    }

    public static String getUserName() {
        return NativeInterface.getClient().user.getName();
    }

    @NonNull
    public static String getPackageName() {
        return NativeInterface.getClient().appData.packageName;
    }

    @Nullable
    public static String getAppName() {
        return NativeInterface.getClient().appData.appName;
    }

    @Nullable
    public static String getVersionName() {
        return NativeInterface.getClient().appData.versionName;
    }

    public static int getVersionCode() {
        return NativeInterface.getClient().appData.versionCode;
    }

    public static String getBuildUUID() {
        return NativeInterface.getClient().config.getBuildUUID();
    }

    @Nullable
    public static String getAppVersion() {
        return NativeInterface.getClient().appData.getAppVersion();
    }

    public static String getReleaseStage() {
        return NativeInterface.getClient().appData.getReleaseStage();
    }

    @Nullable
    public static String getDeviceId() {
        return NativeInterface.getClient().deviceData.id;
    }

    @NonNull
    public static String getDeviceLocale() {
        return NativeInterface.getClient().deviceData.locale;
    }

    public static double getDeviceTotalMemory() {
        return DeviceData.getTotalMemory().longValue();
    }

    @Nullable
    public static Boolean getDeviceRooted() {
        return DeviceDataSummary.isRooted();
    }

    public static float getDeviceScreenDensity() {
        return NativeInterface.getClient().deviceData.screenDensity.floatValue();
    }

    public static int getDeviceDpi() {
        return NativeInterface.getClient().deviceData.dpi;
    }

    @Nullable
    public static String getDeviceScreenResolution() {
        return NativeInterface.getClient().deviceData.screenResolution;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getDeviceOsBuild() {
        return Build.DISPLAY;
    }

    public static int getDeviceApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    @NonNull
    public static String[] getDeviceCpuAbi() {
        return NativeInterface.getClient().deviceData.cpuAbi;
    }

    @NonNull
    public static Map<String, Object> getMetaData() {
        return NativeInterface.getClient().getMetaData().store;
    }

    public static Object[] getBreadcrumbs() {
        return NativeInterface.getClient().breadcrumbs.store.toArray();
    }

    public static String[] getFilters() {
        return NativeInterface.getClient().config.getFilters();
    }

    @Nullable
    public static String[] getReleaseStages() {
        return NativeInterface.getClient().config.getNotifyReleaseStages();
    }

    public static void setUser(String id, String email, String name) {
        NativeInterface.getClient().setUserId(id, false);
        NativeInterface.getClient().setUserEmail(email, false);
        NativeInterface.getClient().setUserName(name, false);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type) {
        NativeInterface.getClient().leaveBreadcrumb(name, type, new HashMap<String, String>(), false);
    }

    public static void addToTab(String tab, String key, Object value) {
        NativeInterface.getClient().config.getMetaData().addToTab(tab, key, value, false);
    }

    public static void notify(@NonNull String name, @NonNull String message, final Severity severity, @NonNull StackTraceElement[] stacktrace, final @NonNull Map<String, Object> metaData) {
        NativeInterface.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(severity);
                report.getError().config.defaultExceptionType = "c";
                for (String tab : metaData.keySet()) {
                    Object value = metaData.get(tab);
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        for (Object key : map.keySet()) {
                            report.getError().getMetaData().addToTab(tab, key.toString(), map.get(key));
                        }
                        continue;
                    }
                    report.getError().getMetaData().addToTab("custom", tab, value);
                }
            }
        });
    }
}

