/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.AppDataSummary;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.SessionTracker;
import java.io.IOException;
import java.util.List;

class AppData
extends AppDataSummary {
    private static final long startTime = SystemClock.elapsedRealtime();
    @Nullable
    final String appName;
    @NonNull
    private final Context appContext;
    private final SessionTracker sessionTracker;
    @NonNull
    protected final String packageName;

    AppData(@NonNull Context appContext, @NonNull Configuration config, SessionTracker sessionTracker) {
        super(appContext, config);
        this.appContext = appContext;
        this.sessionTracker = sessionTracker;
        this.appName = AppData.getAppName(appContext);
        this.packageName = AppData.getPackageName(appContext);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        this.serialiseMinimalAppData(writer);
        writer.name("id").value(this.packageName);
        writer.name("buildUUID").value(this.config.getBuildUUID());
        writer.name("duration").value(AppData.getDuration());
        writer.name("durationInForeground").value(this.sessionTracker.getDurationInForeground(System.currentTimeMillis()));
        writer.name("inForeground").value(this.sessionTracker.isInForeground());
        writer.name("name").value(this.appName);
        writer.name("packageName").value(this.packageName);
        writer.name("versionName").value(this.versionName);
        writer.name("activeScreen").value(this.getActiveScreenClass());
        writer.name("memoryUsage").value(AppData.getMemoryUsage());
        writer.name("lowMemory").value(AppData.isLowMemory(this.appContext));
        writer.endObject();
    }

    @Nullable
    private static String getAppName(@NonNull Context appContext) {
        try {
            PackageManager packageManager = appContext.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(appContext.getPackageName(), 0);
            return (String)packageManager.getApplicationLabel(appInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn("Could not get app name");
            return null;
        }
    }

    @Nullable
    String getActiveScreenClass() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            ActivityManager.RunningTaskInfo runningTask = (ActivityManager.RunningTaskInfo)tasks.get(0);
            return runningTask.topActivity.getClassName();
        }
        catch (Exception e) {
            Logger.warn("Could not get active screen information, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    @NonNull
    private static Long getMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Nullable
    private static Boolean isLowMemory(@NonNull Context appContext) {
        try {
            ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memInfo);
            return memInfo.lowMemory;
        }
        catch (Exception e) {
            Logger.warn("Could not check lowMemory status");
            return null;
        }
    }

    private static long getDuration() {
        return SystemClock.elapsedRealtime() - startTime;
    }

    @NonNull
    private static String getPackageName(@NonNull Context appContext) {
        return appContext.getPackageName();
    }
}

