/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import java.util.List;

final class BlockedThreadDetector {
    static final int MIN_CHECK_INTERVAL_MS = 1000;
    final Looper looper;
    final long checkIntervalMs;
    final long blockedThresholdMs;
    final Handler uiHandler;
    final Handler watchdogHandler;
    private final HandlerThread watchdogHandlerThread;
    final Delegate delegate;
    final ActivityManager activityManager;
    volatile long lastUpdateMs;
    volatile boolean isAlreadyBlocked = false;
    final Runnable livenessCheck = new Runnable(){

        @Override
        public void run() {
            BlockedThreadDetector.this.updateLivenessTimestamp();
            BlockedThreadDetector.this.uiHandler.postDelayed((Runnable)this, BlockedThreadDetector.this.checkIntervalMs);
        }
    };
    final Runnable watchdogCheck = new Runnable(){

        @Override
        public void run() {
            BlockedThreadDetector.this.checkIfThreadBlocked();
            BlockedThreadDetector.this.watchdogHandler.postDelayed((Runnable)this, BlockedThreadDetector.this.calculateNextCheckIn());
        }
    };

    BlockedThreadDetector(long blockedThresholdMs, Looper looper, ActivityManager activityManager, Delegate delegate) {
        this(blockedThresholdMs, 1000L, looper, activityManager, delegate);
    }

    BlockedThreadDetector(long blockedThresholdMs, long checkIntervalMs, Looper looper, ActivityManager activityManager, Delegate delegate) {
        if (blockedThresholdMs <= 0L || checkIntervalMs <= 0L || looper == null || delegate == null) {
            throw new IllegalArgumentException();
        }
        this.blockedThresholdMs = blockedThresholdMs;
        this.checkIntervalMs = checkIntervalMs;
        this.looper = looper;
        this.delegate = delegate;
        this.uiHandler = new Handler(looper);
        this.activityManager = activityManager;
        this.watchdogHandlerThread = new HandlerThread("bugsnag-anr-watchdog");
        this.watchdogHandlerThread.start();
        this.watchdogHandler = new Handler(this.watchdogHandlerThread.getLooper());
    }

    void start() {
        this.updateLivenessTimestamp();
        this.uiHandler.post(this.livenessCheck);
        this.watchdogHandler.postDelayed(this.watchdogCheck, this.calculateNextCheckIn());
    }

    void updateLivenessTimestamp() {
        this.lastUpdateMs = SystemClock.uptimeMillis();
    }

    long calculateNextCheckIn() {
        long currentUptimeMs = SystemClock.uptimeMillis();
        return Math.max(this.lastUpdateMs + this.blockedThresholdMs - currentUptimeMs, 0L);
    }

    void checkIfThreadBlocked() {
        long delta = SystemClock.uptimeMillis() - this.lastUpdateMs;
        boolean inForeground = this.isInForeground();
        if (inForeground && delta > this.blockedThresholdMs) {
            if (!this.isAlreadyBlocked) {
                this.delegate.onThreadBlocked(this.looper.getThread());
            }
            this.isAlreadyBlocked = true;
        } else {
            this.isAlreadyBlocked = false;
        }
    }

    private boolean isInForeground() {
        ActivityManager.RunningAppProcessInfo info = this.getProcessInfo();
        if (info != null) {
            return info.importance <= 200;
        }
        return true;
    }

    private ActivityManager.RunningAppProcessInfo getProcessInfo() {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.RunningAppProcessInfo info = new ActivityManager.RunningAppProcessInfo();
            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)info);
            return info;
        }
        return this.getProcessInfoPreApi16();
    }

    @Nullable
    private ActivityManager.RunningAppProcessInfo getProcessInfoPreApi16() {
        List appProcesses;
        try {
            appProcesses = this.activityManager.getRunningAppProcesses();
        }
        catch (SecurityException exc) {
            return null;
        }
        if (appProcesses != null) {
            int pid = Process.myPid();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (pid != appProcess.pid) continue;
                return appProcess;
            }
        }
        return null;
    }

    static interface Delegate {
        public void onThreadBlocked(Thread var1);
    }
}

