/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.util.JsonReader;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.CachedThread;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.Error;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class ErrorReader {
    ErrorReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Error readError(@NonNull Configuration config, @NonNull File errorFile) throws IOException {
        JsonReader reader = null;
        try {
            User user = null;
            Exceptions exceptions = null;
            Severity severity = Severity.ERROR;
            Session session = null;
            String context = null;
            String groupingHash = null;
            Map<String, Object> appData = null;
            Map<String, Object> deviceData = null;
            MetaData metaData = null;
            ThreadState threadState = null;
            Breadcrumbs crumbs = null;
            ArrayList<String> severityReasonValues = null;
            boolean unhandled = false;
            reader = new JsonReader((Reader)new FileReader(errorFile));
            reader.beginObject();
            block37: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "app": {
                        appData = ErrorReader.jsonObjectToMap(reader);
                        continue block37;
                    }
                    case "breadcrumbs": {
                        crumbs = ErrorReader.readBreadcrumbs(config, reader);
                        continue block37;
                    }
                    case "context": {
                        context = reader.nextString();
                        continue block37;
                    }
                    case "device": {
                        deviceData = ErrorReader.jsonObjectToMap(reader);
                        continue block37;
                    }
                    case "exceptions": {
                        exceptions = ErrorReader.readExceptions(config, reader);
                        continue block37;
                    }
                    case "groupingHash": {
                        groupingHash = reader.nextString();
                        continue block37;
                    }
                    case "metaData": {
                        metaData = new MetaData(ErrorReader.jsonObjectToMap(reader));
                        continue block37;
                    }
                    case "session": {
                        session = ErrorReader.readSession(reader);
                        continue block37;
                    }
                    case "severity": {
                        severity = Severity.fromString(reader.nextString());
                        continue block37;
                    }
                    case "severityReason": {
                        severityReasonValues = ErrorReader.readSeverityReason(reader);
                        continue block37;
                    }
                    case "threads": {
                        threadState = ErrorReader.readThreadState(config, reader);
                        continue block37;
                    }
                    case "unhandled": {
                        unhandled = reader.nextBoolean();
                        continue block37;
                    }
                    case "user": {
                        user = ErrorReader.readUser(reader);
                        continue block37;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (severityReasonValues == null || exceptions == null) {
                throw new IOException("File did not contain a valid error");
            }
            String severityReasonAttribute = severityReasonValues.size() > 1 ? severityReasonValues.get(1) : null;
            HandledState handledState = new HandledState(severityReasonValues.get(0), severity, unhandled, severityReasonAttribute);
            Error error = new Error(config, exceptions.getException(), handledState, severity, session, threadState);
            error.getExceptions().setExceptionType(exceptions.getExceptionType());
            error.setUser(user);
            error.setContext(context);
            error.setGroupingHash(groupingHash);
            error.setAppData(appData);
            error.setMetaData(metaData);
            error.setDeviceData(deviceData);
            error.setBreadcrumbs(crumbs);
            Error error2 = error;
            return error2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Breadcrumbs readBreadcrumbs(Configuration config, JsonReader reader) throws IOException {
        Breadcrumbs crumbs = new Breadcrumbs(config);
        reader.beginArray();
        while (reader.hasNext()) {
            Breadcrumb breadcrumb = ErrorReader.readBreadcrumb(reader);
            if (breadcrumb == null) continue;
            crumbs.add(breadcrumb);
        }
        reader.endArray();
        return crumbs;
    }

    private static Breadcrumb readBreadcrumb(JsonReader reader) throws IOException {
        String name = null;
        String type = null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Date captureDate = null;
        reader.beginObject();
        block14: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "name": {
                    name = reader.nextString();
                    continue block14;
                }
                case "timestamp": {
                    try {
                        captureDate = DateUtils.fromIso8601(reader.nextString());
                        continue block14;
                    }
                    catch (Exception ex) {
                        throw new IOException("Failed to parse breadcrumb timestamp: ", ex);
                    }
                }
                case "type": {
                    type = reader.nextString().toUpperCase(Locale.US);
                    continue block14;
                }
                case "metaData": {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        metadata.put(reader.nextName(), reader.nextString());
                    }
                    reader.endObject();
                    continue block14;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (name != null && captureDate != null && type != null) {
            return new Breadcrumb(name, BreadcrumbType.valueOf(type), captureDate, metadata);
        }
        return null;
    }

    private static Exceptions readExceptions(Configuration config, JsonReader reader) throws IOException {
        BugsnagException root;
        reader.beginArray();
        BugsnagException ref = root = ErrorReader.readException(reader);
        while (reader.hasNext()) {
            BugsnagException exc = ErrorReader.readException(reader);
            ref.initCause(exc);
            ref = exc;
        }
        reader.endArray();
        Exceptions ex = new Exceptions(config, root);
        if (root != null) {
            ex.setExceptionType(root.getType());
        }
        return ex;
    }

    private static BugsnagException readException(JsonReader reader) throws IOException {
        reader.beginObject();
        String errorClass = null;
        String message = null;
        String type = "android";
        StackTraceElement[] frames = new StackTraceElement[]{};
        block12: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "errorClass": {
                    errorClass = reader.nextString();
                    continue block12;
                }
                case "message": {
                    message = reader.nextString();
                    continue block12;
                }
                case "stacktrace": {
                    frames = ErrorReader.readStackFrames(reader);
                    continue block12;
                }
                case "type": {
                    type = reader.nextString();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        BugsnagException bugsnagException = new BugsnagException(errorClass, message, frames);
        bugsnagException.setType(type);
        return bugsnagException;
    }

    private static StackTraceElement[] readStackFrames(JsonReader reader) throws IOException {
        ArrayList<StackTraceElement> frames = new ArrayList<StackTraceElement>();
        reader.beginArray();
        while (reader.hasNext()) {
            frames.add(ErrorReader.readStackFrame(reader));
        }
        reader.endArray();
        return frames.toArray(new StackTraceElement[frames.size()]);
    }

    private static StackTraceElement readStackFrame(JsonReader reader) throws IOException {
        String method = null;
        String file = null;
        int lineNumber = 0;
        reader.beginObject();
        block10: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "method": {
                    method = reader.nextString();
                    continue block10;
                }
                case "file": {
                    file = reader.nextString();
                    continue block10;
                }
                case "lineNumber": {
                    lineNumber = reader.nextInt();
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new StackTraceElement("", method, file, lineNumber);
    }

    private static ArrayList<String> readSeverityReason(JsonReader reader) throws IOException {
        reader.beginObject();
        String type = null;
        String attributeValue = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("type")) {
                type = reader.nextString();
                continue;
            }
            if (name.equals("attributes")) {
                reader.beginObject();
                reader.nextName();
                attributeValue = reader.nextString();
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        ArrayList<String> values = new ArrayList<String>();
        if (type == null) {
            throw new IOException("Severity Reason type is required");
        }
        values.add(type);
        if (attributeValue != null) {
            values.add(attributeValue);
        }
        return values;
    }

    private static Session readSession(JsonReader reader) throws IOException {
        String id = null;
        Date startedAt = null;
        int unhandled = 0;
        int handled = 0;
        User user = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("id")) {
                id = reader.nextString();
                continue;
            }
            if (name.equals("startedAt")) {
                try {
                    startedAt = DateUtils.fromIso8601(reader.nextString());
                    continue;
                }
                catch (Exception ex) {
                    throw new IOException("Unable to parse session startedAt: ", ex);
                }
            }
            if (name.equals("events")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String eventName = reader.nextName();
                    if (eventName.equals("unhandled")) {
                        unhandled = reader.nextInt();
                        continue;
                    }
                    if (eventName.equals("handled")) {
                        handled = reader.nextInt();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            if (name.equals("user")) {
                user = ErrorReader.readUser(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (id != null && startedAt != null) {
            return new Session(id, startedAt, user, unhandled, handled);
        }
        throw new IOException("Session data missing required fields");
    }

    private static User readUser(JsonReader reader) throws IOException {
        User user = new User();
        reader.beginObject();
        block10: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "name": {
                    user.setName(reader.nextString());
                    continue block10;
                }
                case "id": {
                    user.setId(reader.nextString());
                    continue block10;
                }
                case "email": {
                    user.setEmail(reader.nextString());
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return user;
    }

    private static ThreadState readThreadState(Configuration config, JsonReader reader) throws IOException {
        ArrayList<CachedThread> threads = new ArrayList<CachedThread>();
        reader.beginArray();
        while (reader.hasNext()) {
            CachedThread cachedThread = ErrorReader.readThread(config, reader);
            if (cachedThread == null) continue;
            threads.add(cachedThread);
        }
        reader.endArray();
        return new ThreadState(threads.toArray(new CachedThread[threads.size()]));
    }

    private static CachedThread readThread(Configuration config, JsonReader reader) throws IOException {
        long id = 0L;
        String name = null;
        String type = null;
        boolean errorReportingThread = false;
        StackTraceElement[] frames = null;
        reader.beginObject();
        block14: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "id": {
                    id = reader.nextLong();
                    continue block14;
                }
                case "name": {
                    name = reader.nextString();
                    continue block14;
                }
                case "type": {
                    type = reader.nextString();
                    continue block14;
                }
                case "stacktrace": {
                    frames = ErrorReader.readStackFrames(reader);
                    continue block14;
                }
                case "errorReportingThread": {
                    errorReportingThread = reader.nextBoolean();
                    continue block14;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (type != null && frames != null) {
            return new CachedThread(config, id, name, type, errorReportingThread, frames);
        }
        return null;
    }

    private static Map<String, Object> jsonObjectToMap(JsonReader reader) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            Object value = ErrorReader.coerceSerializableFromJSON(reader);
            if (value == null) continue;
            data.put(key, value);
        }
        reader.endObject();
        return data;
    }

    private static List<Object> jsonArrayToList(JsonReader reader) throws IOException {
        ArrayList<Object> objects = new ArrayList<Object>();
        reader.beginArray();
        while (reader.hasNext()) {
            Object value = ErrorReader.coerceSerializableFromJSON(reader);
            if (value == null) continue;
            objects.add(value);
        }
        reader.endArray();
        return objects;
    }

    private static Object coerceSerializableFromJSON(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                return ErrorReader.jsonObjectToMap(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case NUMBER: {
                try {
                    return reader.nextInt();
                }
                catch (NumberFormatException ex) {
                    try {
                        return reader.nextLong();
                    }
                    catch (NumberFormatException ex2) {
                        return reader.nextDouble();
                    }
                }
            }
            case BEGIN_ARRAY: {
                return ErrorReader.jsonArrayToList(reader);
            }
        }
        return null;
    }
}

