/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Client;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Severity;
import com.bugsnag.android.StrictModeHandler;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;

class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String STRICT_MODE_TAB = "StrictMode";
    private static final String STRICT_MODE_KEY = "Violation";
    static final String LAUNCH_CRASH_TAB = "CrashOnLaunch";
    static final String LAUNCH_CRASH_KEY = "Duration (ms)";
    private final Thread.UncaughtExceptionHandler originalHandler;
    private final StrictModeHandler strictModeHandler = new StrictModeHandler();
    final Map<Client, Boolean> clientMap = new WeakHashMap<Client, Boolean>();

    static void enable(@NonNull Client client) {
        ExceptionHandler bugsnagHandler;
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            bugsnagHandler = (ExceptionHandler)currentHandler;
        } else {
            bugsnagHandler = new ExceptionHandler(currentHandler);
            Thread.setDefaultUncaughtExceptionHandler(bugsnagHandler);
        }
        bugsnagHandler.clientMap.put(client, true);
    }

    static void disable(@NonNull Client client) {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            ExceptionHandler bugsnagHandler = (ExceptionHandler)currentHandler;
            bugsnagHandler.clientMap.remove(client);
            if (bugsnagHandler.clientMap.isEmpty()) {
                Thread.setDefaultUncaughtExceptionHandler(bugsnagHandler.originalHandler);
            }
        }
    }

    ExceptionHandler(Thread.UncaughtExceptionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    @Override
    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
        boolean strictModeThrowable = this.strictModeHandler.isStrictModeThrowable(e);
        Date now = new Date();
        for (Client client : this.clientMap.keySet()) {
            MetaData metaData = new MetaData();
            String violationDesc = null;
            if (strictModeThrowable) {
                violationDesc = this.strictModeHandler.getViolationDescription(e.getMessage());
                metaData = new MetaData();
                metaData.addToTab(STRICT_MODE_TAB, STRICT_MODE_KEY, violationDesc);
            }
            if (this.isCrashOnLaunch(client, now)) {
                metaData.addToTab(LAUNCH_CRASH_TAB, LAUNCH_CRASH_KEY, this.getMsSinceLaunch(client, now));
            }
            String severityReason = strictModeThrowable ? "strictMode" : "unhandledException";
            client.cacheAndNotify(e, Severity.ERROR, metaData, severityReason, violationDesc);
        }
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(t, e);
        } else {
            System.err.printf("Exception in thread \"%s\" ", t.getName());
            e.printStackTrace(System.err);
        }
    }

    boolean isCrashOnLaunch(Client client, Date now) {
        long delta = this.getMsSinceLaunch(client, now);
        long thresholdMs = client.config.getLaunchCrashThresholdMs();
        return thresholdMs > 0L && delta <= thresholdMs;
    }

    private long getMsSinceLaunch(Client client, Date now) {
        long launchTimeMs = client.getLaunchTimeMs();
        return now.getTime() - launchTimeMs;
    }
}

