/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.IOException;

public class Error
implements JsonStream.Streamable {
    private static final String PAYLOAD_VERSION = "3";
    @NonNull
    final Configuration config;
    private AppData appData;
    private DeviceData deviceData;
    private AppState appState;
    private DeviceState deviceState;
    private Breadcrumbs breadcrumbs;
    private User user;
    private Throwable exception;
    private Severity severity = Severity.WARNING;
    @NonNull
    private MetaData metaData = new MetaData();
    private String groupingHash;
    private String context;
    private final HandledState handledState;

    Error(@NonNull Configuration config, @NonNull Throwable exception, HandledState handledState, Severity severity) {
        this.config = config;
        this.exception = exception;
        this.handledState = handledState;
        this.severity = severity;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        MetaData mergedMetaData = MetaData.merge(this.config.getMetaData(), this.metaData);
        writer.beginObject();
        writer.name("payloadVersion").value(PAYLOAD_VERSION);
        writer.name("context").value(this.getContext());
        writer.name("metaData").value(mergedMetaData);
        writer.name("severity").value(this.severity);
        writer.name("severityReason").value(this.handledState);
        writer.name("unhandled").value(this.handledState.isUnhandled());
        if (this.config.getProjectPackages() != null) {
            writer.name("projectPackages").beginArray();
            for (String projectPackage : this.config.getProjectPackages()) {
                writer.value(projectPackage);
            }
            writer.endArray();
        }
        writer.name("exceptions").value(new Exceptions(this.config, this.exception));
        writer.name("user").value(this.user);
        writer.name("app").value(this.appData);
        writer.name("appState").value(this.appState);
        writer.name("device").value(this.deviceData);
        writer.name("deviceState").value(this.deviceState);
        writer.name("breadcrumbs").value(this.breadcrumbs);
        writer.name("groupingHash").value(this.groupingHash);
        if (this.config.getSendThreads()) {
            writer.name("threads").value(new ThreadState(this.config));
        }
        writer.endObject();
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Nullable
    public String getContext() {
        if (!TextUtils.isEmpty((CharSequence)this.context)) {
            return this.context;
        }
        if (this.config.getContext() != null) {
            return this.config.getContext();
        }
        if (this.appState != null) {
            return this.appState.getActiveScreenClass();
        }
        return null;
    }

    public void setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
    }

    public void setSeverity(@Nullable Severity severity) {
        if (severity != null) {
            this.severity = severity;
            this.handledState.setCurrentSeverity(severity);
        }
    }

    @Nullable
    public Severity getSeverity() {
        return this.severity;
    }

    public void setUser(String id, String email, String name) {
        this.user = new User(id, email, name);
    }

    public User getUser() {
        return this.user;
    }

    public void setUserId(String id) {
        this.user = new User(this.user);
        this.user.setId(id);
    }

    public void setUserEmail(String email) {
        this.user = new User(this.user);
        this.user.setEmail(email);
    }

    public void setUserName(String name) {
        this.user = new User(this.user);
        this.user.setName(name);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(String tabName) {
        this.metaData.clearTab(tabName);
    }

    @NonNull
    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(@NonNull MetaData metaData) {
        this.metaData = metaData == null ? new MetaData() : metaData;
    }

    public String getExceptionName() {
        if (this.exception instanceof BugsnagException) {
            return ((BugsnagException)this.exception).getName();
        }
        return this.exception.getClass().getName();
    }

    public String getExceptionMessage() {
        return this.exception.getLocalizedMessage();
    }

    public Throwable getException() {
        return this.exception;
    }

    void setAppData(AppData appData) {
        this.appData = appData;
    }

    void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }

    void setAppState(AppState appState) {
        this.appState = appState;
    }

    void setDeviceState(DeviceState deviceState) {
        this.deviceState = deviceState;
    }

    void setUser(User user) {
        this.user = user;
    }

    void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    boolean shouldIgnoreClass() {
        return this.config.shouldIgnoreClass(this.getExceptionName());
    }

    static class Builder {
        private final Configuration config;
        private final Throwable exception;
        private Severity severity = Severity.WARNING;
        private MetaData metaData;
        private String strictModeValue;
        private String severityReasonType;

        Builder(@NonNull Configuration config, @NonNull Throwable exception) {
            this.config = config;
            this.exception = exception;
            this.severityReasonType = "userSpecifiedSeverity";
        }

        Builder(@NonNull Configuration config, @NonNull String name, @NonNull String message, @NonNull StackTraceElement[] frames) {
            this(config, new BugsnagException(name, message, frames));
        }

        Builder severityReasonType(String severityReasonType) {
            this.severityReasonType = severityReasonType;
            return this;
        }

        Builder strictModeValue(String value) {
            this.strictModeValue = value;
            return this;
        }

        Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        Error build() {
            HandledState handledState = HandledState.newInstance(this.severityReasonType, this.severity, this.strictModeValue);
            Error error = new Error(this.config, this.exception, handledState, this.severity);
            if (this.metaData != null) {
                error.setMetaData(this.metaData);
            }
            return error;
        }
    }
}

