/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;

class Exceptions
implements JsonStream.Streamable {
    private final Configuration config;
    private Throwable exception;

    Exceptions(Configuration config, Throwable exception) {
        this.config = config;
        this.exception = exception;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (Throwable currentEx = this.exception; currentEx != null; currentEx = currentEx.getCause()) {
            if (currentEx instanceof JsonStream.Streamable) {
                ((JsonStream.Streamable)((Object)currentEx)).toStream(writer);
                continue;
            }
            this.exceptionToStream(writer, this.getExceptionName(currentEx), currentEx.getLocalizedMessage(), currentEx.getStackTrace());
        }
        writer.endArray();
    }

    private String getExceptionName(Throwable t) {
        if (t instanceof BugsnagException) {
            return ((BugsnagException)t).getName();
        }
        return t.getClass().getName();
    }

    private void exceptionToStream(JsonStream writer, String name, String message, StackTraceElement[] frames) throws IOException {
        Stacktrace stacktrace = new Stacktrace(this.config, frames);
        writer.beginObject();
        writer.name("errorClass").value(name);
        writer.name("message").value(message);
        writer.name("type").value(this.config.defaultExceptionType);
        writer.name("stacktrace").value(stacktrace);
        writer.endObject();
    }
}

