/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Date;

class DeviceState
implements JsonStream.Streamable {
    private final Long freeMemory = DeviceState.getFreeMemory();
    private final String orientation;
    private final Float batteryLevel;
    private final Long freeDisk;
    private final Boolean charging;
    private final String locationStatus;
    private final String networkAccess;
    private final String time;

    DeviceState(@NonNull Context appContext) {
        this.orientation = DeviceState.getOrientation(appContext);
        this.batteryLevel = DeviceState.getBatteryLevel(appContext);
        this.freeDisk = DeviceState.getFreeDisk();
        this.charging = DeviceState.isCharging(appContext);
        this.locationStatus = DeviceState.getLocationStatus(appContext);
        this.networkAccess = DeviceState.getNetworkAccess(appContext);
        this.time = this.getTime();
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("freeMemory").value(this.freeMemory);
        writer.name("orientation").value(this.orientation);
        writer.name("batteryLevel").value(this.batteryLevel);
        writer.name("freeDisk").value(this.freeDisk);
        writer.name("charging").value(this.charging);
        writer.name("locationStatus").value(this.locationStatus);
        writer.name("networkAccess").value(this.networkAccess);
        writer.name("time").value(this.time);
        writer.endObject();
    }

    @NonNull
    private static Long getFreeMemory() {
        if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
            return Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        }
        return Runtime.getRuntime().freeMemory();
    }

    @Nullable
    private static String getOrientation(Context appContext) {
        String orientation = null;
        switch (appContext.getResources().getConfiguration().orientation) {
            case 2: {
                orientation = "landscape";
                break;
            }
            case 1: {
                orientation = "portrait";
                break;
            }
            default: {
                orientation = null;
            }
        }
        return orientation;
    }

    @Nullable
    private static Float getBatteryLevel(Context appContext) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = appContext.registerReceiver(null, ifilter);
            return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)batteryStatus.getIntExtra("scale", -1));
        }
        catch (Exception e) {
            Logger.warn("Could not get batteryLevel");
            return null;
        }
    }

    @Nullable
    private static Long getFreeDisk() {
        try {
            StatFs externalStat = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long externalBytesAvailable = (long)externalStat.getBlockSize() * (long)externalStat.getBlockCount();
            StatFs internalStat = new StatFs(Environment.getDataDirectory().getPath());
            long internalBytesAvailable = (long)internalStat.getBlockSize() * (long)internalStat.getBlockCount();
            return Math.min(internalBytesAvailable, externalBytesAvailable);
        }
        catch (Exception e) {
            Logger.warn("Could not get freeDisk");
            return null;
        }
    }

    @Nullable
    private static Boolean isCharging(Context appContext) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = appContext.registerReceiver(null, ifilter);
            int status = batteryStatus.getIntExtra("status", -1);
            return status == 2 || status == 5;
        }
        catch (Exception e) {
            Logger.warn("Could not get charging status");
            return null;
        }
    }

    @Nullable
    private static String getLocationStatus(Context appContext) {
        try {
            ContentResolver cr = appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed != null && providersAllowed.length() > 0) {
                return "allowed";
            }
            return "disallowed";
        }
        catch (Exception e) {
            Logger.warn("Could not get locationStatus");
            return null;
        }
    }

    @Nullable
    private static String getNetworkAccess(Context appContext) {
        try {
            ConnectivityManager cm = (ConnectivityManager)appContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null && activeNetwork.isConnectedOrConnecting()) {
                if (activeNetwork.getType() == 1) {
                    return "wifi";
                }
                if (activeNetwork.getType() == 9) {
                    return "ethernet";
                }
                return "cellular";
            }
            return "none";
        }
        catch (Exception e) {
            Logger.warn("Could not get network access information, we recommend granting the 'android.permission.ACCESS_NETWORK_STATE' permission");
            return null;
        }
    }

    @NonNull
    private String getTime() {
        return DateUtils.toISO8601(new Date());
    }
}

