/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.HttpClient;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Report;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Locale;

class ErrorStore {
    private static final String UNSENT_ERROR_PATH = "/bugsnag-errors/";
    private static final int MAX_STORED_ERRORS = 100;
    final Configuration config;
    final String path;

    ErrorStore(Configuration config, Context appContext) {
        String path;
        this.config = config;
        try {
            path = appContext.getCacheDir().getAbsolutePath() + UNSENT_ERROR_PATH;
            File outFile = new File(path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                Logger.warn("Could not prepare error storage directory");
                path = null;
            }
        }
        catch (Exception e) {
            Logger.warn("Could not prepare error storage directory", e);
            path = null;
        }
        this.path = path;
    }

    void flush() {
        if (this.path == null) {
            return;
        }
        Async.run(new Runnable(){

            @Override
            public void run() {
                File exceptionDir = new File(ErrorStore.this.path);
                if (!exceptionDir.exists() || !exceptionDir.isDirectory()) {
                    return;
                }
                File[] errorFiles = exceptionDir.listFiles();
                if (errorFiles != null && errorFiles.length > 0) {
                    Logger.info(String.format(Locale.US, "Sending %d saved error(s) to Bugsnag", errorFiles.length));
                    for (File errorFile : errorFiles) {
                        try {
                            Report report = new Report(ErrorStore.this.config.getApiKey(), errorFile);
                            HttpClient.post(ErrorStore.this.config.getEndpoint(), report);
                            Logger.info("Deleting sent error file " + errorFile.getName());
                            if (errorFile.delete()) continue;
                            errorFile.deleteOnExit();
                        }
                        catch (HttpClient.NetworkException e) {
                            Logger.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
                        }
                        catch (Exception e) {
                            Logger.warn("Problem sending unsent error from disk", e);
                            if (errorFile.delete()) continue;
                            errorFile.deleteOnExit();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Error error) {
        Object[] files;
        if (this.path == null) {
            return;
        }
        File exceptionDir = new File(this.path);
        if (exceptionDir.isDirectory() && (files = exceptionDir.listFiles()).length >= 100) {
            Arrays.sort(files);
            Logger.warn(String.format("Discarding oldest error as stored error limit reached (%s)", ((File)files[0]).getPath()));
            if (!((File)files[0]).delete()) {
                ((File)files[0]).deleteOnExit();
            }
        }
        String filename = String.format(Locale.US, "%s%d.json", this.path, System.currentTimeMillis());
        FileWriter out = null;
        try {
            out = new FileWriter(filename);
            JsonStream stream = new JsonStream(out);
            stream.value(error);
            stream.close();
            Logger.info(String.format("Saved unsent error to disk (%s) ", filename));
        }
        catch (Exception e) {
            try {
                Logger.warn(String.format("Couldn't save unsent error to disk (%s) ", filename), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
    }
}

