/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.List;

class AppState
implements JsonStream.Streamable {
    private static final Long startTime = SystemClock.elapsedRealtime();
    private final Long duration = AppState.getDuration();
    private final Boolean inForeground;
    private final String activeScreen;
    private final Long memoryUsage;
    private final Boolean lowMemory;

    static void init() {
    }

    AppState(@NonNull Context appContext) {
        this.inForeground = AppState.isInForeground(appContext);
        this.activeScreen = AppState.getActiveScreen(appContext);
        this.memoryUsage = AppState.getMemoryUsage();
        this.lowMemory = AppState.isLowMemory(appContext);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("duration").value(this.duration);
        writer.name("inForeground").value(this.inForeground);
        writer.name("activeScreen").value(this.activeScreen);
        writer.name("memoryUsage").value(this.memoryUsage);
        writer.name("lowMemory").value(this.lowMemory);
        writer.endObject();
    }

    @Nullable
    public static String getActiveScreenClass(@Nullable String activeScreen) {
        if (activeScreen != null) {
            return activeScreen.substring(activeScreen.lastIndexOf(46) + 1);
        }
        return null;
    }

    @NonNull
    private static Long getMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Nullable
    private static Boolean isLowMemory(Context appContext) {
        try {
            ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memInfo);
            return memInfo.lowMemory;
        }
        catch (Exception e) {
            Logger.warn("Could not check lowMemory status");
            return null;
        }
    }

    @Nullable
    private static String getActiveScreen(Context appContext) {
        try {
            ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            ActivityManager.RunningTaskInfo runningTask = (ActivityManager.RunningTaskInfo)tasks.get(0);
            return runningTask.topActivity.getClassName();
        }
        catch (Exception e) {
            Logger.warn("Could not get active screen information, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    @Nullable
    private static Boolean isInForeground(Context appContext) {
        try {
            ActivityManager activityManager = (ActivityManager)appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            if (tasks.isEmpty()) {
                return false;
            }
            ActivityManager.RunningTaskInfo runningTask = (ActivityManager.RunningTaskInfo)tasks.get(0);
            return runningTask.topActivity.getPackageName().equalsIgnoreCase(appContext.getPackageName());
        }
        catch (Exception e) {
            Logger.warn("Could not check if app is in the foreground, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    @NonNull
    private static Long getDuration() {
        return SystemClock.elapsedRealtime() - startTime;
    }
}

