/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.IOException;

public class Error
implements JsonStream.Streamable {
    private static final String PAYLOAD_VERSION = "3";
    private final Configuration config;
    private AppData appData;
    private DeviceData deviceData;
    private AppState appState;
    private DeviceState deviceState;
    private Breadcrumbs breadcrumbs;
    private User user;
    private Throwable exception;
    private Severity severity = Severity.WARNING;
    private MetaData metaData = new MetaData();
    private String groupingHash;
    private String context;

    Error(Configuration config, Throwable exception) {
        this.config = config;
        this.exception = exception;
    }

    Error(Configuration config, String name, String message, StackTraceElement[] frames) {
        this.config = config;
        this.exception = new BugsnagException(name, message, frames);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        MetaData mergedMetaData = MetaData.merge(this.config.getMetaData(), this.metaData);
        mergedMetaData.setFilters(this.config.getFilters());
        writer.beginObject();
        writer.name("payloadVersion").value(PAYLOAD_VERSION);
        writer.name("context").value(this.getContext());
        writer.name("severity").value(this.severity);
        writer.name("metaData").value(mergedMetaData);
        if (this.config.getProjectPackages() != null) {
            writer.name("projectPackages").beginArray();
            for (String projectPackage : this.config.getProjectPackages()) {
                writer.value(projectPackage);
            }
            writer.endArray();
        }
        writer.name("exceptions").value(new Exceptions(this.config, this.exception));
        writer.name("user").value(this.user);
        writer.name("app").value(this.appData);
        writer.name("appState").value(this.appState);
        writer.name("device").value(this.deviceData);
        writer.name("deviceState").value(this.deviceState);
        writer.name("breadcrumbs").value(this.breadcrumbs);
        writer.name("groupingHash").value(this.groupingHash);
        if (this.config.getSendThreads()) {
            writer.name("threads").value(new ThreadState(this.config));
        }
        writer.endObject();
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Nullable
    public String getContext() {
        if (this.context != null && !TextUtils.isEmpty((CharSequence)this.context)) {
            return this.context;
        }
        if (this.config.getContext() != null) {
            return this.config.getContext();
        }
        if (this.appState != null) {
            return AppState.getActiveScreenClass(this.context);
        }
        return null;
    }

    public void setGroupingHash(String groupingHash) {
        this.groupingHash = groupingHash;
    }

    public void setSeverity(Severity severity) {
        if (severity != null) {
            this.severity = severity;
        }
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setUser(String id, String email, String name) {
        this.user = new User(id, email, name);
    }

    public User getUser() {
        return this.user;
    }

    public void setUserId(String id) {
        this.user = new User(this.user);
        this.user.setId(id);
    }

    public void setUserEmail(String email) {
        this.user = new User(this.user);
        this.user.setEmail(email);
    }

    public void setUserName(String name) {
        this.user = new User(this.user);
        this.user.setName(name);
    }

    public void addToTab(String tabName, String key, Object value) {
        this.metaData.addToTab(tabName, key, value);
    }

    public void clearTab(String tabName) {
        this.metaData.clearTab(tabName);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String getExceptionName() {
        if (this.exception instanceof BugsnagException) {
            return ((BugsnagException)this.exception).getName();
        }
        return this.exception.getClass().getName();
    }

    public String getExceptionMessage() {
        return this.exception.getLocalizedMessage();
    }

    public Throwable getException() {
        return this.exception;
    }

    void setAppData(AppData appData) {
        this.appData = appData;
    }

    void setDeviceData(DeviceData deviceData) {
        this.deviceData = deviceData;
    }

    void setAppState(AppState appState) {
        this.appState = appState;
    }

    void setDeviceState(DeviceState deviceState) {
        this.deviceState = deviceState;
    }

    void setUser(User user) {
        this.user = user;
    }

    void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        this.breadcrumbs = breadcrumbs;
    }

    boolean shouldIgnoreClass() {
        return this.config.shouldIgnoreClass(this.getExceptionName());
    }
}

