/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Async;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorStore;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.HttpClient;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Notification;
import com.bugsnag.android.Severity;
import com.bugsnag.android.User;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class Client {
    private static final boolean BLOCKING = true;
    private static final String SHARED_PREF_KEY = "com.bugsnag.android";
    private static final String USER_ID_KEY = "user.id";
    private static final String USER_NAME_KEY = "user.name";
    private static final String USER_EMAIL_KEY = "user.email";
    private final Configuration config;
    private final Context appContext;
    private final AppData appData;
    private final DeviceData deviceData;
    private final Breadcrumbs breadcrumbs;
    private final User user = new User();
    private final ErrorStore errorStore;

    public Client(@NonNull Context androidContext) {
        this(androidContext, null, true);
    }

    public Client(@NonNull Context androidContext, @Nullable String apiKey) {
        this(androidContext, apiKey, true);
    }

    public Client(@NonNull Context androidContext, @Nullable String apiKey, boolean enableExceptionHandler) {
        this(androidContext, Client.createNewConfiguration(androidContext, apiKey, enableExceptionHandler));
    }

    public Client(@NonNull Context androidContext, @NonNull Configuration configuration) {
        this.appContext = androidContext.getApplicationContext();
        this.config = configuration;
        String buildUUID = null;
        try {
            ApplicationInfo ai = this.appContext.getPackageManager().getApplicationInfo(this.appContext.getPackageName(), 128);
            buildUUID = ai.metaData.getString("com.bugsnag.android.BUILD_UUID");
        }
        catch (Exception ai) {
            // empty catch block
        }
        if (buildUUID != null) {
            this.config.setBuildUUID(buildUUID);
        }
        this.appData = new AppData(this.appContext, this.config);
        this.deviceData = new DeviceData(this.appContext);
        AppState.init();
        this.breadcrumbs = new Breadcrumbs();
        this.setProjectPackages(this.appContext.getPackageName());
        if (this.config.getPersistUserBetweenSessions()) {
            SharedPreferences sharedPref = this.appContext.getSharedPreferences(SHARED_PREF_KEY, 0);
            this.user.setId(sharedPref.getString(USER_ID_KEY, this.deviceData.getUserId()));
            this.user.setName(sharedPref.getString(USER_NAME_KEY, null));
            this.user.setEmail(sharedPref.getString(USER_EMAIL_KEY, null));
        } else {
            this.user.setId(this.deviceData.getUserId());
        }
        this.errorStore = new ErrorStore(this.config, this.appContext);
        if (this.config.getEnableExceptionHandler()) {
            this.enableExceptionHandler();
        }
        this.errorStore.flush();
    }

    private static Configuration createNewConfiguration(@NonNull Context androidContext, String apiKey, boolean enableExceptionHandler) {
        Context appContext = androidContext.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            try {
                ApplicationInfo ai = appContext.getPackageManager().getApplicationInfo(appContext.getPackageName(), 128);
                apiKey = ai.metaData.getString("com.bugsnag.android.API_KEY");
            }
            catch (Exception ai) {
                // empty catch block
            }
        }
        if (apiKey == null) {
            throw new NullPointerException("You must provide a Bugsnag API key");
        }
        Configuration newConfig = new Configuration(apiKey);
        newConfig.setEnableExceptionHandler(enableExceptionHandler);
        return newConfig;
    }

    public void setAppVersion(String appVersion) {
        this.config.setAppVersion(appVersion);
    }

    public String getContext() {
        return this.config.getContext();
    }

    public void setContext(String context) {
        this.config.setContext(context);
    }

    public void setEndpoint(String endpoint) {
        this.config.setEndpoint(endpoint);
    }

    public void setBuildUUID(String buildUUID) {
        this.config.setBuildUUID(buildUUID);
    }

    public void setFilters(String ... filters) {
        this.config.setFilters(filters);
    }

    public void setIgnoreClasses(String ... ignoreClasses) {
        this.config.setIgnoreClasses(ignoreClasses);
    }

    public void setNotifyReleaseStages(String ... notifyReleaseStages) {
        this.config.setNotifyReleaseStages(notifyReleaseStages);
    }

    public void setProjectPackages(String ... projectPackages) {
        this.config.setProjectPackages(projectPackages);
    }

    public void setReleaseStage(String releaseStage) {
        this.config.setReleaseStage(releaseStage);
    }

    public void setSendThreads(boolean sendThreads) {
        this.config.setSendThreads(sendThreads);
    }

    public void setUser(String id, String email, String name) {
        this.setUserId(id);
        this.setUserEmail(email);
        this.setUserName(name);
    }

    public void clearUser() {
        this.user.setId(this.deviceData.getUserId());
        this.user.setEmail(null);
        this.user.setName(null);
        SharedPreferences sharedPref = this.appContext.getSharedPreferences(SHARED_PREF_KEY, 0);
        sharedPref.edit().remove(USER_ID_KEY).remove(USER_EMAIL_KEY).remove(USER_NAME_KEY).commit();
    }

    public void setUserId(String id) {
        this.user.setId(id);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_ID_KEY, id);
        }
    }

    public void setUserEmail(String email) {
        this.user.setEmail(email);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_EMAIL_KEY, email);
        }
    }

    public void setUserName(String name) {
        this.user.setName(name);
        if (this.config.getPersistUserBetweenSessions()) {
            this.storeInSharedPrefs(USER_NAME_KEY, name);
        }
    }

    public void beforeNotify(BeforeNotify beforeNotify) {
        this.config.beforeNotify(beforeNotify);
    }

    public void notify(Throwable exception) {
        Error error = new Error(this.config, exception);
        this.notify(error, false);
    }

    public void notifyBlocking(Throwable exception) {
        Error error = new Error(this.config, exception);
        this.notify(error, true);
    }

    public void notify(Throwable exception, Severity severity) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        this.notify(error, false);
    }

    public void notifyBlocking(Throwable exception, Severity severity) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        this.notify(error, true);
    }

    public void notify(Throwable exception, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setMetaData(metaData);
        this.notify(error, false);
    }

    public void notifyBlocking(Throwable exception, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setMetaData(metaData);
        this.notify(error, true);
    }

    public void notify(Throwable exception, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        this.notify(error, false);
    }

    public void notifyBlocking(Throwable exception, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, exception);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        this.notify(error, true);
    }

    public void notify(String name, String message, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, name, message, stacktrace);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        this.notify(error, false);
    }

    public void notifyBlocking(String name, String message, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, name, message, stacktrace);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        this.notify(error, true);
    }

    public void notify(String name, String message, String context, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, name, message, stacktrace);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        error.setContext(context);
        this.notify(error, false);
    }

    public void notifyBlocking(String name, String message, String context, StackTraceElement[] stacktrace, Severity severity, MetaData metaData) {
        Error error = new Error(this.config, name, message, stacktrace);
        error.setSeverity(severity);
        error.setMetaData(metaData);
        error.setContext(context);
        this.notify(error, true);
    }

    public void addToTab(String tab, String key, Object value) {
        this.config.getMetaData().addToTab(tab, key, value);
    }

    public void clearTab(String tabName) {
        this.config.getMetaData().clearTab(tabName);
    }

    public MetaData getMetaData() {
        return this.config.getMetaData();
    }

    public void setMetaData(MetaData metaData) {
        this.config.setMetaData(metaData);
    }

    public void leaveBreadcrumb(String breadcrumb) {
        this.breadcrumbs.add(breadcrumb);
    }

    public void leaveBreadcrumb(String name, BreadcrumbType type, Map<String, String> metadata) {
        this.breadcrumbs.add(name, type, metadata);
    }

    public void setMaxBreadcrumbs(int numBreadcrumbs) {
        this.breadcrumbs.setSize(numBreadcrumbs);
    }

    public void clearBreadcrumbs() {
        this.breadcrumbs.clear();
    }

    public void enableExceptionHandler() {
        ExceptionHandler.enable(this);
    }

    public void disableExceptionHandler() {
        ExceptionHandler.disable(this);
    }

    private void notify(final Error error, boolean blocking) {
        if (error.shouldIgnoreClass()) {
            return;
        }
        if (!this.config.shouldNotifyForReleaseStage(this.appData.getReleaseStage())) {
            return;
        }
        error.setAppData(this.appData);
        error.setDeviceData(this.deviceData);
        error.setAppState(new AppState(this.appContext));
        error.setDeviceState(new DeviceState(this.appContext));
        error.setBreadcrumbs(this.breadcrumbs);
        error.setUser(this.user);
        if (!this.runBeforeNotifyTasks(error)) {
            Logger.info("Skipping notification - beforeNotify task returned false");
            return;
        }
        final Notification notification = new Notification(this.config);
        notification.addError(error);
        if (blocking) {
            this.deliver(notification, error);
        } else {
            Async.run(new Runnable(){

                @Override
                public void run() {
                    Client.this.deliver(notification, error);
                }
            });
        }
        this.breadcrumbs.add(error.getExceptionName(), BreadcrumbType.ERROR, Collections.singletonMap("message", error.getExceptionMessage()));
    }

    void deliver(Notification notification, Error error) {
        try {
            int errorCount = notification.deliver();
            Logger.info(String.format(Locale.US, "Sent %d new error(s) to Bugsnag", errorCount));
        }
        catch (HttpClient.NetworkException e) {
            Logger.info("Could not send error(s) to Bugsnag, saving to disk to send later");
            this.errorStore.write(error);
        }
        catch (HttpClient.BadResponseException e) {
            Logger.info("Bad response when sending data to Bugsnag");
        }
        catch (Exception e) {
            Logger.warn("Problem sending error to Bugsnag", e);
        }
    }

    private boolean runBeforeNotifyTasks(Error error) {
        for (BeforeNotify beforeNotify : this.config.getBeforeNotifyTasks()) {
            try {
                if (beforeNotify.run(error)) continue;
                return false;
            }
            catch (Throwable ex) {
                Logger.warn("BeforeNotify threw an Exception", ex);
            }
        }
        return true;
    }

    private boolean storeInSharedPrefs(String key, String value) {
        SharedPreferences sharedPref = this.appContext.getSharedPreferences(SHARED_PREF_KEY, 0);
        return sharedPref.edit().putString(key, value).commit();
    }
}

