/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import com.bugsnag.android.JsonStream;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

class DeviceData
implements JsonStream.Streamable {
    private final Float screenDensity;
    private final Integer dpi;
    private final String screenResolution;
    private final Long totalMemory;
    private final Boolean rooted;
    private final String locale;
    private final String id;
    private static final String[] ROOT_INDICATORS = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu"};

    DeviceData(@NonNull Context appContext) {
        this.screenDensity = DeviceData.getScreenDensity(appContext);
        this.dpi = DeviceData.getScreenDensityDpi(appContext);
        this.screenResolution = DeviceData.getScreenResolution(appContext);
        this.totalMemory = DeviceData.getTotalMemory();
        this.rooted = DeviceData.isRooted();
        this.locale = DeviceData.getLocale();
        this.id = DeviceData.getAndroidId(appContext);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("osName").value("android");
        writer.name("manufacturer").value(Build.MANUFACTURER);
        writer.name("brand").value(Build.BRAND);
        writer.name("model").value(Build.MODEL);
        writer.name("id").value(this.id);
        writer.name("apiLevel").value(Build.VERSION.SDK_INT);
        writer.name("osVersion").value(Build.VERSION.RELEASE);
        writer.name("osBuild").value(Build.DISPLAY);
        writer.name("locale").value(this.locale);
        writer.name("totalMemory").value(this.totalMemory);
        if (this.rooted != null) {
            writer.name("jailbroken").value(this.rooted);
        }
        if (this.screenDensity != null) {
            writer.name("screenDensity").value(this.screenDensity);
        }
        if (this.dpi != null) {
            writer.name("dpi").value(this.dpi);
        }
        if (this.screenResolution != null) {
            writer.name("screenResolution").value(this.screenResolution);
        }
        writer.endObject();
    }

    public String getUserId() {
        return this.id;
    }

    @Nullable
    private static Float getScreenDensity(Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        return Float.valueOf(resources.getDisplayMetrics().density);
    }

    @Nullable
    private static Integer getScreenDensityDpi(Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        return resources.getDisplayMetrics().densityDpi;
    }

    @Nullable
    private static String getScreenResolution(Context appContext) {
        Resources resources = appContext.getResources();
        if (resources == null) {
            return null;
        }
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return String.format(Locale.US, "%dx%d", Math.max(metrics.widthPixels, metrics.heightPixels), Math.min(metrics.widthPixels, metrics.heightPixels));
    }

    @NonNull
    private static Long getTotalMemory() {
        if (Runtime.getRuntime().maxMemory() != Long.MAX_VALUE) {
            return Runtime.getRuntime().maxMemory();
        }
        return Runtime.getRuntime().totalMemory();
    }

    @Nullable
    private static Boolean isRooted() {
        if (Build.TAGS != null && Build.TAGS.contains("test-keys")) {
            return true;
        }
        try {
            for (String candidate : ROOT_INDICATORS) {
                if (!new File(candidate).exists()) continue;
                return true;
            }
        }
        catch (Exception ignore) {
            return null;
        }
        return false;
    }

    @NonNull
    private static String getLocale() {
        return Locale.getDefault().toString();
    }

    @NonNull
    private static String getAndroidId(Context appContext) {
        ContentResolver cr = appContext.getContentResolver();
        return Settings.Secure.getString((ContentResolver)cr, (String)"android_id");
    }
}

