/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.MetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

class Configuration {
    static final String DEFAULT_ENDPOINT = "https://notify.bugsnag.com";
    final String apiKey;
    String buildUUID;
    String appVersion;
    String context;
    String endpoint = "https://notify.bugsnag.com";
    String[] filters = new String[]{"password"};
    String[] ignoreClasses;
    String[] notifyReleaseStages = null;
    String[] projectPackages;
    String releaseStage;
    boolean sendThreads = true;
    MetaData metaData = new MetaData();
    final Collection<BeforeNotify> beforeNotifyTasks = new LinkedList<BeforeNotify>();

    Configuration(String apiKey) {
        this.apiKey = apiKey;
    }

    String getNotifyEndpoint() {
        return this.endpoint;
    }

    boolean shouldNotifyForReleaseStage(String releaseStage) {
        if (this.notifyReleaseStages == null) {
            return true;
        }
        List<String> stages = Arrays.asList(this.notifyReleaseStages);
        return stages.contains(releaseStage);
    }

    boolean shouldIgnoreClass(String className) {
        if (this.ignoreClasses == null) {
            return false;
        }
        List<String> classes = Arrays.asList(this.ignoreClasses);
        return classes.contains(className);
    }

    void beforeNotify(BeforeNotify beforeNotify) {
        this.beforeNotifyTasks.add(beforeNotify);
    }

    boolean inProject(String className) {
        if (this.projectPackages != null) {
            for (String packageName : this.projectPackages) {
                if (packageName == null || !className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }
}

