/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.support.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Stacktrace;
import java.io.IOException;

class Exceptions
implements JsonStream.Streamable {
    private final Configuration config;
    private Throwable exception;
    private String name;
    private String message;
    private StackTraceElement[] frames;

    Exceptions(Configuration config, Throwable exception) {
        this.config = config;
        this.exception = exception;
    }

    Exceptions(Configuration config, String name, String message, StackTraceElement[] frames) {
        this.config = config;
        this.name = name;
        this.message = message;
        this.frames = frames;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        if (this.exception != null) {
            for (Throwable currentEx = this.exception; currentEx != null; currentEx = currentEx.getCause()) {
                this.exceptionToStream(writer, currentEx.getClass().getName(), currentEx.getLocalizedMessage(), currentEx.getStackTrace());
            }
        } else {
            this.exceptionToStream(writer, this.name, this.message, this.frames);
        }
        writer.endArray();
    }

    private void exceptionToStream(JsonStream writer, String name, String message, StackTraceElement[] frames) throws IOException {
        Stacktrace stacktrace = new Stacktrace(this.config, frames);
        writer.beginObject();
        writer.name("errorClass").value(name);
        writer.name("message").value(message);
        writer.name("stacktrace").value(stacktrace);
        writer.endObject();
    }
}

