/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.Context;
import android.os.SystemClock;
import com.bugsnag.android.AppData;
import com.bugsnag.android.JsonStream;
import java.io.IOException;
import java.util.List;

final class AppState
implements JsonStream.Streamable {
    private static Long startTime = SystemClock.elapsedRealtime();
    private Context appContext;
    private Long duration;
    private Boolean inForeground;
    private String activeScreen;
    private Long memoryUsage;
    private Boolean lowMemory;

    static void init() {
    }

    /*
     * WARNING - void declaration
     */
    AppState(Context appContext) {
        void var1_1;
        this.appContext = var1_1;
        this.duration = SystemClock.elapsedRealtime() - startTime;
        this.inForeground = this.isInForeground();
        this.activeScreen = this.getActiveScreen();
        this.memoryUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.lowMemory = this.isLowMemory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("duration").value(this.duration);
        writer.name("inForeground").value(this.inForeground);
        writer.name("activeScreen").value(this.activeScreen);
        writer.name("memoryUsage").value(this.memoryUsage);
        writer.name("lowMemory").value(this.lowMemory);
        var1_1.endObject();
    }

    public final String getActiveScreenClass() {
        if (this.activeScreen != null) {
            return this.activeScreen.substring(this.activeScreen.lastIndexOf(46) + 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean isLowMemory() {
        try {
            void var2_2;
            void var1_1;
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            var1_1.getMemoryInfo(memInfo);
            return var2_2.lowMemory;
        }
        catch (Exception exception) {
            AppData.warn("Could not check lowMemory status");
            return null;
        }
    }

    private String getActiveScreen() {
        try {
            Object object = (ActivityManager)this.appContext.getSystemService("activity");
            object = object.getRunningTasks(1);
            object = (ActivityManager.RunningTaskInfo)object.get(0);
            return object.topActivity.getClassName();
        }
        catch (Exception exception) {
            AppData.warn("Could not get active screen information, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }

    private Boolean isInForeground() {
        try {
            ActivityManager activityManager = (ActivityManager)this.appContext.getSystemService("activity");
            List tasks = activityManager.getRunningTasks(1);
            if (tasks.isEmpty()) {
                return false;
            }
            activityManager = (ActivityManager.RunningTaskInfo)activityManager.get(0);
            return activityManager.topActivity.getPackageName().equalsIgnoreCase(this.appContext.getPackageName());
        }
        catch (Exception exception) {
            AppData.warn("Could not check if app is in the foreground, we recommend granting the 'android.permission.GET_TASKS' permission");
            return null;
        }
    }
}

