/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.AppData;
import com.bugsnag.android.AppState;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DeviceData;
import com.bugsnag.android.DeviceState;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.IOException;
import java.util.Arrays;

public class Error
implements JsonStream.Streamable {
    private Configuration config;
    private AppData appData;
    private DeviceData deviceData;
    private AppState appState;
    private DeviceState deviceState;
    private Breadcrumbs breadcrumbs;
    private User user;
    private Throwable exception;
    private Severity severity = Severity.WARNING;
    private MetaData metaData = new MetaData();
    private String groupingHash;
    private String context;
    private String name;
    private String message;
    private StackTraceElement[] frames;

    /*
     * WARNING - void declaration
     */
    Error(Configuration config, Throwable exception) {
        void var2_2;
        void var1_1;
        this.config = var1_1;
        this.exception = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    Error(Configuration config, String name, String message, StackTraceElement[] frames) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.config = var1_1;
        this.name = var2_2;
        this.message = var3_3;
        this.frames = frames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void toStream(JsonStream writer) throws IOException {
        void var1_1;
        JsonStream jsonStream;
        JsonStream.Streamable streamable;
        MetaData mergedMetaData = MetaData.merge(this.config.metaData, this.metaData);
        mergedMetaData.setFilters(this.config.filters);
        writer.beginObject();
        writer.name("payloadVersion").value("2");
        writer.name("context").value(this.getContext());
        JsonStream.Streamable streamable2 = this.severity;
        JsonStream jsonStream2 = writer.name("severity");
        streamable2.toStream(jsonStream2);
        streamable2 = mergedMetaData;
        jsonStream2 = writer.name("metaData");
        streamable2.toStream(jsonStream2);
        writer.name("projectPackages").beginArray();
        String[] arr$ = this.config.projectPackages;
        int len$ = this.config.projectPackages.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String projectPackage = arr$[i$];
            writer.value(projectPackage);
        }
        writer.endArray();
        if (this.exception != null) {
            streamable = new Exceptions(this.config, this.exception);
            jsonStream = writer.name("exceptions");
            streamable.toStream(jsonStream);
        } else {
            streamable = new Exceptions(this.config, this.name, this.message, this.frames);
            jsonStream = writer.name("exceptions");
            streamable.toStream(jsonStream);
        }
        if (this.user != null) {
            streamable = this.user;
            jsonStream = writer.name("user");
            streamable.toStream(jsonStream);
        }
        if (this.appData != null) {
            streamable = this.appData;
            jsonStream = writer.name("app");
            streamable.toStream(jsonStream);
        }
        if (this.appState != null) {
            streamable = this.appState;
            jsonStream = writer.name("appState");
            streamable.toStream(jsonStream);
        }
        if (this.deviceData != null) {
            streamable = this.deviceData;
            jsonStream = writer.name("device");
            streamable.toStream(jsonStream);
        }
        if (this.deviceState != null) {
            streamable = this.deviceState;
            jsonStream = writer.name("deviceState");
            streamable.toStream(jsonStream);
        }
        if (this.breadcrumbs != null) {
            streamable = this.breadcrumbs;
            jsonStream = writer.name("breadcrumbs");
            streamable.toStream(jsonStream);
        }
        if (this.groupingHash != null) {
            writer.name("groupingHash").value(this.groupingHash);
        }
        if (this.config.sendThreads) {
            streamable = new ThreadState(this.config);
            jsonStream = writer.name("threads");
            streamable.toStream(jsonStream);
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(String context) {
        void var1_1;
        this.context = var1_1;
    }

    public String getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.config.context != null) {
            return this.config.context;
        }
        if (this.appState != null) {
            return this.appState.getActiveScreenClass();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setGroupingHash(String groupingHash) {
        void var1_1;
        this.groupingHash = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSeverity(Severity severity) {
        if (severity != null) {
            void var1_1;
            this.severity = var1_1;
        }
    }

    public Severity getSeverity() {
        return this.severity;
    }

    /*
     * WARNING - void declaration
     */
    public void setUser(String id, String email, String name) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.user = new User((String)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserId(String id) {
        void var1_1;
        this.user = new User(this.user);
        this.user.setId((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEmail(String email) {
        void var1_1;
        this.user = new User(this.user);
        this.user.setEmail((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserName(String name) {
        void var1_1;
        this.user = new User(this.user);
        this.user.setName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addToTab(String tabName, String key, Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.metaData.addToTab((String)var1_1, (String)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void clearTab(String tabName) {
        void var1_1;
        this.metaData.clearTab((String)var1_1);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    /*
     * WARNING - void declaration
     */
    public void setMetaData(MetaData metaData) {
        void var1_1;
        this.metaData = var1_1;
    }

    public String getExceptionName() {
        if (this.exception != null) {
            return this.exception.getClass().getName();
        }
        return this.name;
    }

    public String getExceptionMessage() {
        if (this.exception != null) {
            return this.exception.getLocalizedMessage();
        }
        return this.message;
    }

    public Throwable getException() {
        return this.exception;
    }

    /*
     * WARNING - void declaration
     */
    final void setAppData(AppData appData) {
        void var1_1;
        this.appData = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setDeviceData(DeviceData deviceData) {
        void var1_1;
        this.deviceData = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setAppState(AppState appState) {
        void var1_1;
        this.appState = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setDeviceState(DeviceState deviceState) {
        void var1_1;
        this.deviceState = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setUser(User user) {
        void var1_1;
        this.user = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void setBreadcrumbs(Breadcrumbs breadcrumbs) {
        void var1_1;
        this.breadcrumbs = var1_1;
    }

    final boolean shouldIgnoreClass() {
        String string = this.getExceptionName();
        Object object = this.config;
        if (((Configuration)object).ignoreClasses == null) {
            return false;
        }
        object = Arrays.asList(((Configuration)object).ignoreClasses);
        return object.contains(string);
    }
}

