/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.Configuration;
import com.bugsnag.android.ActivityStack;
import com.bugsnag.android.utils.Async;
import com.bugsnag.utils.JSONUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONObject;

final class Diagnostics
extends com.bugsnag.Diagnostics {
    private static Long startTime;
    private static String uuid;
    private Context applicationContext;
    private String packageName;

    public Diagnostics(Configuration object, Context object2) {
        super((Configuration)object);
        this.applicationContext = object2;
        if (startTime == null) {
            startTime = SystemClock.elapsedRealtime();
        }
        this.packageName = this.applicationContext.getPackageName();
        object.setProjectPackages(new String[]{this.packageName});
        object.getOsVersion().set((Object)Build.VERSION.RELEASE);
        object.getAppVersion().set((Object)this.getPackageVersion(this.packageName));
        object.getReleaseStage().set((Object)this.guessReleaseStage(this.packageName));
        object = this;
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"manufacturer", (Object)Build.MANUFACTURER);
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"model", (Object)Build.MODEL);
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"screenDensity", (Object)Float.valueOf(((Diagnostics)((Object)object)).applicationContext.getResources().getDisplayMetrics().density));
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"screenResolution", (Object)super.getResolution());
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"totalMemory", (Object)super.totalMemoryAvailable());
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"osName", (Object)"android");
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"apiLevel", (Object)Build.VERSION.SDK_INT);
        object2 = object;
        object2 = Build.TAGS;
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"jailbroken", (Object)(object2 != null && ((String)object2).contains("test-keys") || Diagnostics.checkSuperUserAPK() ? 1 : 0));
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).deviceData, (String)"locale", (Object)Locale.getDefault().toString());
        object = this;
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).appData, (String)"id", (Object)((Diagnostics)((Object)object)).packageName);
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).appData, (String)"packageName", (Object)((Diagnostics)((Object)object)).packageName);
        JSONUtils.safePutOpt((JSONObject)((Diagnostics)((Object)object)).appData, (String)"name", (Object)super.getAppName());
    }

    public final JSONObject getAppState() {
        JSONObject jSONObject = super.getAppState();
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"duration", (Object)(SystemClock.elapsedRealtime() - startTime));
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"durationInForeground", (Object)ActivityStack.sessionLength());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"lowMemory", (Object)this.lowMemoryState());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"inForeground", (Object)ActivityStack.inForeground());
        List<String> list = ActivityStack.getNames();
        if (list.size() > 0) {
            JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"screenStack", list);
        }
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"activeScreen", (Object)ActivityStack.getTopActivityName());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"memoryUsage", (Object)this.memoryUsedByApp());
        return jSONObject;
    }

    public final JSONObject getDeviceState() {
        JSONObject jSONObject = super.getDeviceState();
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"freeMemory", (Object)this.totalFreeMemory());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"orientation", (Object)this.getOrientation());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"batteryLevel", (Object)this.getChargeLevel());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"freeDisk", (Object)this.getFreeDiskSpace());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"charging", (Object)this.getCharging());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"locationStatus", (Object)this.getGpsAllowed());
        JSONUtils.safePutOpt((JSONObject)jSONObject, (String)"networkAccess", (Object)this.getNetworkStatus());
        return jSONObject;
    }

    public final JSONObject getDeviceData() {
        super.getDeviceData();
        JSONUtils.safePutOpt((JSONObject)this.deviceData, (String)"id", (Object)this.getUUID());
        return this.deviceData;
    }

    public final String getContext() {
        return (String)this.config.getContext().get((Object)ActivityStack.getTopActivityName());
    }

    public final JSONObject getUser() {
        JSONObject jSONObject = super.getUser();
        if (jSONObject.optString("id").equals("")) {
            JSONUtils.safePut((JSONObject)jSONObject, (String)"id", (Object)this.getUUID());
        }
        return jSONObject;
    }

    private Long getFreeDiskSpace() {
        Long l = null;
        try {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            long l2 = (long)statFs.getBlockSize() * (long)statFs.getBlockCount();
            statFs = new StatFs(Environment.getDataDirectory().getPath());
            long l3 = (long)statFs.getBlockSize() * (long)statFs.getBlockCount();
            l = Math.min(l3, l2);
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return l;
    }

    private Boolean getCharging() {
        Boolean bl = null;
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            intentFilter = this.applicationContext.registerReceiver(null, intentFilter);
            int n = intentFilter.getIntExtra("status", -1);
            bl = n == 2 || n == 5;
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return bl;
    }

    private Float getChargeLevel() {
        Float f = null;
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            intentFilter = this.applicationContext.registerReceiver(null, intentFilter);
            int n = intentFilter.getIntExtra("level", -1);
            int n2 = intentFilter.getIntExtra("scale", -1);
            f = Float.valueOf((float)n / (float)n2);
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return f;
    }

    private String getOrientation() {
        String string = null;
        try {
            switch (this.applicationContext.getResources().getConfiguration().orientation) {
                case 2: {
                    string = "landscape";
                    break;
                }
                case 1: {
                    string = "portrait";
                }
            }
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return string;
    }

    private String getAppName() {
        String string = null;
        try {
            string = this.applicationContext.getPackageManager().getApplicationInfo((String)this.packageName, (int)0).name;
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return string;
    }

    private String getResolution() {
        String string = null;
        try {
            DisplayMetrics displayMetrics = this.applicationContext.getResources().getDisplayMetrics();
            string = String.format("%dx%d", Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels), Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels));
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return string;
    }

    private String getPackageVersion(String string) {
        String string2 = null;
        try {
            string = this.applicationContext.getPackageManager().getPackageInfo(string, 0);
            string2 = ((PackageInfo)string).versionName;
        }
        catch (Exception exception) {
            this.config.logger.warn("Could not get package version", (Throwable)exception);
        }
        return string2;
    }

    private String guessReleaseStage(String string) {
        String string2 = "production";
        try {
            string = this.applicationContext.getPackageManager().getApplicationInfo(string, 0);
            boolean bl = (((ApplicationInfo)string).flags & 2) != 0;
            if (bl) {
                string2 = "development";
            }
        }
        catch (Exception exception) {
            this.config.logger.warn("Could not guess release stage", (Throwable)exception);
        }
        return string2;
    }

    private synchronized String getUUID() {
        if (uuid != null) {
            return uuid;
        }
        SharedPreferences sharedPreferences = this.applicationContext.getSharedPreferences("Bugsnag", 0);
        uuid = sharedPreferences.getString("userId", null);
        if (uuid == null) {
            String string = uuid = UUID.randomUUID().toString();
            Async.safeAsync(new Runnable(this, sharedPreferences, string){
                private /* synthetic */ SharedPreferences val$settings;
                private /* synthetic */ String val$finalUuid;
                {
                    this.val$settings = sharedPreferences;
                    this.val$finalUuid = string;
                }

                @Override
                public final void run() {
                    SharedPreferences.Editor editor = this.val$settings.edit();
                    editor.putString("userId", this.val$finalUuid);
                    editor.commit();
                }
            });
        }
        return uuid;
    }

    private Long totalMemoryAvailable() {
        Long l = null;
        try {
            l = Runtime.getRuntime().maxMemory() != Long.MAX_VALUE ? Long.valueOf(Runtime.getRuntime().maxMemory()) : Long.valueOf(Runtime.getRuntime().totalMemory());
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return l;
    }

    private Long totalFreeMemory() {
        Long l = null;
        try {
            l = this.totalMemoryAvailable() - this.memoryUsedByApp();
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return l;
    }

    private Long memoryUsedByApp() {
        Long l = null;
        try {
            l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return l;
    }

    private Boolean lowMemoryState() {
        Boolean bl = null;
        try {
            ActivityManager activityManager = (ActivityManager)this.applicationContext.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            bl = memoryInfo.lowMemory;
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return bl;
    }

    private static boolean checkSuperUserAPK() {
        try {
            File file = new File("/system/app/Superuser.apk");
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getNetworkStatus() {
        String string = null;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.applicationContext.getSystemService("connectivity");
            connectivityManager = connectivityManager.getActiveNetworkInfo();
            string = connectivityManager != null && connectivityManager.isConnectedOrConnecting() ? (connectivityManager.getType() == 1 ? "wifi" : (connectivityManager.getType() == 9 ? "ethernet" : "cellular")) : "none";
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return string;
    }

    private String getGpsAllowed() {
        String string = null;
        try {
            Object object = this.applicationContext.getContentResolver();
            object = Settings.Secure.getString((ContentResolver)object, (String)"location_providers_allowed");
            string = object != null && ((String)object).length() > 0 ? "allowed" : "disallowed";
        }
        catch (Exception exception) {
            this.config.logger.warn((Throwable)exception);
        }
        return string;
    }
}

