/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.SystemClock;
import android.provider.Settings;
import com.bugsnag.MetaData;
import com.bugsnag.android.ActivityStack;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.utils.JSONUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

final class Diagnostics
extends MetaData {
    private static final int[] INTERESTING_NETWORKS = new int[]{0, 1, 6, 7, 9};

    public Diagnostics(Context context) {
        Object object = ActivityStack.getTopActivityName();
        List<String> list = ActivityStack.getNames();
        if (list.size() > 0) {
            this.addToTab("Application", "Activity Stack", list);
        }
        if (object != null) {
            this.addToTab("Application", "Top Activity", object);
        }
        this.addToTab("Session", "Session Length", Diagnostics.durationString(SystemClock.elapsedRealtime() / 1000L - Bugsnag.startTime));
        this.addToTab("Device", "Seconds Since Boot", Diagnostics.durationString(SystemClock.elapsedRealtime() / 1000L));
        object = Diagnostics.getNetworkStatus(context);
        if (object != null) {
            this.addToTab("Device", "Network Status", object);
        }
        if ((object = Diagnostics.getNetworks(context)) != null) {
            this.addToTab("Device", "Networks", object);
        }
        if ((object = Diagnostics.getGpsEnabled(context)) != null) {
            this.addToTab("Device", "GPS Enabled?", object);
        }
        if ((context = Diagnostics.getMemoryInfo(context)) != null) {
            this.addToTab("Device", "Memory", context);
        }
    }

    private static JSONObject getMemoryInfo(Context object) {
        JSONObject jSONObject = null;
        try {
            object = (ActivityManager)object.getApplicationContext().getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            object.getMemoryInfo(memoryInfo);
            long l = Runtime.getRuntime().maxMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            long l3 = l - l2;
            jSONObject = new JSONObject();
            JSONUtils.safePut((JSONObject)jSONObject, (String)"Total Available", (Object)Diagnostics.humanReadableByteCount(l));
            JSONUtils.safePut((JSONObject)jSONObject, (String)"Free", (Object)Diagnostics.humanReadableByteCount(l3));
            JSONUtils.safePut((JSONObject)jSONObject, (String)"Used", (Object)Diagnostics.humanReadableByteCount(l2));
            JSONUtils.safePut((JSONObject)jSONObject, (String)"Low Memory?", (Object)memoryInfo.lowMemory);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private static String getNetworkStatus(Context object) {
        String string = "Unknown";
        try {
            object = (ConnectivityManager)object.getSystemService("connectivity");
            object = object.getActiveNetworkInfo();
            string = object != null && object.isConnectedOrConnecting() ? "Connected" : "Not Connected";
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return string;
    }

    private static JSONObject getNetworks(Context object) {
        JSONObject jSONObject = null;
        try {
            object = (ConnectivityManager)object.getSystemService("connectivity");
            NetworkInfo networkInfo = object.getActiveNetworkInfo();
            object.getAllNetworkInfo();
            jSONObject = new JSONObject();
            int[] nArray = INTERESTING_NETWORKS;
            int n = INTERESTING_NETWORKS.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                NetworkInfo networkInfo2 = object.getNetworkInfo(n2);
                if (networkInfo2 == null) continue;
                JSONObject jSONObject2 = new JSONObject();
                JSONUtils.safePut((JSONObject)jSONObject2, (String)"Connected", (Object)networkInfo2.isConnectedOrConnecting());
                if (networkInfo2.getSubtypeName() != null && networkInfo2.getSubtypeName().length() > 0) {
                    JSONUtils.safePut((JSONObject)jSONObject2, (String)"Type", (Object)networkInfo2.getSubtypeName());
                }
                if (networkInfo != null && networkInfo2.getType() == networkInfo.getType()) {
                    JSONUtils.safePut((JSONObject)jSONObject2, (String)"Active", (Object)true);
                }
                JSONUtils.safePut((JSONObject)jSONObject, (String)networkInfo2.getTypeName(), (Object)jSONObject2);
            }
            if (jSONObject.length() == 0) {
                jSONObject = null;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private static Boolean getGpsEnabled(Context object) {
        Boolean bl = null;
        try {
            object = object.getContentResolver();
            object = Settings.Secure.getString((ContentResolver)object, (String)"location_providers_allowed");
            bl = object != null && ((String)object).length() > 0;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return bl;
    }

    private static String humanReadableByteCount(long l) {
        if (l < (long)1024) {
            return l + " B";
        }
        int n = (int)(Math.log(l) / Math.log(1024));
        String string = "KMGTPE".charAt(n - 1) + "i";
        return String.format("%.1f %sB", (double)l / Math.pow(1024, n), string);
    }

    private static String durationString(long l) {
        String string = "";
        int n = 0;
        long l2 = l;
        long l3 = TimeUnit.SECONDS.toDays(l);
        if (l3 != 0L) {
            l2 = l - TimeUnit.DAYS.toSeconds(l3);
            string = string + String.format("%d Days", l3);
            ++n;
        }
        if ((l3 = TimeUnit.SECONDS.toHours(l2)) != 0L) {
            if (n == 1) {
                string = string + " and ";
            }
            l2 -= TimeUnit.HOURS.toSeconds(l3);
            string = string + String.format("%d Hours", l3);
            ++n;
        }
        if ((l3 = TimeUnit.SECONDS.toMinutes(l2)) != 0L && n <= 1) {
            if (n == 1) {
                string = string + " and ";
            }
            l2 -= TimeUnit.MINUTES.toSeconds(l3);
            string = string + String.format("%d Minutes", l3);
            ++n;
        }
        if ((l3 = l2) != 0L && n <= 1) {
            if (n == 1) {
                string = string + " and ";
            }
            string = string + String.format("%d Seconds", l3);
            ++n;
        }
        if (l3 == 0L && n == 0) {
            string = "0 Seconds";
        }
        return string;
    }
}

