/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import com.bugsnag.android.gradle.Abi;
import com.bugsnag.android.gradle.internal.IOUtilKt;
import com.bugsnag.android.gradle.internal.NdkToolchain;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/bugsnag/android/gradle/internal/AbstractSoMappingTask;", "Lorg/gradle/api/DefaultTask;", "()V", "ndkToolchain", "Lorg/gradle/api/provider/Property;", "Lcom/bugsnag/android/gradle/internal/NdkToolchain;", "getNdkToolchain", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "generateMappingFile", "Ljava/io/File;", "soFile", "abi", "Lcom/bugsnag/android/gradle/Abi;", "makeSoMappingFile", "", "dst", "processBuilder", "Ljava/lang/ProcessBuilder;", "objcopy", "inputFile", "objdump", "outputFileFor", "prepareArchDirectory", "bugsnag-android-gradle-plugin"})
public abstract class AbstractSoMappingTask
extends DefaultTask {
    @Nested
    @NotNull
    public abstract Property<NdkToolchain> getNdkToolchain();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @NotNull
    protected ProcessBuilder objcopy(@NotNull File inputFile, @NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        String[] stringArray = new String[]{((NdkToolchain)this.getNdkToolchain().get()).objcopyForAbi(abi).getPath(), "--compress-debug-sections=zlib", "--only-keep-debug", inputFile.getPath(), "-"};
        return new ProcessBuilder(stringArray);
    }

    @NotNull
    protected ProcessBuilder objdump(@NotNull File inputFile, @NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        String objdump = ((NdkToolchain)this.getNdkToolchain().get()).objdumpForAbi(abi).getPath();
        String[] stringArray = new String[]{objdump, "--dwarf=info", "--dwarf=rawline", inputFile.getPath()};
        return new ProcessBuilder(stringArray);
    }

    @Nullable
    public final File generateMappingFile(@NotNull File soFile, @NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)soFile, (String)"soFile");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        try {
            ProcessBuilder processBuilder;
            switch (WhenMappings.$EnumSwitchMapping$0[((NdkToolchain)this.getNdkToolchain().get()).preferredMappingTool().ordinal()]) {
                case 1: {
                    processBuilder = this.objcopy(soFile, abi);
                    break;
                }
                case 2: {
                    processBuilder = this.objdump(soFile, abi);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ProcessBuilder process = processBuilder;
            File dst = this.outputFileFor(soFile, abi);
            this.makeSoMappingFile(dst, process);
            return dst;
        }
        catch (Exception e) {
            this.getLogger().error("Bugsnag: failed to generate symbols for " + abi + " " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private final void makeSoMappingFile(File dst, ProcessBuilder processBuilder) {
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
        IOUtilKt.outputZipFile(inputStream, dst);
        int exitCode = process.waitFor();
        if (!(exitCode == 0)) {
            boolean bl = false;
            String string = "Failed to generate symbols for " + dst + ", objdump exited with code " + exitCode;
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    protected File outputFileFor(@NotNull File soFile, @NotNull Abi abi) {
        Intrinsics.checkNotNullParameter((Object)soFile, (String)"soFile");
        Intrinsics.checkNotNullParameter((Object)((Object)abi), (String)"abi");
        return new File(this.prepareArchDirectory(abi), soFile.getName() + ".gz");
    }

    private final File prepareArchDirectory(Abi abi) {
        File file;
        File rootDir = ((Directory)this.getOutputDirectory().get()).getAsFile();
        File $this$prepareArchDirectory_u24lambda_u2d1 = file = new File(rootDir, abi.getAbiName());
        boolean bl = false;
        if (!$this$prepareArchDirectory_u24lambda_u2d1.isDirectory()) {
            $this$prepareArchDirectory_u24lambda_u2d1.mkdir();
        }
        return file;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NdkToolchain.MappingTool.values().length];
            nArray[NdkToolchain.MappingTool.OBJCOPY.ordinal()] = 1;
            nArray[NdkToolchain.MappingTool.OBJDUMP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

