/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.android.build.gradle.api.BaseVariantOutput;
import com.bugsnag.android.gradle.AndroidManifestInfo;
import com.bugsnag.android.gradle.AndroidManifestInfoReceiver;
import com.bugsnag.android.gradle.AndroidManifestInfoReceiverKt;
import com.bugsnag.android.gradle.internal.BugsnagIntermediatesKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Describable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0007R\u0013\u0010\u0006\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0016\u0010\u0016\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\tR\u0013\u0010 \u001a\u00020\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\t\u00a8\u0006)"}, d2={"Lcom/bugsnag/android/gradle/BugsnagUploadJsSourceMapTask;", "Lorg/gradle/api/DefaultTask;", "Lcom/bugsnag/android/gradle/AndroidManifestInfoReceiver;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "bugsnagSourceMaps", "Lorg/gradle/api/file/RegularFileProperty;", "getBugsnagSourceMaps", "()Lorg/gradle/api/file/RegularFileProperty;", "bundleJsFileProvider", "getBundleJsFileProvider", "devEnabled", "Lorg/gradle/api/provider/Property;", "", "getDevEnabled", "()Lorg/gradle/api/provider/Property;", "endpoint", "", "getEndpoint", "failOnUploadError", "getFailOnUploadError", "manifestInfo", "getManifestInfo", "overwrite", "getOverwrite", "projectRootFileProvider", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getProjectRootFileProvider", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "requestOutputFile", "getRequestOutputFile", "sourceMapFileProvider", "getSourceMapFileProvider", "generateUploadCommand", "Ljava/lang/ProcessBuilder;", "executable", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "uploadJsSourceMap", "", "Companion", "bugsnag-android-gradle-plugin"})
public class BugsnagUploadJsSourceMapTask
extends DefaultTask
implements AndroidManifestInfoReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegularFileProperty manifestInfo;
    @NotNull
    private final RegularFileProperty bugsnagSourceMaps;
    @NotNull
    private final RegularFileProperty bundleJsFileProvider;
    @NotNull
    private final RegularFileProperty sourceMapFileProvider;
    @NotNull
    private final RegularFileProperty requestOutputFile;
    @NotNull
    private final ConfigurableFileCollection projectRootFileProvider;
    @NotNull
    private final Property<Boolean> overwrite;
    @NotNull
    private final Property<String> endpoint;
    @NotNull
    private final Property<Boolean> devEnabled;
    @NotNull
    private final Property<Boolean> failOnUploadError;

    @Inject
    public BugsnagUploadJsSourceMapTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.setGroup("Bugsnag");
        this.setDescription("Uploads JS source maps to Bugsnag");
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.manifestInfo = regularFileProperty;
        RegularFileProperty regularFileProperty2 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objects.fileProperty()");
        this.bugsnagSourceMaps = regularFileProperty2;
        RegularFileProperty regularFileProperty3 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty3, (String)"objects.fileProperty()");
        this.bundleJsFileProvider = regularFileProperty3;
        RegularFileProperty regularFileProperty4 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty4, (String)"objects.fileProperty()");
        this.sourceMapFileProvider = regularFileProperty4;
        RegularFileProperty regularFileProperty5 = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty5, (String)"objects.fileProperty()");
        this.requestOutputFile = regularFileProperty5;
        ConfigurableFileCollection configurableFileCollection = objects.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.projectRootFileProvider = configurableFileCollection;
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.javaObjectType)");
        this.overwrite = property;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.javaObjectType)");
        this.endpoint = property2;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.javaObjectType)");
        this.devEnabled = property3;
        $this$property$iv = objects;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.javaObjectType)");
        this.failOnUploadError = property4;
    }

    @Override
    @InputFile
    @NotNull
    public RegularFileProperty getManifestInfo() {
        return this.manifestInfo;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getBugsnagSourceMaps() {
        return this.bugsnagSourceMaps;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getBundleJsFileProvider() {
        return this.bundleJsFileProvider;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getSourceMapFileProvider() {
        return this.sourceMapFileProvider;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getRequestOutputFile() {
        return this.requestOutputFile;
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getProjectRootFileProvider() {
        return this.projectRootFileProvider;
    }

    @Input
    @NotNull
    public final Property<Boolean> getOverwrite() {
        return this.overwrite;
    }

    @Input
    @NotNull
    public final Property<String> getEndpoint() {
        return this.endpoint;
    }

    @Input
    @NotNull
    public final Property<Boolean> getDevEnabled() {
        return this.devEnabled;
    }

    @Input
    @NotNull
    public final Property<Boolean> getFailOnUploadError() {
        return this.failOnUploadError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void uploadJsSourceMap() {
        Object it;
        Object outputMsg;
        BufferedReader bufferedReader;
        int n;
        Object object;
        AndroidManifestInfo manifestInfo = AndroidManifestInfoReceiverKt.parseManifestInfo(this);
        File executable = ((RegularFile)this.bugsnagSourceMaps.get()).getAsFile();
        String string = executable.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executable.absolutePath");
        ProcessBuilder builder = this.generateUploadCommand(string, manifestInfo);
        this.getProject().getLogger().lifecycle("Bugsnag: uploading react native sourcemap: " + builder.command());
        Process process = builder.start();
        int exitCode = process.waitFor();
        InputStream inputStream = process.getInputStream();
        if (inputStream != null) {
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            n = 8192;
            bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        } else {
            bufferedReader = null;
        }
        Closeable closeable = bufferedReader;
        object = null;
        try {
            Object it2 = (BufferedReader)closeable;
            boolean bl = false;
            BufferedReader bufferedReader2 = it2;
            it2 = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object object2 = outputMsg = it2;
        if (object2 != null) {
            it = object2;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Bugsnag: uploaded react native sourcemap: " + (String)outputMsg);
        }
        if (exitCode != 0) {
            String string2;
            InputStream inputStream2 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"process.errorStream");
            it = inputStream2;
            Object object3 = Charsets.UTF_8;
            Reader bl = new InputStreamReader((InputStream)it, (Charset)object3);
            n = 8192;
            it = bl instanceof BufferedReader ? (BufferedReader)bl : new BufferedReader(bl, n);
            object3 = null;
            try {
                BufferedReader it3 = (BufferedReader)it;
                boolean bl2 = false;
                string2 = TextStreamsKt.readText((Reader)it3);
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)object3);
            }
            String errMsg = string2;
            String msg = "Bugsnag: source map upload failed. Exit code=" + exitCode + ", msg=" + errMsg + ".";
            if (!executable.exists()) {
                this.getProject().getLogger().warn("Bugsnag: automatic upload of source maps failed because @bugsnag/source-maps could not be located.\nSet `uploadReactNativeMappings=false` if you don't want to upload source maps,or install the `@bugsnag/source-maps` node module.\nFor further docs, see https://docs.bugsnag.com/platforms/react-native/react-native/showing-full-stacktraces/#uploading-source-maps");
            } else {
                Object object4 = this.failOnUploadError.get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"failOnUploadError.get()");
                if (((Boolean)object4).booleanValue()) {
                    throw new IllegalStateException(msg);
                }
                this.getProject().getLogger().error(msg);
            }
        }
        String cliResult = exitCode == 0 ? "success" : "failure";
        Object object5 = this.requestOutputFile.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"requestOutputFile.asFile.get()");
        FilesKt.writeText$default((File)((File)object5), (String)cliResult, null, (int)2, null);
    }

    private final ProcessBuilder generateUploadCommand(String executable, AndroidManifestInfo manifestInfo) {
        Object[] objectArray = new String[]{executable, "upload-react-native", "--api-key", manifestInfo.getApiKey(), "--app-version", manifestInfo.getVersionName(), "--app-version-code", manifestInfo.getVersionCode(), "--platform", "android", "--source-map", ((File)this.sourceMapFileProvider.getAsFile().get()).getAbsolutePath(), "--bundle", ((File)this.bundleJsFileProvider.getAsFile().get()).getAbsolutePath(), "--project-root", this.projectRootFileProvider.getSingleFile().getAbsolutePath()};
        List cmd = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!Intrinsics.areEqual((Object)"https://upload.bugsnag.com", (Object)this.endpoint.get())) {
            cmd.add("--endpoint");
            cmd.add(this.endpoint.get());
        }
        Object object = this.overwrite.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"overwrite.get()");
        if (((Boolean)object).booleanValue()) {
            cmd.add("--overwrite");
        }
        Object object2 = this.devEnabled.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"devEnabled.get()");
        if (((Boolean)object2).booleanValue()) {
            cmd.add("--dev");
        }
        return new ProcessBuilder(cmd);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ>\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\b\u0014H\u0000\u00a2\u0006\u0002\b\u0015J1\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lcom/bugsnag/android/gradle/BugsnagUploadJsSourceMapTask$Companion;", "", "()V", "findReactNativeTaskArg", "", "task", "Lorg/gradle/api/Task;", "key", "isHermesEnabled", "", "project", "Lorg/gradle/api/Project;", "isHermesEnabled$bugsnag_android_gradle_plugin", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/bugsnag/android/gradle/BugsnagUploadJsSourceMapTask;", "name", "configurationAction", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "register$bugsnag_android_gradle_plugin", "rescueReactNativeSourceBundle", "rnTask", "rnBundle", "output", "Lcom/android/build/gradle/api/BaseVariantOutput;", "rescueReactNativeSourceBundle$bugsnag_android_gradle_plugin", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String findReactNativeTaskArg(@NotNull Task task2, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Object object = task2.property("args");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
            List args = (List)object;
            int index = CollectionsKt.indexOf((List)args, (Object)key);
            if (index != -1 && index < args.size()) {
                return (String)args.get(index + 1);
            }
            return null;
        }

        @NotNull
        public final TaskProvider<? extends BugsnagUploadJsSourceMapTask> register$bugsnag_android_gradle_plugin(@NotNull Project project, @NotNull String name, @NotNull Function1<? super BugsnagUploadJsSourceMapTask, Unit> configurationAction) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(configurationAction, (String)"configurationAction");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer $this$register$iv = taskContainer;
            boolean $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(name, BugsnagUploadJsSourceMapTask.class, new Action(configurationAction){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void execute(Object p0) {
                    this.function.invoke(p0);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.\u2026bjectType, configuration)");
            return taskProvider;
        }

        @Nullable
        public final String rescueReactNativeSourceBundle$bugsnag_android_gradle_plugin(@NotNull Task rnTask, @Nullable String rnBundle, @NotNull Project project, @NotNull BaseVariantOutput output) {
            int indexToInsert;
            List actions;
            String rnBundle1;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter((Object)rnTask, (String)"rnTask");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                rnBundle1 = rnBundle;
                List list = rnTask.getActions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rnTask.actions");
                List $this$indexOfFirst$iv = actions = CollectionsKt.toMutableList((Collection)list);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    boolean bl;
                    String string;
                    Action it = (Action)item$iv;
                    boolean bl2 = false;
                    Object object = it instanceof Describable ? (Describable)it : null;
                    if (object != null && (object = (string = object.getDisplayName())) != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"displayName");
                        bl = StringsKt.contains((CharSequence)string, (CharSequence)"doLast", (boolean)true);
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        n = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n = indexToInsert = -1;
            }
            if (indexToInsert != -1) {
                File rnSourceBundle = new File(rnBundle1);
                File rnRescuedSourceBundle = BugsnagIntermediatesKt.intermediateForRescuedReactNativeBundle(project, output);
                actions.add(indexToInsert, arg_0 -> Companion.rescueReactNativeSourceBundle$lambda-1(rnSourceBundle, rnRescuedSourceBundle, arg_0));
                rnTask.setActions(actions);
                rnBundle1 = rnRescuedSourceBundle.getAbsolutePath();
            }
            return rnBundle1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isHermesEnabled$bugsnag_android_gradle_plugin(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!project.hasProperty("react")) return false;
            Object object = project.property("react");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map map = (Map)object;
            if (!Intrinsics.areEqual(map.get("enableHermes"), (Object)true)) return false;
            return true;
        }

        private static final void rescueReactNativeSourceBundle$lambda-1(File $rnSourceBundle, File $rnRescuedSourceBundle, Task it) {
            Intrinsics.checkNotNullParameter((Object)$rnSourceBundle, (String)"$rnSourceBundle");
            Intrinsics.checkNotNullParameter((Object)$rnRescuedSourceBundle, (String)"$rnRescuedSourceBundle");
            FilesKt.copyTo$default((File)$rnSourceBundle, (File)$rnRescuedSourceBundle, (boolean)true, (int)0, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

