/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle;

import com.bugsnag.android.gradle.AndroidManifestInfo;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0004J!\u0010\u001d\u001a\u00020\u000e*\u00020\u001e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\u0012H\u0082\b\u00a8\u0006 "}, d2={"Lcom/bugsnag/android/gradle/AndroidManifestParser;", "", "()V", "findBugsnagMetadataValue", "", "document", "Lorg/w3c/dom/Document;", "attrName", "findManifestAttributeValue", "manifest", "Lorg/w3c/dom/Node;", "hasBuildUuid", "", "openAndroidManifestXml", "", "manifestPath", "Ljava/io/File;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "doc", "readManifest", "Lcom/bugsnag/android/gradle/AndroidManifestInfo;", "logger", "Lorg/gradle/api/logging/Logger;", "writeBuildUuid", "outputPath", "buildUuid", "forEach", "Lorg/w3c/dom/NodeList;", "Companion", "bugsnag-android-gradle-plugin"})
public final class AndroidManifestParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG_MANIFEST = "manifest";
    @NotNull
    private static final String TAG_APPLICATION = "application";
    @NotNull
    private static final String TAG_META_DATA = "meta-data";
    @NotNull
    private static final String TAG_API_KEY = "com.bugsnag.android.API_KEY";
    @NotNull
    private static final String TAG_BUILD_UUID = "com.bugsnag.android.BUILD_UUID";
    @NotNull
    private static final String TAG_VERSION_CODE = "com.bugsnag.android.VERSION_CODE";
    @NotNull
    private static final String TAG_APP_VERSION = "com.bugsnag.android.APP_VERSION";
    @NotNull
    private static final String ATTR_NAME = "android:name";
    @NotNull
    private static final String ATTR_VALUE = "android:value";
    @NotNull
    private static final String ATTR_APPLICATION_ID = "package";
    @NotNull
    private static final String ATTR_VERSION_CODE = "android:versionCode";
    @NotNull
    private static final String ATTR_VERSION_NAME = "android:versionName";

    @NotNull
    public final AndroidManifestInfo readManifest(@NotNull File manifestPath, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)manifestPath, (String)"manifestPath");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.debug("Bugsnag: Reading manifest at: " + manifestPath);
        Ref.ObjectRef apiKey = new Ref.ObjectRef();
        Ref.ObjectRef versionCode = new Ref.ObjectRef();
        Ref.ObjectRef buildUuid = new Ref.ObjectRef();
        Ref.ObjectRef versionName = new Ref.ObjectRef();
        Ref.ObjectRef applicationId = new Ref.ObjectRef();
        Ref.ObjectRef metaVersionCode = new Ref.ObjectRef();
        Ref.ObjectRef metaVersionName = new Ref.ObjectRef();
        this.openAndroidManifestXml(manifestPath, (Function1<? super Document, Unit>)((Function1)new Function1<Document, Unit>((Ref.ObjectRef<String>)apiKey, this, (Ref.ObjectRef<String>)buildUuid, (Ref.ObjectRef<String>)metaVersionCode, (Ref.ObjectRef<String>)metaVersionName, (Ref.ObjectRef<String>)applicationId, (Ref.ObjectRef<String>)versionCode, (Ref.ObjectRef<String>)versionName){
            final /* synthetic */ Ref.ObjectRef<String> $apiKey;
            final /* synthetic */ AndroidManifestParser this$0;
            final /* synthetic */ Ref.ObjectRef<String> $buildUuid;
            final /* synthetic */ Ref.ObjectRef<String> $metaVersionCode;
            final /* synthetic */ Ref.ObjectRef<String> $metaVersionName;
            final /* synthetic */ Ref.ObjectRef<String> $applicationId;
            final /* synthetic */ Ref.ObjectRef<String> $versionCode;
            final /* synthetic */ Ref.ObjectRef<String> $versionName;
            {
                this.$apiKey = $apiKey;
                this.this$0 = $receiver;
                this.$buildUuid = $buildUuid;
                this.$metaVersionCode = $metaVersionCode;
                this.$metaVersionName = $metaVersionName;
                this.$applicationId = $applicationId;
                this.$versionCode = $versionCode;
                this.$versionName = $versionName;
                super(1);
            }

            public final void invoke(@NotNull Document doc) {
                Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
                this.$apiKey.element = AndroidManifestParser.access$findBugsnagMetadataValue(this.this$0, doc, "com.bugsnag.android.API_KEY");
                this.$buildUuid.element = AndroidManifestParser.access$findBugsnagMetadataValue(this.this$0, doc, "com.bugsnag.android.BUILD_UUID");
                this.$metaVersionCode.element = AndroidManifestParser.access$findBugsnagMetadataValue(this.this$0, doc, "com.bugsnag.android.VERSION_CODE");
                this.$metaVersionName.element = AndroidManifestParser.access$findBugsnagMetadataValue(this.this$0, doc, "com.bugsnag.android.APP_VERSION");
                Node manifest = doc.getElementsByTagName("manifest").item(0);
                if (manifest != null) {
                    this.$applicationId.element = AndroidManifestParser.access$findManifestAttributeValue(this.this$0, manifest, "package");
                    if (this.$versionCode.element == null) {
                        this.$versionCode.element = AndroidManifestParser.access$findManifestAttributeValue(this.this$0, manifest, "android:versionCode");
                    }
                    if (this.$versionName.element == null) {
                        this.$versionName.element = AndroidManifestParser.access$findManifestAttributeValue(this.this$0, manifest, "android:versionName");
                    }
                }
            }
        }));
        if (apiKey.element == null || Intrinsics.areEqual((Object)"", (Object)apiKey.element) || versionCode.element == null || buildUuid.element == null || versionName.element == null || applicationId.element == null) {
            throw new IllegalStateException(StringsKt.trimMargin$default((String)("Bugsnag: Your AndroidManifest.xml is missing one or more of\n                    |apiKey/versionCode/buildUuid/versionName/package, which are required to upload to bugsnag.\n                    |apiKey=" + apiKey.element + "\n                    |versionCode=" + versionCode.element + "\n                    |buildUUID=" + buildUuid.element + "\n                    |versionName=" + versionName.element + "\n                    |applicationId=" + applicationId.element + "\n                    |Manifest file = " + manifestPath + "\n                "), null, (int)1, null));
        }
        Object object = apiKey.element;
        if (object == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object2 = versionCode.element;
        if (object2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object3 = buildUuid.element;
        if (object3 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object4 = versionName.element;
        if (object4 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object object5 = applicationId.element;
        if (object5 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new AndroidManifestInfo((String)object, (String)object2, (String)object3, (String)object4, (String)object5, (String)metaVersionCode.element, (String)metaVersionName.element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openAndroidManifestXml(File manifestPath, Function1<? super Document, Unit> action) {
        Closeable closeable = new FileInputStream(manifestPath);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            Object object;
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            AndroidManifestParser androidManifestParser = this;
            try {
                AndroidManifestParser $this$openAndroidManifestXml_u24lambda_u2d1_u24lambda_u2d0 = androidManifestParser;
                boolean bl2 = false;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(stream);
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                action.invoke((Object)document);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object object2 = object;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String findManifestAttributeValue(Node manifest, String attrName) {
        Node node = manifest.getAttributes().getNamedItem(attrName);
        return node != null ? node.getNodeValue() : null;
    }

    private final String findBugsnagMetadataValue(Document document, String attrName) {
        AndroidManifestParser androidManifestParser = this;
        NodeList nodeList = document.getElementsByTagName(TAG_META_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"document.getElementsByTagName(TAG_META_DATA)");
        NodeList $this$forEach$iv = nodeList;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.getLength();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            String key;
            Node node;
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv.item(index$iv), (String)"item(index)");
            boolean bl = false;
            Node node2 = node.getAttributes().getNamedItem(ATTR_NAME);
            String string = key = node2 != null ? node2.getNodeValue() : null;
            if (!Intrinsics.areEqual((Object)attrName, (Object)key)) continue;
            Node node3 = node.getAttributes().getNamedItem(ATTR_VALUE);
            return node3 != null ? node3.getNodeValue() : null;
        }
        return null;
    }

    public final void writeBuildUuid(@NotNull File manifestPath, @NotNull File outputPath, @NotNull String buildUuid) {
        Intrinsics.checkNotNullParameter((Object)manifestPath, (String)"manifestPath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)buildUuid, (String)"buildUuid");
        this.openAndroidManifestXml(manifestPath, (Function1<? super Document, Unit>)((Function1)new Function1<Document, Unit>(this, buildUuid, outputPath){
            final /* synthetic */ AndroidManifestParser this$0;
            final /* synthetic */ String $buildUuid;
            final /* synthetic */ File $outputPath;
            {
                this.this$0 = $receiver;
                this.$buildUuid = $buildUuid;
                this.$outputPath = $outputPath;
                super(1);
            }

            public final void invoke(@NotNull Document document) {
                Transformer transformer;
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                if (!AndroidManifestParser.access$hasBuildUuid(this.this$0, document)) {
                    Node application = document.getElementsByTagName("application").item(0);
                    Element metadata = document.createElement("meta-data");
                    metadata.setAttribute("android:name", "com.bugsnag.android.BUILD_UUID");
                    metadata.setAttribute("android:value", this.$buildUuid);
                    application.appendChild(metadata);
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer $this$invoke_u24lambda_u2d0 = transformer = factory.newTransformer();
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.setOutputProperty("omit-xml-declaration", "yes");
                $this$invoke_u24lambda_u2d0.setOutputProperty("indent", "yes");
                $this$invoke_u24lambda_u2d0.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                Transformer transformer2 = transformer;
                DOMSource source = new DOMSource(document);
                StreamResult output = new StreamResult(this.$outputPath);
                transformer2.transform(source, output);
            }
        }));
    }

    public static /* synthetic */ void writeBuildUuid$default(AndroidManifestParser androidManifestParser, File file, File file2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = file;
        }
        androidManifestParser.writeBuildUuid(file, file2, string);
    }

    private final boolean hasBuildUuid(Document document) {
        AndroidManifestParser androidManifestParser = this;
        NodeList nodeList = document.getElementsByTagName(TAG_META_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"document.getElementsByTagName(TAG_META_DATA)");
        NodeList $this$forEach$iv = nodeList;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.getLength();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            String key;
            Node node;
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv.item(index$iv), (String)"item(index)");
            boolean bl = false;
            Node node2 = node.getAttributes().getNamedItem(ATTR_NAME);
            String string = key = node2 != null ? node2.getNodeValue() : null;
            if (!Intrinsics.areEqual((Object)TAG_BUILD_UUID, (Object)key)) continue;
            return true;
        }
        return false;
    }

    private final void forEach(NodeList $this$forEach, Function1<? super Node, Unit> action) {
        boolean $i$f$forEach = false;
        int n = $this$forEach.getLength();
        for (int index = 0; index < n; ++index) {
            Node node = $this$forEach.item(index);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"item(index)");
            action.invoke((Object)node);
        }
    }

    public static final /* synthetic */ String access$findBugsnagMetadataValue(AndroidManifestParser $this, Document document, String attrName) {
        return $this.findBugsnagMetadataValue(document, attrName);
    }

    public static final /* synthetic */ String access$findManifestAttributeValue(AndroidManifestParser $this, Node manifest, String attrName) {
        return $this.findManifestAttributeValue(manifest, attrName);
    }

    public static final /* synthetic */ boolean access$hasBuildUuid(AndroidManifestParser $this, Document document) {
        return $this.hasBuildUuid(document);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/bugsnag/android/gradle/AndroidManifestParser$Companion;", "", "()V", "ATTR_APPLICATION_ID", "", "ATTR_NAME", "ATTR_VALUE", "ATTR_VERSION_CODE", "ATTR_VERSION_NAME", "TAG_API_KEY", "TAG_APPLICATION", "TAG_APP_VERSION", "TAG_BUILD_UUID", "TAG_MANIFEST", "TAG_META_DATA", "TAG_VERSION_CODE", "bugsnag-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

