/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.gradle.internal;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.builder.model.BuildType;
import com.bugsnag.android.gradle.GroovyCompat;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a3\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0003H\u0000\u00a8\u0006\u0014"}, d2={"findDexguardMappingFile", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "variantOutput", "Lcom/android/build/gradle/api/BaseVariantOutput;", "path", "", "", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/api/BaseVariant;Lcom/android/build/gradle/api/BaseVariantOutput;[Ljava/lang/String;)Ljava/io/File;", "findMappingFileDexguard9", "", "findMappingFileDexguardLegacy", "getDexguardAabTaskName", "getDexguardMajorVersionInt", "", "hasDexguardPlugin", "", "bugsnag-android-gradle-plugin"})
public final class DexguardCompatKt {
    @NotNull
    public static final List<File> findMappingFileDexguard9(@NotNull Project project, @NotNull BaseVariant variant, @NotNull BaseVariantOutput variantOutput) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantOutput, (String)"variantOutput");
        return CollectionsKt.listOf((Object[])new File[]{DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, new String[]{"outputs", "dexguard", "mapping", "apk"}), DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, new String[]{"outputs", "dexguard", "mapping", "bundle"})});
    }

    @NotNull
    public static final File findMappingFileDexguardLegacy(@NotNull Project project, @NotNull BaseVariant variant, @NotNull BaseVariantOutput variantOutput) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantOutput, (String)"variantOutput");
        return DexguardCompatKt.findDexguardMappingFile(project, variant, variantOutput, new String[]{"outputs", "mapping"});
    }

    private static final File findDexguardMappingFile(Project project, BaseVariant variant, BaseVariantOutput variantOutput, String[] path) {
        String string = project.getBuildDir().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.buildDir.toString()");
        String buildDir = string;
        String outputDir = variantOutput.getDirName();
        if (Intrinsics.areEqual((Object)path[path.length - 1], (Object)"bundle")) {
            outputDir = "";
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.addSpread((Object)path);
        spreadBuilder.add((Object)variant.getDirName());
        spreadBuilder.add((Object)outputDir);
        spreadBuilder.add((Object)"mapping.txt");
        File file = Paths.get(buildDir, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()])).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(buildDir, *pat\u2026, \"mapping.txt\").toFile()");
        return file;
    }

    public static final boolean hasDexguardPlugin(@NotNull Project $this$hasDexguardPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDexguardPlugin, (String)"$this$hasDexguardPlugin");
        return $this$hasDexguardPlugin.getPluginManager().hasPlugin("dexguard");
    }

    public static final int getDexguardMajorVersionInt(@NotNull Project project) {
        VersionNumber versionNumber;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = GroovyCompat.getDexguardVersionString(project);
        if (string == null) {
            string = "";
        }
        String version = string;
        VersionNumber versionNumber2 = versionNumber = VersionNumber.parse((String)version);
        Intrinsics.checkNotNullExpressionValue((Object)versionNumber2, (String)"versionNumber");
        return versionNumber2.getMajor();
    }

    @NotNull
    public static final String getDexguardAabTaskName(@NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        BuildType buildType = variant.getBuildType();
        Intrinsics.checkNotNullExpressionValue((Object)buildType, (String)"variant.buildType");
        String buildType2 = StringsKt.capitalize((String)buildType.getName());
        String string = variant.getFlavorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.flavorName");
        String flavor = StringsKt.capitalize((String)string);
        return "dexguardAab" + flavor + buildType2;
    }
}

