/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.Client;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.User;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.DateUtils;
import com.bugsnag.android.internal.ForegroundDetector;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.TaskType;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;

class SessionTracker
extends BaseObservable
implements ForegroundDetector.OnActivityCallback {
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private final Deque<String> foregroundActivities = new ArrayDeque<String>();
    private final long timeoutMs;
    private final ImmutableConfig configuration;
    private final CallbackState callbackState;
    private final Client client;
    final SessionStore sessionStore;
    private volatile Session currentSession = null;
    final BackgroundTaskService backgroundTaskService;
    final Logger logger;
    private boolean shouldSuppressFirstAutoSession = true;

    SessionTracker(ImmutableConfig configuration, CallbackState callbackState, Client client, SessionStore sessionStore2, Logger logger, BackgroundTaskService backgroundTaskService) {
        this(configuration, callbackState, client, 30000L, sessionStore2, logger, backgroundTaskService);
    }

    SessionTracker(ImmutableConfig configuration, CallbackState callbackState, Client client, long timeoutMs, SessionStore sessionStore2, Logger logger, BackgroundTaskService backgroundTaskService) {
        this.configuration = configuration;
        this.callbackState = callbackState;
        this.client = client;
        this.timeoutMs = timeoutMs;
        this.sessionStore = sessionStore2;
        this.backgroundTaskService = backgroundTaskService;
        this.logger = logger;
    }

    @Nullable
    @VisibleForTesting
    Session startNewSession(@NonNull Date date, @Nullable User user, boolean autoCaptured) {
        if (this.shouldDiscardSession(autoCaptured)) {
            return null;
        }
        String id = UUID.randomUUID().toString();
        Session session = new Session(id, date, user, autoCaptured, this.client.getNotifier(), this.logger, this.configuration.getApiKey());
        if (this.trackSessionIfNeeded(session)) {
            return session;
        }
        return null;
    }

    Session startSession(boolean autoCaptured) {
        if (this.shouldDiscardSession(autoCaptured)) {
            return null;
        }
        return this.startNewSession(new Date(), this.client.getUser(), autoCaptured);
    }

    private boolean shouldDiscardSession(boolean autoCaptured) {
        if (this.client.getConfig().shouldDiscardSession(autoCaptured)) {
            return true;
        }
        Session existingSession = this.currentSession;
        if (autoCaptured && existingSession != null && !existingSession.isAutoCaptured() && this.shouldSuppressFirstAutoSession) {
            this.shouldSuppressFirstAutoSession = false;
            return true;
        }
        if (autoCaptured) {
            this.shouldSuppressFirstAutoSession = false;
        }
        return false;
    }

    void pauseSession() {
        Session session = this.currentSession;
        if (session != null) {
            session.markPaused();
            this.updateState(StateEvent.PauseSession.INSTANCE);
        }
    }

    boolean resumeSession() {
        boolean resumed;
        Session session = this.currentSession;
        if (session == null) {
            session = this.startSession(false);
            resumed = false;
        } else {
            resumed = session.markResumed();
        }
        if (session != null) {
            this.notifySessionStartObserver(session);
        }
        return resumed;
    }

    private void notifySessionStartObserver(Session session) {
        String startedAt = DateUtils.toIso8601(session.getStartedAt());
        this.updateState(new StateEvent.StartSession(session.getId(), startedAt, session.getHandledCount(), session.getUnhandledCount()));
    }

    @Nullable
    Session registerExistingSession(@Nullable Date date, @Nullable String sessionId, @Nullable User user, int unhandledCount, int handledCount) {
        if (this.client.getConfig().shouldDiscardSession(false)) {
            return null;
        }
        Session session = null;
        if (date != null && sessionId != null) {
            session = new Session(sessionId, date, user, unhandledCount, handledCount, this.client.getNotifier(), this.logger, this.configuration.getApiKey());
            this.notifySessionStartObserver(session);
        } else {
            this.updateState(StateEvent.PauseSession.INSTANCE);
        }
        this.currentSession = session;
        return session;
    }

    private boolean trackSessionIfNeeded(Session session) {
        this.logger.d("SessionTracker#trackSessionIfNeeded() - session captured by Client");
        session.setApp(this.client.getAppDataCollector().generateApp());
        session.setDevice(this.client.getDeviceDataCollector().generateDevice());
        boolean deliverSession = this.callbackState.runOnSessionTasks(session, this.logger);
        if (deliverSession && session.markTracked()) {
            this.currentSession = session;
            this.notifySessionStartObserver(session);
            this.flushInMemorySession(session);
            this.flushAsync();
            return true;
        }
        return false;
    }

    @Nullable
    Session getCurrentSession() {
        Session session = this.currentSession;
        if (session != null && !session.isPaused()) {
            return session;
        }
        return null;
    }

    Session incrementUnhandledAndCopy() {
        Session session = this.getCurrentSession();
        if (session != null) {
            return session.incrementUnhandledAndCopy();
        }
        return null;
    }

    Session incrementHandledAndCopy() {
        Session session = this.getCurrentSession();
        if (session != null) {
            return session.incrementHandledAndCopy();
        }
        return null;
    }

    void flushAsync() {
        try {
            this.backgroundTaskService.submitTask(TaskType.SESSION_REQUEST, new Runnable(){

                @Override
                public void run() {
                    SessionTracker.this.flushStoredSessions();
                }
            });
        }
        catch (RejectedExecutionException ex) {
            this.logger.w("Failed to flush session reports", ex);
        }
    }

    void flushStoredSessions() {
        List<File> storedFiles = this.sessionStore.findStoredFiles();
        for (File storedFile : storedFiles) {
            this.flushStoredSession(storedFile);
        }
    }

    void flushStoredSession(File storedFile) {
        this.logger.d("SessionTracker#flushStoredSession() - attempting delivery");
        Session payload = new Session(storedFile, this.client.getNotifier(), this.logger, this.configuration.getApiKey());
        if (payload.isLegacyPayload()) {
            payload.setApp(this.client.getAppDataCollector().generateApp());
            payload.setDevice(this.client.getDeviceDataCollector().generateDevice());
        }
        DeliveryStatus deliveryStatus = this.deliverSessionPayload(payload);
        switch (deliveryStatus) {
            case DELIVERED: {
                this.sessionStore.deleteStoredFiles(Collections.singletonList(storedFile));
                this.logger.d("Sent 1 new session to Bugsnag");
                break;
            }
            case UNDELIVERED: {
                if (this.sessionStore.isTooOld(storedFile)) {
                    this.logger.w("Discarding historical session (from {" + this.sessionStore.getCreationDate(storedFile) + "}) after failed delivery");
                    this.sessionStore.deleteStoredFiles(Collections.singletonList(storedFile));
                    break;
                }
                this.sessionStore.cancelQueuedFiles(Collections.singletonList(storedFile));
                this.logger.w("Leaving session payload for future delivery");
                break;
            }
            case FAILURE: {
                this.logger.w("Deleting invalid session tracking payload");
                this.sessionStore.deleteStoredFiles(Collections.singletonList(storedFile));
                break;
            }
        }
    }

    private void flushInMemorySession(final Session session) {
        try {
            this.backgroundTaskService.submitTask(TaskType.SESSION_REQUEST, new Runnable(){

                @Override
                public void run() {
                    SessionTracker.this.deliverInMemorySession(session);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            this.sessionStore.write(session);
        }
    }

    void deliverInMemorySession(Session session) {
        try {
            this.logger.d("SessionTracker#trackSessionIfNeeded() - attempting initial delivery");
            DeliveryStatus deliveryStatus = this.deliverSessionPayload(session);
            switch (deliveryStatus) {
                case UNDELIVERED: {
                    this.logger.w("Storing session payload for future delivery");
                    this.sessionStore.write(session);
                    break;
                }
                case FAILURE: {
                    this.logger.w("Dropping invalid session tracking payload");
                    break;
                }
                case DELIVERED: {
                    this.logger.d("Sent 1 new session to Bugsnag");
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.w("Session tracking payload failed", exception);
        }
    }

    DeliveryStatus deliverSessionPayload(Session payload) {
        DeliveryParams params = this.configuration.getSessionApiDeliveryParams(payload);
        Delivery delivery = this.configuration.getDelivery();
        return delivery.deliver(payload, params);
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.updateContext(activity.getClass().getSimpleName(), true);
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.updateContext(activity.getClass().getSimpleName(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateContext(String activityName, boolean activityStarting) {
        if (activityStarting) {
            Deque<String> deque = this.foregroundActivities;
            synchronized (deque) {
                this.foregroundActivities.add(activityName);
            }
        }
        Deque<String> deque = this.foregroundActivities;
        synchronized (deque) {
            this.foregroundActivities.removeLastOccurrence(activityName);
        }
        this.client.getContextState().setAutomaticContext(this.getContextActivity());
    }

    boolean isInForeground() {
        return ForegroundDetector.isInForeground();
    }

    long getLastEnteredForegroundMs() {
        return ForegroundDetector.getLastEnteredForegroundMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getContextActivity() {
        Deque<String> deque = this.foregroundActivities;
        synchronized (deque) {
            return this.foregroundActivities.peekLast();
        }
    }

    @Override
    public void onForegroundStatus(boolean foreground, long timestamp) {
        long noActivityRunningForMs;
        if (foreground && (noActivityRunningForMs = timestamp - ForegroundDetector.getLastExitedForegroundMs()) >= this.timeoutMs && this.configuration.getAutoTrackSessions()) {
            this.startNewSession(new Date(), this.client.getUser(), true);
        }
        this.updateState(new StateEvent.UpdateInForeground(foreground, this.getContextActivity()));
    }
}

