/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001)B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018J\u0006\u0010\u001b\u001a\u00020\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010\u0001H&J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010\u001e2\u0006\u0010'\u001a\u00020(R\u0018\u0010\u0006\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/bugsnag/android/FileStore;", "", "storageDir", "Ljava/io/File;", "maxStoreCount", "", "comparator", "Ljava/util/Comparator;", "logger", "Lcom/bugsnag/android/Logger;", "delegate", "Lcom/bugsnag/android/FileStore$Delegate;", "(Ljava/io/File;ILjava/util/Comparator;Lcom/bugsnag/android/Logger;Lcom/bugsnag/android/FileStore$Delegate;)V", "getDelegate", "()Lcom/bugsnag/android/FileStore$Delegate;", "lock", "Ljava/util/concurrent/locks/Lock;", "getLogger", "()Lcom/bugsnag/android/Logger;", "queuedFiles", "", "cancelQueuedFiles", "", "files", "", "deleteStoredFiles", "storedFiles", "discardOldestFileIfNeeded", "enqueueContentForDelivery", "content", "", "filename", "findStoredFiles", "", "getFilename", "obj", "isStorageDirValid", "", "write", "streamable", "Lcom/bugsnag/android/JsonStream$Streamable;", "Delegate", "bugsnag-android-core_release"})
public abstract class FileStore {
    @NotNull
    private final File storageDir;
    private final int maxStoreCount;
    @NotNull
    private final Comparator<? super File> comparator;
    @NotNull
    private final Logger logger;
    @Nullable
    private final Delegate delegate;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Collection<File> queuedFiles;

    public FileStore(@NotNull File storageDir, int maxStoreCount, @NotNull Comparator<? super File> comparator, @NotNull Logger logger, @Nullable Delegate delegate2) {
        this.storageDir = storageDir;
        this.maxStoreCount = maxStoreCount;
        this.comparator = comparator;
        this.logger = logger;
        this.delegate = delegate2;
        this.lock = new ReentrantLock();
        this.queuedFiles = new ConcurrentSkipListSet();
        this.isStorageDirValid(this.storageDir);
    }

    @NotNull
    protected Logger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final Delegate getDelegate() {
        return this.delegate;
    }

    private final boolean isStorageDirValid(File storageDir) {
        try {
            storageDir.mkdirs();
        }
        catch (Exception exception) {
            this.getLogger().e("Could not prepare file storage directory", exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void enqueueContentForDelivery(@Nullable String content, @NotNull String filename) {
        block14: {
            if (!this.isStorageDirValid(this.storageDir)) {
                return;
            }
            this.discardOldestFileIfNeeded();
            this.lock.lock();
            out = null;
            filePath = new File(this.storageDir, filename).getAbsolutePath();
            try {
                fos = new FileOutputStream(filePath);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                ((BufferedWriter)out).write(content);
                ** try [egrp 1[TRYBLOCK] [0 : 92->104)] { 
            }
            catch (Exception exc) {
                eventFile = new File(filePath);
                var7_14 = this.delegate;
                if (var7_14 != null) {
                    var7_14.onErrorIOFailure(exc, eventFile, "NDK Crash report copy");
                }
                IOUtils.deleteFile(eventFile, this.getLogger());
                break block14;
            }
            finally {
                try {
                    exc = out;
                    if (exc != null) {
                        exc.close();
                    }
                }
                catch (Exception exception) {
                    this.getLogger().w(Intrinsics.stringPlus((String)"Failed to close unsent payload writer: ", (Object)filename), exception);
                }
                this.lock.unlock();
            }
lbl-1000:
            // 1 sources

            {
                fos = out;
                fos.close();
            }
lbl17:
            // 1 sources

            catch (Exception exception) {
                this.getLogger().w(Intrinsics.stringPlus((String)"Failed to close unsent payload writer: ", (Object)filename), exception);
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String write(@NotNull JsonStream.Streamable streamable) {
        if (!this.isStorageDirValid(this.storageDir)) {
            return null;
        }
        if (this.maxStoreCount == 0) {
            return null;
        }
        this.discardOldestFileIfNeeded();
        String filename = new File(this.storageDir, this.getFilename(streamable)).getAbsolutePath();
        JsonStream stream = null;
        this.lock.lock();
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            Writer out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            stream = new JsonStream(out);
            stream.value(streamable);
            this.getLogger().i("Saved unsent payload to disk: '" + filename + '\'');
            String string = filename;
            return string;
        }
        catch (FileNotFoundException exc) {
            this.getLogger().w("Ignoring FileNotFoundException - unable to create file", exc);
        }
        catch (Exception exc) {
            File eventFile = new File(filename);
            Delegate delegate2 = this.delegate;
            if (delegate2 != null) {
                delegate2.onErrorIOFailure(exc, eventFile, "Crash report serialization");
            }
            IOUtils.deleteFile(eventFile, this.getLogger());
        }
        finally {
            IOUtils.closeQuietly(stream);
            this.lock.unlock();
        }
        return null;
    }

    public final void discardOldestFileIfNeeded() {
        if (this.isStorageDirValid(this.storageDir)) {
            File[] fileArray = this.storageDir.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] listFiles = fileArray;
            ArrayList files = CollectionsKt.arrayListOf((Object[])Arrays.copyOf(listFiles, listFiles.length));
            if (files.size() >= this.maxStoreCount) {
                Collections.sort(files, this.comparator);
                int k = 0;
                while (k < files.size() && files.size() >= this.maxStoreCount) {
                    int n;
                    File oldestFile = (File)files.get(k);
                    if (!this.queuedFiles.contains(oldestFile)) {
                        this.getLogger().w("Discarding oldest error as stored error limit reached: '" + oldestFile.getPath() + '\'');
                        this.deleteStoredFiles(SetsKt.setOf((Object)oldestFile));
                        files.remove(k);
                        n = k;
                        k = n + -1;
                    }
                    n = k;
                    k = n + 1;
                }
            }
        }
    }

    @NotNull
    public abstract String getFilename(@Nullable Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> findStoredFiles() {
        void var1_1;
        this.lock.lock();
        try {
            File[] values;
            List files = new ArrayList();
            if (this.isStorageDirValid(this.storageDir) && (values = this.storageDir.listFiles()) != null) {
                for (File value : values) {
                    if (value.length() != 0L) continue;
                    if (value.delete()) continue;
                    value.deleteOnExit();
                }
            }
            this.queuedFiles.addAll(files);
        }
        finally {
            this.lock.unlock();
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelQueuedFiles(@Nullable Collection<? extends File> files) {
        this.lock.lock();
        try {
            if (files != null) {
                this.queuedFiles.removeAll(files);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteStoredFiles(@Nullable Collection<? extends File> storedFiles) {
        this.lock.lock();
        try {
            if (storedFiles != null) {
                this.queuedFiles.removeAll(storedFiles);
                for (File file : storedFiles) {
                    if (file.delete()) continue;
                    file.deleteOnExit();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH&\u00a8\u0006\u000b"}, d2={"Lcom/bugsnag/android/FileStore$Delegate;", "", "onErrorIOFailure", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorFile", "Ljava/io/File;", "context", "", "bugsnag-android-core_release"})
    public static interface Delegate {
        public void onErrorIOFailure(@Nullable Exception var1, @Nullable File var2, @Nullable String var3);
    }
}

