/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import androidx.annotation.Nullable;
import com.bugsnag.android.repackaged.dslplatform.json.BinaryConverter;
import com.bugsnag.android.repackaged.dslplatform.json.BoolConverter;
import com.bugsnag.android.repackaged.dslplatform.json.Configuration;
import com.bugsnag.android.repackaged.dslplatform.json.ConfigurationException;
import com.bugsnag.android.repackaged.dslplatform.json.ExternalConverterAnalyzer;
import com.bugsnag.android.repackaged.dslplatform.json.JsonObject;
import com.bugsnag.android.repackaged.dslplatform.json.JsonReader;
import com.bugsnag.android.repackaged.dslplatform.json.JsonWriter;
import com.bugsnag.android.repackaged.dslplatform.json.NetConverter;
import com.bugsnag.android.repackaged.dslplatform.json.NumberConverter;
import com.bugsnag.android.repackaged.dslplatform.json.ObjectConverter;
import com.bugsnag.android.repackaged.dslplatform.json.SerializationException;
import com.bugsnag.android.repackaged.dslplatform.json.StringCache;
import com.bugsnag.android.repackaged.dslplatform.json.StringConverter;
import com.bugsnag.android.repackaged.dslplatform.json.TypeLookup;
import com.bugsnag.android.repackaged.dslplatform.json.UUIDConverter;
import com.bugsnag.android.repackaged.dslplatform.json.UnknownSerializer;
import com.bugsnag.android.repackaged.dslplatform.json.XmlConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.w3c.dom.Element;

public class DslJson<TContext>
implements UnknownSerializer,
TypeLookup {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Object unknownValue = new Object();
    @Nullable
    public final TContext context;
    @Nullable
    protected final Fallback<TContext> fallback;
    public final boolean omitDefaults;
    public final boolean allowArrayFormat;
    protected final StringCache keyCache;
    protected final StringCache valuesCache;
    protected final List<ConverterFactory<JsonWriter.WriteObject>> writerFactories = new CopyOnWriteArrayList<ConverterFactory<JsonWriter.WriteObject>>();
    private final int settingsWriters;
    protected final List<ConverterFactory<JsonReader.ReadObject>> readerFactories = new CopyOnWriteArrayList<ConverterFactory<JsonReader.ReadObject>>();
    private final int settingsReaders;
    protected final List<ConverterFactory<JsonReader.BindObject>> binderFactories = new CopyOnWriteArrayList<ConverterFactory<JsonReader.BindObject>>();
    private final int settingsBinders;
    private final JsonReader.ErrorInfo errorInfo;
    private final JsonReader.DoublePrecision doublePrecision;
    private final JsonReader.UnknownNumberParsing unknownNumbers;
    private final int maxNumberDigits;
    private final int maxStringSize;
    protected final ThreadLocal<JsonWriter> localWriter;
    protected final ThreadLocal<JsonReader> localReader;
    private final ExternalConverterAnalyzer externalConverterAnalyzer;
    private final Map<Class<? extends Annotation>, Boolean> creatorMarkers;
    private final Map<Type, Object> defaults = new ConcurrentHashMap<Type, Object>();
    private final ConcurrentMap<Class<?>, JsonReader.ReadJsonObject<JsonObject>> objectReaders = new ConcurrentHashMap();
    private final ConcurrentMap<Type, JsonReader.ReadObject> readers = new ConcurrentHashMap<Type, JsonReader.ReadObject>();
    private final ConcurrentMap<Type, JsonReader.BindObject> binders = new ConcurrentHashMap<Type, JsonReader.BindObject>();
    private final ConcurrentMap<Type, JsonWriter.WriteObject> writers = new ConcurrentHashMap<Type, JsonWriter.WriteObject>();
    private final ConcurrentMap<Class<?>, Class<?>> writerMap = new ConcurrentHashMap();
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void remove() {
        }

        @Nullable
        public Object next() {
            return null;
        }
    };
    private final JsonWriter.WriteObject<JsonObject> OBJECT_WRITER = new JsonWriter.WriteObject<JsonObject>(){

        @Override
        public void write(JsonWriter writer, @Nullable JsonObject value) {
            if (value == null) {
                writer.writeNull();
            } else {
                value.serialize(writer, DslJson.this.omitDefaults);
            }
        }
    };
    private final JsonWriter.WriteObject OBJECT_ARRAY_WRITER = new JsonWriter.WriteObject(){

        public void write(JsonWriter writer, @Nullable Object value) {
            DslJson.this.serialize(writer, (JsonObject[])value);
        }
    };
    private static final JsonWriter.WriteObject CHAR_ARRAY_WRITER = new JsonWriter.WriteObject(){

        public void write(JsonWriter writer, @Nullable Object value) {
            StringConverter.serialize(new String((char[])value), writer);
        }
    };
    private final JsonWriter.WriteObject NULL_WRITER = new JsonWriter.WriteObject(){

        public void write(JsonWriter writer, @Nullable Object value) {
            writer.writeNull();
        }
    };
    private static final byte[] NULL = new byte[]{110, 117, 108, 108};

    public DslJson() {
        this(new Settings().includeServiceLoader());
    }

    @Deprecated
    public DslJson(@Nullable TContext context, boolean javaSpecifics, @Nullable Fallback<TContext> fallback, boolean omitDefaults, @Nullable StringCache keyCache, Iterable<Configuration> serializers) {
        this(new Settings<TContext>().withContext(context).withJavaConverters(javaSpecifics).fallbackTo(fallback).skipDefaultValues(omitDefaults).useKeyCache(keyCache).with(serializers));
    }

    public DslJson(Settings<TContext> settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings can't be null");
        }
        final DslJson self = this;
        this.localWriter = new ThreadLocal<JsonWriter>(){

            @Override
            protected JsonWriter initialValue() {
                return new JsonWriter(4096, (UnknownSerializer)self);
            }
        };
        this.localReader = new ThreadLocal<JsonReader>(){

            @Override
            protected JsonReader initialValue() {
                return new JsonReader(new byte[4096], 4096, self.context, new char[64], self.keyCache, self.valuesCache, (TypeLookup)self, self.errorInfo, self.doublePrecision, self.unknownNumbers, self.maxNumberDigits, self.maxStringSize);
            }
        };
        this.context = ((Settings)settings).context;
        this.fallback = ((Settings)settings).fallback;
        this.omitDefaults = ((Settings)settings).omitDefaults;
        this.allowArrayFormat = ((Settings)settings).allowArrayFormat;
        this.keyCache = ((Settings)settings).keyCache;
        this.valuesCache = ((Settings)settings).valuesCache;
        this.unknownNumbers = ((Settings)settings).unknownNumbers;
        this.errorInfo = ((Settings)settings).errorInfo;
        this.doublePrecision = ((Settings)settings).doublePrecision;
        this.maxNumberDigits = ((Settings)settings).maxNumberDigits;
        this.maxStringSize = ((Settings)settings).maxStringBuffer;
        this.writerFactories.addAll(((Settings)settings).writerFactories);
        this.settingsWriters = ((Settings)settings).writerFactories.size();
        this.readerFactories.addAll(((Settings)settings).readerFactories);
        this.settingsReaders = ((Settings)settings).readerFactories.size();
        this.binderFactories.addAll(((Settings)settings).binderFactories);
        this.settingsBinders = ((Settings)settings).binderFactories.size();
        this.externalConverterAnalyzer = new ExternalConverterAnalyzer(((Settings)settings).classLoaders);
        this.creatorMarkers = new HashMap<Class<? extends Annotation>, Boolean>(((Settings)settings).creatorMarkers);
        this.registerReader(byte[].class, BinaryConverter.Base64Reader);
        this.registerWriter(byte[].class, BinaryConverter.Base64Writer);
        this.registerReader(Boolean.TYPE, BoolConverter.READER);
        this.registerWriter(Boolean.TYPE, BoolConverter.WRITER);
        this.registerDefault(Boolean.TYPE, false);
        this.registerReader(boolean[].class, BoolConverter.ARRAY_READER);
        this.registerWriter(boolean[].class, BoolConverter.ARRAY_WRITER);
        this.registerReader(Boolean.class, BoolConverter.NULLABLE_READER);
        this.registerWriter(Boolean.class, BoolConverter.WRITER);
        if (((Settings)settings).javaSpecifics) {
            DslJson.registerJavaSpecifics(this);
        }
        this.registerReader(LinkedHashMap.class, ObjectConverter.MapReader);
        this.registerReader(HashMap.class, ObjectConverter.MapReader);
        this.registerReader(Map.class, ObjectConverter.MapReader);
        this.registerWriter(Map.class, new JsonWriter.WriteObject<Map>(){

            @Override
            public void write(JsonWriter writer, @Nullable Map value) {
                if (value == null) {
                    writer.writeNull();
                } else {
                    try {
                        DslJson.this.serializeMap(value, writer);
                    }
                    catch (IOException ex) {
                        throw new SerializationException(ex);
                    }
                }
            }
        });
        this.registerReader(URI.class, NetConverter.UriReader);
        this.registerWriter(URI.class, NetConverter.UriWriter);
        this.registerReader(InetAddress.class, NetConverter.AddressReader);
        this.registerWriter(InetAddress.class, NetConverter.AddressWriter);
        this.registerReader(Double.TYPE, NumberConverter.DOUBLE_READER);
        this.registerWriter(Double.TYPE, NumberConverter.DOUBLE_WRITER);
        this.registerDefault(Double.TYPE, 0.0);
        this.registerReader(double[].class, NumberConverter.DOUBLE_ARRAY_READER);
        this.registerWriter(double[].class, NumberConverter.DOUBLE_ARRAY_WRITER);
        this.registerReader(Double.class, NumberConverter.NULLABLE_DOUBLE_READER);
        this.registerWriter(Double.class, NumberConverter.DOUBLE_WRITER);
        this.registerReader(Float.TYPE, NumberConverter.FLOAT_READER);
        this.registerWriter(Float.TYPE, NumberConverter.FLOAT_WRITER);
        this.registerDefault(Float.TYPE, Float.valueOf(0.0f));
        this.registerReader(float[].class, NumberConverter.FLOAT_ARRAY_READER);
        this.registerWriter(float[].class, NumberConverter.FLOAT_ARRAY_WRITER);
        this.registerReader(Float.class, NumberConverter.NULLABLE_FLOAT_READER);
        this.registerWriter(Float.class, NumberConverter.FLOAT_WRITER);
        this.registerReader(Integer.TYPE, NumberConverter.INT_READER);
        this.registerWriter(Integer.TYPE, NumberConverter.INT_WRITER);
        this.registerDefault(Integer.TYPE, 0);
        this.registerReader(int[].class, NumberConverter.INT_ARRAY_READER);
        this.registerWriter(int[].class, NumberConverter.INT_ARRAY_WRITER);
        this.registerReader(Integer.class, NumberConverter.NULLABLE_INT_READER);
        this.registerWriter(Integer.class, NumberConverter.INT_WRITER);
        this.registerReader(Short.TYPE, NumberConverter.SHORT_READER);
        this.registerWriter(Short.TYPE, NumberConverter.SHORT_WRITER);
        this.registerDefault(Short.TYPE, (short)0);
        this.registerReader(short[].class, NumberConverter.SHORT_ARRAY_READER);
        this.registerWriter(short[].class, NumberConverter.SHORT_ARRAY_WRITER);
        this.registerReader(Short.class, NumberConverter.NULLABLE_SHORT_READER);
        this.registerWriter(Short.class, NumberConverter.SHORT_WRITER);
        this.registerReader(Long.TYPE, NumberConverter.LONG_READER);
        this.registerWriter(Long.TYPE, NumberConverter.LONG_WRITER);
        this.registerDefault(Long.TYPE, 0L);
        this.registerReader(long[].class, NumberConverter.LONG_ARRAY_READER);
        this.registerWriter(long[].class, NumberConverter.LONG_ARRAY_WRITER);
        this.registerReader(Long.class, NumberConverter.NULLABLE_LONG_READER);
        this.registerWriter(Long.class, NumberConverter.LONG_WRITER);
        this.registerReader(BigDecimal.class, NumberConverter.DecimalReader);
        this.registerWriter(BigDecimal.class, NumberConverter.DecimalWriter);
        this.registerReader(String.class, StringConverter.READER);
        this.registerWriter(String.class, StringConverter.WRITER);
        this.registerReader(UUID.class, UUIDConverter.READER);
        this.registerWriter(UUID.class, UUIDConverter.WRITER);
        this.registerReader(Number.class, NumberConverter.NumberReader);
        this.registerWriter(CharSequence.class, StringConverter.WRITER_CHARS);
        this.registerReader(StringBuilder.class, StringConverter.READER_BUILDER);
        this.registerReader(StringBuffer.class, StringConverter.READER_BUFFER);
        for (Configuration serializer : ((Settings)settings).configurations) {
            serializer.configure(this);
        }
        if (!((Settings)settings).classLoaders.isEmpty() && ((Settings)settings).fromServiceLoader == 0) {
            DslJson.loadDefaultConverters(this, ((Settings)settings).classLoaders, "dsl_json_Annotation_Processor_External_Serialization");
            DslJson.loadDefaultConverters(this, ((Settings)settings).classLoaders, "dsl_json.json.ExternalSerialization");
            DslJson.loadDefaultConverters(this, ((Settings)settings).classLoaders, "dsl_json_ExternalSerialization");
        }
    }

    public JsonWriter newWriter() {
        return new JsonWriter(this);
    }

    public JsonWriter newWriter(int size) {
        return new JsonWriter(size, (UnknownSerializer)this);
    }

    public JsonWriter newWriter(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("null value provided for buffer");
        }
        return new JsonWriter(buffer, (UnknownSerializer)this);
    }

    public JsonReader<TContext> newReader() {
        return new JsonReader<TContext>(new byte[4096], 4096, this.context, new char[64], this.keyCache, this.valuesCache, (TypeLookup)this, this.errorInfo, this.doublePrecision, this.unknownNumbers, this.maxNumberDigits, this.maxStringSize);
    }

    public JsonReader<TContext> newReader(byte[] bytes) {
        return new JsonReader<TContext>(bytes, bytes.length, this.context, new char[64], this.keyCache, this.valuesCache, (TypeLookup)this, this.errorInfo, this.doublePrecision, this.unknownNumbers, this.maxNumberDigits, this.maxStringSize);
    }

    public JsonReader<TContext> newReader(byte[] bytes, int length) {
        return new JsonReader<TContext>(bytes, length, this.context, new char[64], this.keyCache, this.valuesCache, (TypeLookup)this, this.errorInfo, this.doublePrecision, this.unknownNumbers, this.maxNumberDigits, this.maxStringSize);
    }

    public JsonReader<TContext> newReader(byte[] bytes, int length, char[] tmp) {
        return new JsonReader<TContext>(bytes, length, this.context, tmp, this.keyCache, this.valuesCache, (TypeLookup)this, this.errorInfo, this.doublePrecision, this.unknownNumbers, this.maxNumberDigits, this.maxStringSize);
    }

    public JsonReader<TContext> newReader(InputStream stream, byte[] buffer) throws IOException {
        JsonReader<TContext> reader = this.newReader(buffer);
        reader.process(stream);
        return reader;
    }

    @Deprecated
    public JsonReader<TContext> newReader(String input) {
        byte[] bytes = input.getBytes(UTF8);
        return new JsonReader<TContext>(bytes, bytes.length, this.context, new char[64], this.keyCache, this.valuesCache, (TypeLookup)this, this.errorInfo, this.doublePrecision, this.unknownNumbers, this.maxNumberDigits, this.maxStringSize);
    }

    private static void loadDefaultConverters(DslJson json, Set<ClassLoader> loaders, String name) {
        for (ClassLoader loader : loaders) {
            try {
                Class<?> external = loader.loadClass(name);
                Configuration instance = (Configuration)external.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance.configure(json);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {}
        }
    }

    static void registerJavaSpecifics(DslJson json) {
        json.registerReader(Element.class, XmlConverter.Reader);
        json.registerWriter(Element.class, XmlConverter.Writer);
    }

    public <T> void registerDefault(Class<T> manifest, T instance) {
        this.defaults.put(manifest, instance);
    }

    public boolean registerWriterFactory(ConverterFactory<? extends JsonWriter.WriteObject> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        if (this.writerFactories.contains(factory)) {
            return false;
        }
        this.writerFactories.add(this.writerFactories.size() - this.settingsWriters, factory);
        return true;
    }

    public boolean registerReaderFactory(ConverterFactory<? extends JsonReader.ReadObject> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        if (this.readerFactories.contains(factory)) {
            return false;
        }
        this.readerFactories.add(this.readerFactories.size() - this.settingsReaders, factory);
        return true;
    }

    public boolean registerBinderFactory(ConverterFactory<? extends JsonReader.BindObject> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        if (this.binderFactories.contains(factory)) {
            return false;
        }
        this.binderFactories.add(this.binderFactories.size() - this.settingsBinders, factory);
        return true;
    }

    @Nullable
    public final Object getDefault(@Nullable Type manifest) {
        Class rawType;
        if (manifest == null) {
            return null;
        }
        Object instance = this.defaults.get(manifest);
        if (instance != null) {
            return instance;
        }
        if (manifest instanceof Class) {
            rawType = (Class)manifest;
        } else if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            rawType = (Class)pt.getRawType();
        } else {
            return null;
        }
        if (rawType.isPrimitive()) {
            return Array.get(Array.newInstance(rawType, 1), 0);
        }
        return this.defaults.get(rawType);
    }

    public final Set<Type> getRegisteredDecoders() {
        return this.readers.keySet();
    }

    public final Set<Type> getRegisteredBinders() {
        return this.binders.keySet();
    }

    public final Set<Type> getRegisteredEncoders() {
        return this.writers.keySet();
    }

    public final Map<Class<? extends Annotation>, Boolean> getRegisteredCreatorMarkers() {
        return this.creatorMarkers;
    }

    public <T, S extends T> void registerReader(Class<T> manifest, @Nullable JsonReader.ReadObject<S> reader) {
        if (reader == null) {
            this.readers.remove(manifest);
        } else {
            this.readers.put(manifest, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JsonReader.ReadObject registerReader(Type manifest, @Nullable JsonReader.ReadObject<?> reader) {
        if (reader == null) {
            return (JsonReader.ReadObject)this.readers.remove(manifest);
        }
        try {
            JsonReader.ReadObject readObject = (JsonReader.ReadObject)this.readers.get(manifest);
            return readObject;
        }
        finally {
            this.readers.put(manifest, reader);
        }
    }

    public <T, S extends T> void registerBinder(Class<T> manifest, @Nullable JsonReader.BindObject<S> binder) {
        if (binder == null) {
            this.binders.remove(manifest);
        } else {
            this.binders.put(manifest, binder);
        }
    }

    public void registerBinder(Type manifest, @Nullable JsonReader.BindObject<?> binder) {
        if (binder == null) {
            this.binders.remove(manifest);
        } else {
            this.binders.put(manifest, binder);
        }
    }

    public <T> void registerWriter(Class<T> manifest, @Nullable JsonWriter.WriteObject<T> writer) {
        if (writer == null) {
            this.writerMap.remove(manifest);
            this.writers.remove(manifest);
        } else {
            this.writerMap.put(manifest, manifest);
            this.writers.put(manifest, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JsonWriter.WriteObject registerWriter(Type manifest, @Nullable JsonWriter.WriteObject<?> writer) {
        if (writer == null) {
            return (JsonWriter.WriteObject)this.writers.remove(manifest);
        }
        try {
            JsonWriter.WriteObject writeObject = (JsonWriter.WriteObject)this.writers.get(manifest);
            return writeObject;
        }
        finally {
            this.writers.put(manifest, writer);
        }
    }

    @Nullable
    public JsonWriter.WriteObject<?> tryFindWriter(Type manifest) {
        Class signature;
        JsonWriter.WriteObject writer = (JsonWriter.WriteObject)this.writers.get(manifest);
        if (writer != null) {
            return writer;
        }
        Type actualType = DslJson.extractActualType(manifest);
        if (actualType != manifest && (writer = (JsonWriter.WriteObject)this.writers.get(actualType)) != null) {
            this.writers.putIfAbsent(manifest, writer);
            return writer;
        }
        if (actualType instanceof Class && JsonObject.class.isAssignableFrom(signature = (Class)actualType)) {
            this.writers.putIfAbsent(manifest, this.OBJECT_WRITER);
            return this.OBJECT_WRITER;
        }
        writer = this.lookupFromFactories(manifest, actualType, this.writerFactories, this.writers);
        if (writer != null) {
            return writer;
        }
        if (!(actualType instanceof Class)) {
            return null;
        }
        Class found = (Class)this.writerMap.get(actualType);
        if (found != null) {
            return (JsonWriter.WriteObject)this.writers.get(found);
        }
        Class container = (Class)actualType;
        ArrayList signatures = new ArrayList();
        DslJson.findAllSignatures(container, signatures);
        for (Class<?> sig : signatures) {
            writer = (JsonWriter.WriteObject)this.writers.get(sig);
            if (writer == null) {
                writer = this.lookupFromFactories(manifest, sig, this.writerFactories, this.writers);
            }
            if (writer == null) continue;
            this.writerMap.putIfAbsent(container, sig);
            return writer;
        }
        return null;
    }

    private static Type extractActualType(Type manifest) {
        WildcardType wt;
        if (manifest instanceof WildcardType && (wt = (WildcardType)manifest).getUpperBounds().length == 1 && wt.getLowerBounds().length == 0) {
            return wt.getUpperBounds()[0];
        }
        return manifest;
    }

    private <T> void checkExternal(Type manifest, ConcurrentMap<Type, T> cache) {
        if (manifest instanceof Class) {
            this.externalConverterAnalyzer.tryFindConverter((Class)manifest, this);
        } else if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            Type container = pt.getRawType();
            this.externalConverterAnalyzer.tryFindConverter((Class)container, this);
            for (Type arg : pt.getActualTypeArguments()) {
                Type actualType;
                if (cache.containsKey(arg) || (actualType = DslJson.extractActualType(arg)) == arg || cache.containsKey(actualType)) continue;
                this.checkExternal(actualType, cache);
            }
        }
    }

    @Nullable
    private <T> T lookupFromFactories(Type signature, Type manifest, List<ConverterFactory<T>> factories, ConcurrentMap<Type, T> cache) {
        if (manifest instanceof Class) {
            this.externalConverterAnalyzer.tryFindConverter((Class)manifest, this);
            Object found = cache.get(manifest);
            if (found != null) {
                return (T)found;
            }
        } else if (manifest instanceof ParameterizedType) {
            this.checkExternal(manifest, cache);
        }
        for (ConverterFactory<T> wrt : factories) {
            T converter = wrt.tryCreate(manifest, this);
            if (converter == null) continue;
            cache.putIfAbsent(signature, converter);
            return converter;
        }
        return null;
    }

    @Nullable
    public JsonReader.ReadObject<?> tryFindReader(Type manifest) {
        JsonReader.ReadJsonObject<JsonObject> decoder;
        Class signature;
        JsonReader.ReadObject<JsonObject> found = (JsonReader.ReadObject<JsonObject>)this.readers.get(manifest);
        if (found != null) {
            return found;
        }
        Type actualType = DslJson.extractActualType(manifest);
        if (actualType != manifest && (found = (JsonReader.ReadObject)this.readers.get(actualType)) != null) {
            this.readers.putIfAbsent(manifest, found);
            return found;
        }
        if (actualType instanceof Class && JsonObject.class.isAssignableFrom(signature = (Class)actualType) && (decoder = this.getObjectReader(signature)) != null) {
            found = this.convertToReader(decoder);
            this.readers.putIfAbsent(manifest, found);
            return found;
        }
        return this.lookupFromFactories(manifest, actualType, this.readerFactories, this.readers);
    }

    @Nullable
    public JsonReader.BindObject<?> tryFindBinder(Type manifest) {
        JsonReader.BindObject found = (JsonReader.BindObject)this.binders.get(manifest);
        if (found != null) {
            return found;
        }
        Type actualType = DslJson.extractActualType(manifest);
        if (actualType != manifest && (found = (JsonReader.BindObject)this.binders.get(actualType)) != null) {
            this.binders.putIfAbsent(manifest, found);
            return found;
        }
        return this.lookupFromFactories(manifest, actualType, this.binderFactories, this.binders);
    }

    @Nullable
    public <T> JsonWriter.WriteObject<T> tryFindWriter(Class<T> manifest) {
        return this.tryFindWriter((Type)manifest);
    }

    @Override
    @Nullable
    public <T> JsonReader.ReadObject<T> tryFindReader(Class<T> manifest) {
        return this.tryFindReader((Type)manifest);
    }

    @Override
    @Nullable
    public <T> JsonReader.BindObject<T> tryFindBinder(Class<T> manifest) {
        return this.tryFindBinder((Type)manifest);
    }

    private static void findAllSignatures(Class<?> manifest, ArrayList<Class<?>> found) {
        if (found.contains(manifest)) {
            return;
        }
        found.add(manifest);
        Class<?> superClass = manifest.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            DslJson.findAllSignatures(superClass, found);
        }
        for (Class<?> iface : manifest.getInterfaces()) {
            DslJson.findAllSignatures(iface, found);
        }
    }

    @Nullable
    private JsonReader.ReadJsonObject<JsonObject> probeForObjectReader(Class<?> manifest, Object instance) {
        Object found;
        try {
            found = manifest.getField("JSON_READER").get(instance);
        }
        catch (Exception ignore) {
            try {
                found = manifest.getMethod("JSON_READER", new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Exception ignore2) {
                try {
                    found = manifest.getMethod("getJSON_READER", new Class[0]).invoke(instance, new Object[0]);
                }
                catch (Exception ignore3) {
                    return null;
                }
            }
        }
        return found instanceof JsonReader.ReadJsonObject ? (JsonReader.ReadJsonObject)found : null;
    }

    @Nullable
    protected final JsonReader.ReadJsonObject<JsonObject> getObjectReader(Class<?> manifest) {
        try {
            JsonReader.ReadJsonObject<JsonObject> reader = (JsonReader.ReadJsonObject<JsonObject>)this.objectReaders.get(manifest);
            if (reader == null) {
                reader = this.probeForObjectReader(manifest, null);
                if (reader == null) {
                    try {
                        Object companion = manifest.getField("Companion").get(null);
                        reader = this.probeForObjectReader(companion.getClass(), companion);
                    }
                    catch (Exception ignore) {
                        return null;
                    }
                }
                if (reader != null) {
                    this.objectReaders.putIfAbsent(manifest, reader);
                }
            }
            return reader;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void serializeMap(Map<String, Object> value, JsonWriter sw) throws IOException {
        sw.writeByte((byte)123);
        int size = value.size();
        if (size > 0) {
            Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
            Map.Entry<String, Object> kv = iterator.next();
            sw.writeString(kv.getKey());
            sw.writeByte((byte)58);
            this.serialize(sw, kv.getValue());
            for (int i = 1; i < size; ++i) {
                sw.writeByte((byte)44);
                kv = iterator.next();
                sw.writeString(kv.getKey());
                sw.writeByte((byte)58);
                this.serialize(sw, kv.getValue());
            }
        }
        sw.writeByte((byte)125);
    }

    @Deprecated
    @Nullable
    public static Object deserializeObject(JsonReader reader) throws IOException {
        return ObjectConverter.deserializeObject(reader);
    }

    @Deprecated
    public static ArrayList<Object> deserializeList(JsonReader reader) throws IOException {
        return ObjectConverter.deserializeList(reader);
    }

    @Deprecated
    public static LinkedHashMap<String, Object> deserializeMap(JsonReader reader) throws IOException {
        return ObjectConverter.deserializeMap(reader);
    }

    private static Object convertResultToArray(Class<?> elementType, List<?> result) {
        if (elementType.isPrimitive()) {
            if (Boolean.TYPE.equals(elementType)) {
                boolean[] array = new boolean[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Boolean)result.get(i);
                }
                return array;
            }
            if (Integer.TYPE.equals(elementType)) {
                int[] array = new int[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Integer)result.get(i);
                }
                return array;
            }
            if (Long.TYPE.equals(elementType)) {
                long[] array = new long[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Long)result.get(i);
                }
                return array;
            }
            if (Short.TYPE.equals(elementType)) {
                short[] array = new short[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Short)result.get(i);
                }
                return array;
            }
            if (Byte.TYPE.equals(elementType)) {
                byte[] array = new byte[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Byte)result.get(i);
                }
                return array;
            }
            if (Float.TYPE.equals(elementType)) {
                float[] array = new float[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = ((Float)result.get(i)).floatValue();
                }
                return array;
            }
            if (Double.TYPE.equals(elementType)) {
                double[] array = new double[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = (Double)result.get(i);
                }
                return array;
            }
            if (Character.TYPE.equals(elementType)) {
                char[] array = new char[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    array[i] = ((Character)result.get(i)).charValue();
                }
                return array;
            }
        }
        return result.toArray((Object[])Array.newInstance(elementType, 0));
    }

    public final boolean canSerialize(Type manifest) {
        JsonWriter.WriteObject writer = (JsonWriter.WriteObject)this.writers.get(manifest);
        if (writer != null) {
            return true;
        }
        if (manifest instanceof Class) {
            Class content = (Class)manifest;
            if (JsonObject.class.isAssignableFrom(content)) {
                return true;
            }
            if (JsonObject[].class.isAssignableFrom(content)) {
                return true;
            }
            if (this.tryFindWriter(manifest) != null) {
                return true;
            }
            if (content.isArray()) {
                return !content.getComponentType().isArray() && !Collection.class.isAssignableFrom(content.getComponentType()) && this.canSerialize(content.getComponentType());
            }
        }
        if (manifest instanceof ParameterizedType) {
            Class container;
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1 && ((container = (Class)pt.getRawType()).isArray() || Collection.class.isAssignableFrom(container))) {
                Type content = pt.getActualTypeArguments()[0];
                return content instanceof Class && JsonObject.class.isAssignableFrom((Class)content) || this.tryFindWriter(content) != null;
            }
        } else if (manifest instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)manifest;
            return gat.getGenericComponentType() instanceof Class && JsonObject.class.isAssignableFrom((Class)gat.getGenericComponentType()) || this.tryFindWriter(gat.getGenericComponentType()) != null;
        }
        for (ConverterFactory<JsonWriter.WriteObject> wrt : this.writerFactories) {
            if (wrt.tryCreate(manifest, this) == null) continue;
            return true;
        }
        return false;
    }

    public final boolean canDeserialize(Type manifest) {
        Class objectType;
        if (this.tryFindReader(manifest) != null) {
            return true;
        }
        if (manifest instanceof Class && (objectType = (Class)manifest).isArray()) {
            return !objectType.getComponentType().isArray() && !Collection.class.isAssignableFrom(objectType.getComponentType()) && this.canDeserialize(objectType.getComponentType());
        }
        if (manifest instanceof ParameterizedType) {
            Type content;
            Class container;
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1 && ((container = (Class)pt.getRawType()).isArray() || Collection.class.isAssignableFrom(container)) && this.tryFindReader(content = pt.getActualTypeArguments()[0]) != null) {
                return true;
            }
        } else if (manifest instanceof GenericArrayType) {
            Type content = ((GenericArrayType)manifest).getGenericComponentType();
            return this.tryFindReader(content) != null;
        }
        return false;
    }

    @Nullable
    public <T> T deserialize(JsonReader.ReadObject<T> converter, JsonReader<TContext> input) throws IOException {
        if (converter == null) {
            throw new IllegalArgumentException("converter can't be null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input can't be null");
        }
        input.getNextToken();
        return converter.read(input);
    }

    @Nullable
    public <TResult> TResult deserialize(Class<TResult> manifest, byte[] body, int size) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body can't be null");
        }
        JsonReader json = this.localReader.get().process(body, size);
        try {
            json.getNextToken();
            JsonReader.ReadObject<TResult> simpleReader = this.tryFindReader(manifest);
            if (simpleReader != null) {
                TResult TResult = simpleReader.read(json);
                return TResult;
            }
            if (manifest.isArray()) {
                if (json.wasNull()) {
                    TResult TResult = null;
                    return TResult;
                }
                if (json.last() != 91) {
                    throw json.newParseError("Expecting '[' for array start");
                }
                Class<?> elementManifest = manifest.getComponentType();
                List<?> list = this.deserializeList(elementManifest, body, size);
                if (list == null) {
                    TResult TResult = null;
                    return TResult;
                }
                Object object = DslJson.convertResultToArray(elementManifest, list);
                return (TResult)object;
            }
            if (this.fallback != null) {
                Object object = this.fallback.deserialize(this.context, manifest, body, size);
                return (TResult)object;
            }
            throw this.createErrorMessage(manifest);
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    public Object deserialize(Type manifest, byte[] body, int size) throws IOException {
        if (manifest instanceof Class) {
            return this.deserialize((Class)manifest, body, size);
        }
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body can't be null");
        }
        JsonReader json = this.localReader.get().process(body, size);
        try {
            json.getNextToken();
            Object result = this.deserializeWith(manifest, json);
            if (result != unknownValue) {
                Object object = result;
                return object;
            }
            if (this.fallback != null) {
                Object object = this.fallback.deserialize(this.context, manifest, body, size);
                return object;
            }
            throw new ConfigurationException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\nTry initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    protected Object deserializeWith(Type manifest, JsonReader json) throws IOException {
        JsonReader.ReadObject<?> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return simpleReader.read(json);
        }
        if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            if (pt.getActualTypeArguments().length == 1) {
                Type content = pt.getActualTypeArguments()[0];
                Class container = (Class)pt.getRawType();
                if (container.isArray() || Collection.class.isAssignableFrom(container)) {
                    if (json.wasNull()) {
                        return null;
                    }
                    if (json.last() != 91) {
                        throw json.newParseError("Expecting '[' for array start");
                    }
                    if (json.getNextToken() == 93) {
                        if (container.isArray()) {
                            DslJson.returnEmptyArray(content);
                        }
                        return new ArrayList(0);
                    }
                    JsonReader.ReadObject<?> contentReader = this.tryFindReader(content);
                    if (contentReader != null) {
                        ArrayList result = json.deserializeNullableCollectionCustom(contentReader);
                        if (container.isArray()) {
                            return DslJson.returnAsArray(content, result);
                        }
                        return result;
                    }
                }
            }
        } else if (manifest instanceof GenericArrayType) {
            if (json.wasNull()) {
                return null;
            }
            if (json.last() != 91) {
                throw json.newParseError("Expecting '[' for array start");
            }
            Type content = ((GenericArrayType)manifest).getGenericComponentType();
            if (json.getNextToken() == 93) {
                return DslJson.returnEmptyArray(content);
            }
            JsonReader.ReadObject<?> contentReader = this.tryFindReader(content);
            if (contentReader != null) {
                ArrayList result = json.deserializeNullableCollectionCustom(contentReader);
                return DslJson.returnAsArray(content, result);
            }
        }
        return unknownValue;
    }

    private static Object returnAsArray(Type content, ArrayList<?> result) {
        if (content instanceof Class) {
            return DslJson.convertResultToArray((Class)content, result);
        }
        if (content instanceof ParameterizedType) {
            ParameterizedType cpt = (ParameterizedType)content;
            return result.toArray((Object[])Array.newInstance((Class)cpt.getRawType(), 0));
        }
        return result.toArray();
    }

    private static Object returnEmptyArray(Type content) {
        if (content instanceof Class) {
            return Array.newInstance((Class)content, 0);
        }
        if (content instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)content;
            return Array.newInstance((Class)pt.getRawType(), 0);
        }
        return new Object[0];
    }

    protected IOException createErrorMessage(Class<?> manifest) {
        ArrayList signatures = new ArrayList();
        DslJson.findAllSignatures(manifest, signatures);
        for (Class<?> sig : signatures) {
            if (!this.readers.containsKey(sig)) continue;
            if (sig.equals(manifest)) {
                return new IOException("Reader for provided type: " + manifest + " is disabled and fallback serialization is not registered (converter is registered as null).\nTry initializing system with custom fallback or don't register null for " + manifest);
            }
            return new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\nFound reader for: " + sig + " so try deserializing into that instead?\nAlternatively, try initializing system with custom fallback or register specified type using registerReader into " + this.getClass());
        }
        return new IOException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\nTry initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
    }

    @Nullable
    public <TResult> List<TResult> deserializeList(Class<TResult> manifest, byte[] body, int size) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("body can't be null");
        }
        if (size == 4 && body[0] == 110 && body[1] == 117 && body[2] == 108 && body[3] == 108) {
            return null;
        }
        if (size == 2 && body[0] == 91 && body[1] == 93) {
            return new ArrayList(0);
        }
        JsonReader json = this.localReader.get().process(body, size);
        try {
            JsonReader.ReadJsonObject<JsonObject> reader;
            if (json.getNextToken() != 91) {
                if (json.wasNull()) {
                    List<TResult> list = null;
                    return list;
                }
                throw json.newParseError("Expecting '[' for list start");
            }
            if (json.getNextToken() == 93) {
                ArrayList arrayList = new ArrayList(0);
                return arrayList;
            }
            if (JsonObject.class.isAssignableFrom(manifest) && (reader = this.getObjectReader(manifest)) != null) {
                ArrayList<JsonObject> arrayList = json.deserializeNullableCollection(reader);
                return arrayList;
            }
            JsonReader.ReadObject<TResult> simpleReader = this.tryFindReader(manifest);
            if (simpleReader != null) {
                ArrayList arrayList = json.deserializeNullableCollectionCustom(simpleReader);
                return arrayList;
            }
            if (this.fallback != null) {
                Object array = Array.newInstance(manifest, 0);
                Object[] result = (Object[])this.fallback.deserialize(this.context, array.getClass(), body, size);
                if (result == null) {
                    List<TResult> list = null;
                    return list;
                }
                ArrayList<Object> list = new ArrayList<Object>(result.length);
                for (Object aResult : result) {
                    list.add(aResult);
                }
                ArrayList<Object> arrayList = list;
                return arrayList;
            }
            throw this.createErrorMessage(manifest);
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    public <TResult> List<TResult> deserializeList(Class<TResult> manifest, InputStream stream, byte[] buffer) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        return this.deserializeList(manifest, this.newReader(stream, buffer), stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <TResult> List<TResult> deserializeList(Class<TResult> manifest, InputStream stream) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        JsonReader json = this.localReader.get().process(stream);
        try {
            List<TResult> list = this.deserializeList(manifest, json, stream);
            return list;
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    protected <TResult> List<TResult> deserializeList(Class<TResult> manifest, JsonReader<TContext> json, InputStream stream) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> reader;
        if (json.getNextToken() != 91) {
            if (json.wasNull()) {
                return null;
            }
            throw json.newParseError("Expecting '[' for list start");
        }
        if (json.getNextToken() == 93) {
            return new ArrayList(0);
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (reader = this.getObjectReader(manifest)) != null) {
            return json.deserializeNullableCollection(reader);
        }
        JsonReader.ReadObject<TResult> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return json.deserializeNullableCollectionCustom(simpleReader);
        }
        if (this.fallback != null) {
            Object array = Array.newInstance(manifest, 0);
            Object[] result = (Object[])this.fallback.deserialize(this.context, array.getClass(), new RereadStream(json.buffer, stream));
            if (result == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>(result.length);
            for (Object aResult : result) {
                list.add(aResult);
            }
            return list;
        }
        throw this.createErrorMessage(manifest);
    }

    @Nullable
    public <TResult> TResult deserialize(Class<TResult> manifest, InputStream stream, byte[] buffer) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        return this.deserialize(manifest, this.newReader(stream, buffer), stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <TResult> TResult deserialize(Class<TResult> manifest, InputStream stream) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        JsonReader json = this.localReader.get().process(stream);
        try {
            TResult TResult = this.deserialize(manifest, json, stream);
            return TResult;
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    protected <TResult> TResult deserialize(Class<TResult> manifest, JsonReader json, InputStream stream) throws IOException {
        json.getNextToken();
        JsonReader.ReadObject<TResult> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return simpleReader.read(json);
        }
        if (manifest.isArray()) {
            JsonReader.ReadJsonObject<JsonObject> objectReader;
            if (json.wasNull()) {
                return null;
            }
            if (json.last() != 91) {
                throw json.newParseError("Expecting '[' for array start");
            }
            Class<?> elementManifest = manifest.getComponentType();
            if (json.getNextToken() == 93) {
                return (TResult)Array.newInstance(elementManifest, 0);
            }
            if (JsonObject.class.isAssignableFrom(elementManifest) && (objectReader = this.getObjectReader(elementManifest)) != null) {
                ArrayList<JsonObject> list = json.deserializeNullableCollection(objectReader);
                return (TResult)DslJson.convertResultToArray(elementManifest, list);
            }
            JsonReader.ReadObject<?> simpleElementReader = this.tryFindReader(elementManifest);
            if (simpleElementReader != null) {
                ArrayList list = json.deserializeNullableCollectionCustom(simpleElementReader);
                return (TResult)DslJson.convertResultToArray(elementManifest, list);
            }
        }
        if (this.fallback != null) {
            return (TResult)this.fallback.deserialize(this.context, manifest, new RereadStream(json.buffer, stream));
        }
        throw this.createErrorMessage(manifest);
    }

    @Nullable
    public Object deserialize(Type manifest, InputStream stream, byte[] buffer) throws IOException {
        if (manifest instanceof Class) {
            return this.deserialize((Class)manifest, stream, buffer);
        }
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        JsonReader<TContext> json = this.newReader(stream, buffer);
        json.getNextToken();
        Object result = this.deserializeWith(manifest, json);
        if (result != unknownValue) {
            return result;
        }
        if (this.fallback != null) {
            return this.fallback.deserialize(this.context, manifest, new RereadStream(buffer, stream));
        }
        throw new ConfigurationException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\nTry initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
    }

    @Nullable
    public Object deserialize(Type manifest, InputStream stream) throws IOException {
        if (manifest instanceof Class) {
            return this.deserialize((Class)manifest, stream);
        }
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        JsonReader json = this.localReader.get().process(stream);
        try {
            json.getNextToken();
            Object result = this.deserializeWith(manifest, json);
            if (result != unknownValue) {
                Object object = result;
                return object;
            }
            if (this.fallback != null) {
                Object object = this.fallback.deserialize(this.context, manifest, new RereadStream(json.buffer, stream));
                return object;
            }
            throw new ConfigurationException("Unable to find reader for provided type: " + manifest + " and fallback serialization is not registered.\nTry initializing DslJson with custom fallback in case of unsupported objects or register specified type using registerReader into " + this.getClass());
        }
        finally {
            json.reset();
        }
    }

    @Nullable
    public <TResult> Iterator<TResult> iterateOver(Class<TResult> manifest, InputStream stream) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        JsonReader json = this.localReader.get();
        json.process(stream);
        return this.iterateOver(manifest, json, stream);
    }

    @Nullable
    public <TResult> Iterator<TResult> iterateOver(Class<TResult> manifest, InputStream stream, byte[] buffer) throws IOException {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        return this.iterateOver(manifest, this.newReader(stream, buffer), stream);
    }

    @Nullable
    protected <TResult> Iterator<TResult> iterateOver(Class<TResult> manifest, JsonReader json, InputStream stream) throws IOException {
        JsonReader.ReadJsonObject<JsonObject> reader;
        if (json.getNextToken() != 91) {
            if (json.wasNull()) {
                return null;
            }
            throw json.newParseError("Expecting '[' for iterator start");
        }
        if (json.getNextToken() == 93) {
            return EMPTY_ITERATOR;
        }
        if (JsonObject.class.isAssignableFrom(manifest) && (reader = this.getObjectReader(manifest)) != null) {
            return json.iterateOver(reader);
        }
        JsonReader.ReadObject<TResult> simpleReader = this.tryFindReader(manifest);
        if (simpleReader != null) {
            return json.iterateOverCustom(simpleReader);
        }
        if (this.fallback != null) {
            Object array = Array.newInstance(manifest, 0);
            Object[] result = (Object[])this.fallback.deserialize(this.context, array.getClass(), new RereadStream(json.buffer, stream));
            if (result == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>(result.length);
            for (Object aResult : result) {
                list.add(aResult);
            }
            return list.iterator();
        }
        throw this.createErrorMessage(manifest);
    }

    private <T extends JsonObject> JsonReader.ReadObject<T> convertToReader(final JsonReader.ReadJsonObject<T> decoder) {
        return new JsonReader.ReadObject<T>(){

            @Override
            public T read(JsonReader reader) throws IOException {
                if (reader.wasNull()) {
                    return null;
                }
                if (reader.last() != 123) {
                    throw reader.newParseError("Expecting '{' for object start");
                }
                reader.getNextToken();
                return decoder.deserialize(reader);
            }
        };
    }

    private JsonWriter.WriteObject getOrCreateWriter(@Nullable Object instance, Class<?> instanceManifest) throws IOException {
        Class<?> manifest;
        if (instance instanceof JsonObject) {
            return this.OBJECT_WRITER;
        }
        if (instance instanceof JsonObject[]) {
            return this.OBJECT_ARRAY_WRITER;
        }
        Class<?> clazz = manifest = instanceManifest != null ? instanceManifest : instance.getClass();
        if (instanceManifest != null && JsonObject.class.isAssignableFrom(manifest)) {
            return this.OBJECT_WRITER;
        }
        JsonWriter.WriteObject<?> simpleWriter = this.tryFindWriter(manifest);
        if (simpleWriter != null) {
            return simpleWriter;
        }
        if (manifest.isArray()) {
            Class<?> elementManifest = manifest.getComponentType();
            if (Character.TYPE == elementManifest) {
                return CHAR_ARRAY_WRITER;
            }
            final JsonWriter.WriteObject<?> elementWriter = this.tryFindWriter(elementManifest);
            if (elementWriter != null) {
                return new JsonWriter.WriteObject(){

                    public void write(JsonWriter writer, @Nullable Object value) {
                        writer.serialize((Object[])value, elementWriter);
                    }
                };
            }
        }
        if (instance instanceof Collection || Collection.class.isAssignableFrom(manifest)) {
            return new JsonWriter.WriteObject(){

                public void write(JsonWriter writer, @Nullable Object value) {
                    Collection items = (Collection)value;
                    Class<?> baseType = null;
                    Iterator iterator = items.iterator();
                    do {
                        Class<?> elementType;
                        Object item;
                        if ((item = iterator.next()) == null || (elementType = item.getClass()) == baseType || baseType != null && !elementType.isAssignableFrom(baseType)) continue;
                        baseType = elementType;
                    } while (iterator.hasNext());
                    if (baseType == null) {
                        writer.writeByte((byte)91);
                        writer.writeNull();
                        for (int i = 1; i < items.size(); ++i) {
                            writer.writeAscii(",null");
                        }
                        writer.writeByte((byte)93);
                    } else if (JsonObject.class.isAssignableFrom(baseType)) {
                        DslJson.this.serialize(writer, items);
                    } else {
                        JsonWriter.WriteObject<?> elementWriter = DslJson.this.tryFindWriter(baseType);
                        if (elementWriter != null) {
                            writer.serialize(items, elementWriter);
                        } else if (DslJson.this.fallback != null) {
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            stream.reset();
                            try {
                                DslJson.this.fallback.serialize(value, stream);
                            }
                            catch (IOException ex) {
                                throw new SerializationException(ex);
                            }
                            writer.writeAscii(stream.toByteArray());
                        } else {
                            throw new ConfigurationException("Unable to serialize provided object. Failed to find serializer for: " + items.getClass());
                        }
                    }
                }
            };
        }
        throw new ConfigurationException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
    }

    public <T> void iterateOver(Iterator<T> iterator, OutputStream stream, @Nullable JsonWriter writer) throws IOException {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        stream.write(91);
        if (!iterator.hasNext()) {
            stream.write(93);
            return;
        }
        JsonWriter buffer = writer == null ? new JsonWriter(this) : writer;
        T item = iterator.next();
        Class<?> lastManifest = null;
        JsonWriter.WriteObject lastWriter = null;
        if (item != null) {
            lastManifest = item.getClass();
            lastWriter = this.getOrCreateWriter(item, lastManifest);
            buffer.reset();
            try {
                lastWriter.write(buffer, item);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            buffer.toStream(stream);
        } else {
            stream.write(NULL);
        }
        while (iterator.hasNext()) {
            stream.write(44);
            item = iterator.next();
            if (item != null) {
                Class<?> currentManifest = item.getClass();
                if (lastWriter == null || lastManifest == null || !lastManifest.equals(currentManifest)) {
                    lastManifest = currentManifest;
                    lastWriter = this.getOrCreateWriter(item, lastManifest);
                }
                buffer.reset();
                try {
                    lastWriter.write(buffer, item);
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                buffer.toStream(stream);
                continue;
            }
            stream.write(NULL);
        }
        stream.write(93);
    }

    public <T> void iterateOver(Iterator<T> iterator, Class<T> manifest, OutputStream stream, @Nullable JsonWriter writer) throws IOException {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator can't be null");
        }
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        JsonWriter buffer = writer == null ? new JsonWriter(this) : writer;
        JsonWriter.WriteObject instanceWriter = this.getOrCreateWriter(null, manifest);
        stream.write(91);
        T item = iterator.next();
        if (item != null) {
            buffer.reset();
            try {
                instanceWriter.write(buffer, item);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            buffer.toStream(stream);
        } else {
            stream.write(NULL);
        }
        while (iterator.hasNext()) {
            stream.write(44);
            item = iterator.next();
            if (item != null) {
                buffer.reset();
                try {
                    instanceWriter.write(buffer, item);
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                buffer.toStream(stream);
                continue;
            }
            stream.write(NULL);
        }
        stream.write(93);
    }

    @Deprecated
    public <T extends JsonObject> void serialize(JsonWriter writer, @Nullable T[] array) {
        if (array == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (array.length != 0) {
            T item = array[0];
            if (item != null) {
                item.serialize(writer, this.omitDefaults);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < array.length; ++i) {
                writer.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    item.serialize(writer, this.omitDefaults);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    @Deprecated
    public <T extends JsonObject> void serialize(JsonWriter writer, T[] array, int len) {
        if (writer == null) {
            throw new IllegalArgumentException("writer can't be null");
        }
        if (array == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (len != 0) {
            T item = array[0];
            if (item != null) {
                item.serialize(writer, this.omitDefaults);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < len; ++i) {
                writer.writeByte((byte)44);
                item = array[i];
                if (item != null) {
                    item.serialize(writer, this.omitDefaults);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    @Deprecated
    public <T extends JsonObject> void serialize(JsonWriter writer, @Nullable List<T> list) {
        if (writer == null) {
            throw new IllegalArgumentException("writer can't be null");
        }
        if (list == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (list.size() != 0) {
            JsonObject item = (JsonObject)list.get(0);
            if (item != null) {
                item.serialize(writer, this.omitDefaults);
            } else {
                writer.writeNull();
            }
            for (int i = 1; i < list.size(); ++i) {
                writer.writeByte((byte)44);
                item = (JsonObject)list.get(i);
                if (item != null) {
                    item.serialize(writer, this.omitDefaults);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    @Deprecated
    public <T extends JsonObject> void serialize(JsonWriter writer, @Nullable Collection<T> collection) {
        if (writer == null) {
            throw new IllegalArgumentException("writer can't be null");
        }
        if (collection == null) {
            writer.writeNull();
            return;
        }
        writer.writeByte((byte)91);
        if (!collection.isEmpty()) {
            Iterator<T> it = collection.iterator();
            JsonObject item = (JsonObject)it.next();
            if (item != null) {
                item.serialize(writer, this.omitDefaults);
            } else {
                writer.writeNull();
            }
            while (it.hasNext()) {
                writer.writeByte((byte)44);
                item = (JsonObject)it.next();
                if (item != null) {
                    item.serialize(writer, this.omitDefaults);
                    continue;
                }
                writer.writeNull();
            }
        }
        writer.writeByte((byte)93);
    }

    public boolean serialize(JsonWriter writer, Type manifest, @Nullable Object value) {
        try {
            if (writer == null) {
                throw new IllegalArgumentException("writer can't be null");
            }
            if (value == null) {
                writer.writeNull();
                return true;
            }
            if (value instanceof JsonObject) {
                ((JsonObject)value).serialize(writer, this.omitDefaults);
                return true;
            }
            if (value instanceof JsonObject[]) {
                this.serialize(writer, (JsonObject[])value);
                return true;
            }
            JsonWriter.WriteObject<?> simpleWriter = this.tryFindWriter(manifest);
            if (simpleWriter != null) {
                simpleWriter.write(writer, value);
                return true;
            }
            Class container = null;
            if (manifest instanceof Class) {
                container = (Class)manifest;
            }
            if (container != null && container.isArray()) {
                if (Array.getLength(value) == 0) {
                    writer.writeAscii("[]");
                    return true;
                }
                Class<?> elementManifest = container.getComponentType();
                if (Character.TYPE == elementManifest) {
                    StringConverter.serialize(new String((char[])value), writer);
                    return true;
                }
                JsonWriter.WriteObject<?> elementWriter = this.tryFindWriter(elementManifest);
                if (elementWriter != null) {
                    writer.serialize((Object[])value, elementWriter);
                    return true;
                }
            }
            if (value instanceof Collection) {
                Iterator iter;
                Collection items = (Collection)value;
                if (items.isEmpty()) {
                    writer.writeAscii("[]");
                    return true;
                }
                Class<?> baseType = null;
                Iterator iterator = items.iterator();
                boolean isList = items instanceof List;
                List values = isList ? (List)items : new ArrayList();
                ArrayList<JsonWriter.WriteObject> itemWriters = new ArrayList<JsonWriter.WriteObject>();
                Class<?> lastElementType = null;
                JsonWriter.WriteObject<?> lastWriter = null;
                boolean hasUnknownWriter = false;
                do {
                    Object item = iterator.next();
                    if (!isList) {
                        values.add(item);
                    }
                    if (item != null) {
                        Class<?> elementType = item.getClass();
                        if (elementType != baseType && (baseType == null || elementType.isAssignableFrom(baseType))) {
                            baseType = elementType;
                        }
                        if (lastElementType != elementType) {
                            lastElementType = elementType;
                            lastWriter = this.tryFindWriter(elementType);
                        }
                        itemWriters.add(lastWriter);
                        hasUnknownWriter = hasUnknownWriter || lastWriter == null;
                        continue;
                    }
                    itemWriters.add(this.NULL_WRITER);
                } while (iterator.hasNext());
                if (baseType != null && JsonObject.class.isAssignableFrom(baseType)) {
                    writer.writeByte((byte)91);
                    iter = values.iterator();
                    JsonObject first = (JsonObject)iter.next();
                    if (first != null) {
                        first.serialize(writer, this.omitDefaults);
                    } else {
                        writer.writeNull();
                    }
                    while (iter.hasNext()) {
                        writer.writeByte((byte)44);
                        JsonObject next = (JsonObject)iter.next();
                        if (next != null) {
                            next.serialize(writer, this.omitDefaults);
                            continue;
                        }
                        writer.writeNull();
                    }
                    writer.writeByte((byte)93);
                    return true;
                }
                if (!hasUnknownWriter) {
                    writer.writeByte((byte)91);
                    iter = values.iterator();
                    int cur = 1;
                    ((JsonWriter.WriteObject)itemWriters.get(0)).write(writer, iter.next());
                    while (iter.hasNext()) {
                        writer.writeByte((byte)44);
                        ((JsonWriter.WriteObject)itemWriters.get(cur++)).write(writer, iter.next());
                    }
                    writer.writeByte((byte)93);
                    return true;
                }
                JsonWriter.WriteObject<?> elementWriter = this.tryFindWriter(baseType);
                if (elementWriter != null) {
                    writer.serialize(items, elementWriter);
                    return true;
                }
            }
            return false;
        }
        catch (ClassCastException exc) {
            return false;
        }
    }

    public final void serialize(@Nullable Object value, OutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream can't be null");
        }
        if (value == null) {
            stream.write(NULL);
            return;
        }
        JsonWriter jw = this.localWriter.get();
        jw.reset(stream);
        Class<?> manifest = value.getClass();
        if (!this.serialize(jw, manifest, value)) {
            if (this.fallback == null) {
                throw new ConfigurationException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
            }
            this.fallback.serialize(value, stream);
        } else {
            jw.flush();
            jw.reset(null);
        }
    }

    @Override
    public final void serialize(JsonWriter writer, @Nullable Object value) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("writer can't be null");
        }
        if (value == null) {
            writer.writeNull();
            return;
        }
        Class<?> manifest = value.getClass();
        if (!this.serialize(writer, manifest, value)) {
            if (this.fallback == null) {
                throw new ConfigurationException("Unable to serialize provided object. Failed to find serializer for: " + manifest);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.fallback.serialize(value, stream);
            writer.writeAscii(stream.toByteArray());
        }
    }

    static class RereadStream
    extends InputStream {
        private final byte[] buffer;
        private final InputStream stream;
        private boolean usingBuffer;
        private int position;

        RereadStream(byte[] buffer, InputStream stream) {
            this.buffer = buffer;
            this.stream = stream;
            this.usingBuffer = true;
        }

        @Override
        public int read() throws IOException {
            if (this.usingBuffer) {
                if (this.position < this.buffer.length) {
                    return this.buffer[this.position++];
                }
                this.usingBuffer = false;
            }
            return this.stream.read();
        }

        @Override
        public int read(byte[] buf) throws IOException {
            if (this.usingBuffer) {
                return super.read(buf);
            }
            return this.stream.read(buf);
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.usingBuffer) {
                return super.read(buf, off, len);
            }
            return this.stream.read(buf, off, len);
        }
    }

    public static class SimpleStringCache
    implements StringCache {
        private final int mask;
        private final String[] cache;

        public SimpleStringCache() {
            this(10);
        }

        public SimpleStringCache(int log2Size) {
            int size = 2;
            for (int i = 1; i < log2Size; ++i) {
                size *= 2;
            }
            this.mask = size - 1;
            this.cache = new String[size];
        }

        @Override
        public String get(char[] chars, int len) {
            long hash = -2128831035L;
            for (int i = 0; i < len; ++i) {
                hash ^= (long)((byte)chars[i]);
                hash *= 16777619L;
            }
            int index = (int)hash & this.mask;
            String value = this.cache[index];
            if (value == null) {
                return this.createAndPut(index, chars, len);
            }
            if (value.length() != len) {
                return this.createAndPut(index, chars, len);
            }
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == chars[i]) continue;
                return this.createAndPut(index, chars, len);
            }
            return value;
        }

        private String createAndPut(int index, char[] chars, int len) {
            String value;
            this.cache[index] = value = new String(chars, 0, len);
            return value;
        }
    }

    public static class Settings<TContext> {
        private TContext context;
        private boolean javaSpecifics;
        private Fallback<TContext> fallback;
        private boolean omitDefaults;
        private boolean allowArrayFormat;
        private StringCache keyCache = new SimpleStringCache();
        private StringCache valuesCache;
        private int fromServiceLoader;
        private JsonReader.ErrorInfo errorInfo = JsonReader.ErrorInfo.WITH_STACK_TRACE;
        private JsonReader.DoublePrecision doublePrecision = JsonReader.DoublePrecision.DEFAULT;
        private JsonReader.UnknownNumberParsing unknownNumbers = JsonReader.UnknownNumberParsing.LONG_AND_BIGDECIMAL;
        private int maxNumberDigits = 512;
        private int maxStringBuffer = 0x8000000;
        private final List<Configuration> configurations = new ArrayList<Configuration>();
        private final List<ConverterFactory<JsonWriter.WriteObject>> writerFactories = new ArrayList<ConverterFactory<JsonWriter.WriteObject>>();
        private final List<ConverterFactory<JsonReader.ReadObject>> readerFactories = new ArrayList<ConverterFactory<JsonReader.ReadObject>>();
        private final List<ConverterFactory<JsonReader.BindObject>> binderFactories = new ArrayList<ConverterFactory<JsonReader.BindObject>>();
        private final Set<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        private final Map<Class<? extends Annotation>, Boolean> creatorMarkers = new HashMap<Class<? extends Annotation>, Boolean>();

        public Settings<TContext> withContext(@Nullable TContext context) {
            this.context = context;
            return this;
        }

        public Settings<TContext> withJavaConverters(boolean javaSpecifics) {
            this.javaSpecifics = javaSpecifics;
            return this;
        }

        @Deprecated
        public Settings<TContext> fallbackTo(@Nullable Fallback<TContext> fallback) {
            this.fallback = fallback;
            return this;
        }

        public Settings<TContext> skipDefaultValues(boolean omitDefaults) {
            this.omitDefaults = omitDefaults;
            return this;
        }

        public Settings<TContext> allowArrayFormat(boolean allowArrayFormat) {
            this.allowArrayFormat = allowArrayFormat;
            return this;
        }

        public Settings<TContext> useKeyCache(@Nullable StringCache keyCache) {
            this.keyCache = keyCache;
            return this;
        }

        public Settings<TContext> useStringValuesCache(@Nullable StringCache valuesCache) {
            this.valuesCache = valuesCache;
            return this;
        }

        public Settings<TContext> resolveWriter(ConverterFactory<? extends JsonWriter.WriteObject> writer) {
            if (writer == null) {
                throw new IllegalArgumentException("writer can't be null");
            }
            if (this.writerFactories.contains(writer)) {
                throw new IllegalArgumentException("writer already registered");
            }
            this.writerFactories.add(writer);
            return this;
        }

        public Settings<TContext> resolveReader(ConverterFactory<? extends JsonReader.ReadObject> reader) {
            if (reader == null) {
                throw new IllegalArgumentException("reader can't be null");
            }
            if (this.readerFactories.contains(reader)) {
                throw new IllegalArgumentException("reader already registered");
            }
            this.readerFactories.add(reader);
            return this;
        }

        public Settings<TContext> resolveBinder(ConverterFactory<? extends JsonReader.BindObject> binder) {
            if (binder == null) {
                throw new IllegalArgumentException("binder can't be null");
            }
            if (this.binderFactories.contains(binder)) {
                throw new IllegalArgumentException("binder already registered");
            }
            this.binderFactories.add(binder);
            return this;
        }

        public Settings<TContext> includeServiceLoader() {
            return this.includeServiceLoader(Thread.currentThread().getContextClassLoader());
        }

        public Settings<TContext> includeServiceLoader(ClassLoader loader) {
            if (loader == null) {
                throw new IllegalArgumentException("loader can't be null");
            }
            this.classLoaders.add(loader);
            for (Configuration c : ServiceLoader.load(Configuration.class, loader)) {
                boolean hasConfiguration = false;
                Class<?> manifest = c.getClass();
                for (Configuration cur : this.configurations) {
                    if (cur.getClass() != manifest) continue;
                    hasConfiguration = true;
                    break;
                }
                if (hasConfiguration) continue;
                ++this.fromServiceLoader;
                this.configurations.add(c);
            }
            return this;
        }

        public Settings<TContext> errorInfo(JsonReader.ErrorInfo errorInfo) {
            if (errorInfo == null) {
                throw new IllegalArgumentException("errorInfo can't be null");
            }
            this.errorInfo = errorInfo;
            return this;
        }

        public Settings<TContext> doublePrecision(JsonReader.DoublePrecision precision) {
            if (precision == null) {
                throw new IllegalArgumentException("precision can't be null");
            }
            this.doublePrecision = precision;
            return this;
        }

        public Settings<TContext> unknownNumbers(JsonReader.UnknownNumberParsing unknownNumbers) {
            if (unknownNumbers == null) {
                throw new IllegalArgumentException("unknownNumbers can't be null");
            }
            this.unknownNumbers = unknownNumbers;
            return this;
        }

        public Settings<TContext> limitDigitsBuffer(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("size can't be smaller than 1");
            }
            this.maxNumberDigits = size;
            return this;
        }

        public Settings<TContext> limitStringBuffer(int size) {
            if (size < 1) {
                throw new IllegalArgumentException("size can't be smaller than 1");
            }
            this.maxStringBuffer = size;
            return this;
        }

        public Settings<TContext> creatorMarker(Class<? extends Annotation> marker, boolean expandVisibility) {
            if (marker == null) {
                throw new IllegalArgumentException("marker can't be null");
            }
            this.creatorMarkers.put(marker, expandVisibility);
            return this;
        }

        public Settings<TContext> with(Configuration conf) {
            if (conf == null) {
                throw new IllegalArgumentException("conf can't be null");
            }
            this.configurations.add(conf);
            return this;
        }

        private Settings<TContext> with(Iterable<Configuration> confs) {
            if (confs != null) {
                for (Configuration c : confs) {
                    this.configurations.add(c);
                }
            }
            return this;
        }
    }

    public static interface ConverterFactory<T> {
        @Nullable
        public T tryCreate(Type var1, DslJson var2);
    }

    public static interface Fallback<TContext> {
        public void serialize(@Nullable Object var1, OutputStream var2) throws IOException;

        @Nullable
        public Object deserialize(@Nullable TContext var1, Type var2, byte[] var3, int var4) throws IOException;

        @Nullable
        public Object deserialize(@Nullable TContext var1, Type var2, InputStream var3) throws IOException;
    }
}

