/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.Logger;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.StateObserver;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/bugsnag/android/LaunchCrashTracker;", "Lcom/bugsnag/android/BaseObservable;", "config", "Lcom/bugsnag/android/internal/ImmutableConfig;", "executor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "(Lcom/bugsnag/android/internal/ImmutableConfig;Ljava/util/concurrent/ScheduledThreadPoolExecutor;)V", "launching", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lcom/bugsnag/android/Logger;", "isLaunching", "", "markLaunchCompleted", "", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nLaunchCrashTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchCrashTracker.kt\ncom/bugsnag/android/LaunchCrashTracker\n+ 2 BaseObservable.kt\ncom/bugsnag/android/BaseObservable\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n31#2,7:45\n38#2:54\n1855#3,2:52\n*S KotlinDebug\n*F\n+ 1 LaunchCrashTracker.kt\ncom/bugsnag/android/LaunchCrashTracker\n*L\n38#1:45,7\n38#1:54\n38#1:52,2\n*E\n"})
public final class LaunchCrashTracker
extends BaseObservable {
    @NotNull
    private final ScheduledThreadPoolExecutor executor;
    @NotNull
    private final AtomicBoolean launching;
    @NotNull
    private final Logger logger;

    @JvmOverloads
    public LaunchCrashTracker(@NotNull ImmutableConfig config, @NotNull ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        this.launching = new AtomicBoolean(true);
        this.logger = config.getLogger();
        long delay = config.getLaunchDurationMillis();
        if (delay > 0L) {
            this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            try {
                this.executor.schedule(() -> LaunchCrashTracker._init_$lambda$0(this), delay, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException exc) {
                this.logger.w("Failed to schedule timer for LaunchCrashTracker", exc);
            }
        }
    }

    public /* synthetic */ LaunchCrashTracker(ImmutableConfig immutableConfig, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        }
        this(immutableConfig, scheduledThreadPoolExecutor);
    }

    public final void markLaunchCompleted() {
        this.executor.shutdown();
        this.launching.set(false);
        BaseObservable this_$iv = this;
        boolean $i$f$updateState$bugsnag_android_core_release = false;
        if (!this_$iv.getObservers$bugsnag_android_core_release().isEmpty()) {
            boolean bl = false;
            StateEvent event$iv = new StateEvent.UpdateIsLaunching(false);
            Iterable $this$forEach$iv$iv = this_$iv.getObservers$bugsnag_android_core_release();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                StateObserver it$iv = (StateObserver)element$iv$iv;
                boolean bl2 = false;
                it$iv.onStateChange(event$iv);
            }
        }
        this.logger.d("App launch period marked as complete");
    }

    public final boolean isLaunching() {
        return this.launching.get();
    }

    @JvmOverloads
    public LaunchCrashTracker(@NotNull ImmutableConfig config) {
        this(config, null, 2, null);
    }

    private static final void _init_$lambda$0(LaunchCrashTracker this$0) {
        this$0.markLaunchCompleted();
    }
}

