/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.internal.DateUtils;
import com.bugsnag.android.internal.StateObserver;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/BreadcrumbState;", "Lcom/bugsnag/android/BaseObservable;", "Lcom/bugsnag/android/JsonStream$Streamable;", "maxBreadcrumbs", "", "callbackState", "Lcom/bugsnag/android/CallbackState;", "logger", "Lcom/bugsnag/android/Logger;", "(ILcom/bugsnag/android/CallbackState;Lcom/bugsnag/android/Logger;)V", "index", "Ljava/util/concurrent/atomic/AtomicInteger;", "store", "", "Lcom/bugsnag/android/Breadcrumb;", "[Lcom/bugsnag/android/Breadcrumb;", "validIndexMask", "add", "", "breadcrumb", "copy", "", "getBreadcrumbIndex", "toStream", "writer", "Lcom/bugsnag/android/JsonStream;", "bugsnag-android-core_release"})
@SourceDebugExtension(value={"SMAP\nBreadcrumbState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreadcrumbState.kt\ncom/bugsnag/android/BreadcrumbState\n+ 2 BaseObservable.kt\ncom/bugsnag/android/BaseObservable\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n31#2,7:99\n38#2:108\n1855#3,2:106\n1855#3,2:109\n*S KotlinDebug\n*F\n+ 1 BreadcrumbState.kt\ncom/bugsnag/android/BreadcrumbState\n*L\n41#1:99,7\n41#1:108\n41#1:106,2\n94#1:109,2\n*E\n"})
public final class BreadcrumbState
extends BaseObservable
implements JsonStream.Streamable {
    private final int maxBreadcrumbs;
    @NotNull
    private final CallbackState callbackState;
    @NotNull
    private final Logger logger;
    private final int validIndexMask;
    @NotNull
    private final Breadcrumb[] store;
    @NotNull
    private final AtomicInteger index;

    public BreadcrumbState(int maxBreadcrumbs, @NotNull CallbackState callbackState, @NotNull Logger logger) {
        this.maxBreadcrumbs = maxBreadcrumbs;
        this.callbackState = callbackState;
        this.logger = logger;
        this.validIndexMask = Integer.MAX_VALUE;
        this.store = new Breadcrumb[this.maxBreadcrumbs];
        this.index = new AtomicInteger(0);
    }

    public final void add(@NotNull Breadcrumb breadcrumb) {
        if (this.maxBreadcrumbs == 0 || !this.callbackState.runOnBreadcrumbTasks(breadcrumb, this.logger)) {
            return;
        }
        int position = this.getBreadcrumbIndex();
        this.store[position] = breadcrumb;
        BaseObservable this_$iv = this;
        boolean $i$f$updateState$bugsnag_android_core_release = false;
        if (!this_$iv.getObservers$bugsnag_android_core_release().isEmpty()) {
            boolean bl = false;
            String string = breadcrumb.impl.message;
            BreadcrumbType breadcrumbType = breadcrumb.impl.type;
            String string2 = DateUtils.toIso8601(breadcrumb.impl.timestamp);
            Map map2 = breadcrumb.impl.metadata;
            if (map2 == null) {
                map2 = new LinkedHashMap();
            }
            StateEvent event$iv = new StateEvent.AddBreadcrumb(string, breadcrumbType, string2, map2);
            Iterable $this$forEach$iv$iv = this_$iv.getObservers$bugsnag_android_core_release();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                StateObserver it$iv = (StateObserver)element$iv$iv;
                boolean bl2 = false;
                it$iv.onStateChange(event$iv);
            }
        }
    }

    private final int getBreadcrumbIndex() {
        int nextValue;
        int currentValue;
        while (!this.index.compareAndSet(currentValue = this.index.get() & this.validIndexMask, nextValue = (currentValue + 1) % this.maxBreadcrumbs)) {
        }
        return currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Breadcrumb> copy() {
        if (this.maxBreadcrumbs == 0) {
            return CollectionsKt.emptyList();
        }
        int tail = -1;
        while (tail == -1) {
            tail = this.index.getAndSet(-1);
        }
        try {
            Object[] result = new Breadcrumb[this.maxBreadcrumbs];
            ArraysKt.copyInto((Object[])this.store, (Object[])result, (int)0, (int)tail, (int)this.maxBreadcrumbs);
            ArraysKt.copyInto((Object[])this.store, (Object[])result, (int)(this.maxBreadcrumbs - tail), (int)0, (int)tail);
            List list = ArraysKt.filterNotNull((Object[])result);
            return list;
        }
        finally {
            this.index.set(tail);
        }
    }

    @Override
    public void toStream(@NotNull JsonStream writer) throws IOException {
        List<Breadcrumb> crumbs = this.copy();
        writer.beginArray();
        Iterable $this$forEach$iv = crumbs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Breadcrumb it = (Breadcrumb)element$iv;
            boolean bl = false;
            it.toStream(writer);
        }
        writer.endArray();
    }
}

